/*
 * Decompiled with CFR 0.152.
 */
package kite.autoharvest.mode;

import java.util.HashSet;
import java.util.Set;
import kite.autoharvest.config.AutoHarvestConfig;
import kite.autoharvest.mode.AutoMode;
import kite.autoharvest.util.BoxUtil;
import kite.autoharvest.util.InteractionHelper;
import kite.autoharvest.util.ItemRefillHelpermain;
import kite.autoharvest.util.ItemRefillHelperoff;
import kite.autoharvest.util.WaterProximityChecker;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class PlantMode
implements AutoMode {
    private static final Set<class_1792> CROP_SEEDS = Set.of(class_1802.field_8317, class_1802.field_8179, class_1802.field_8567, class_1802.field_8309, class_1802.field_46249, class_1802.field_46250);
    private static final class_1792 NETHER_WART_ITEM = class_1802.field_8790;
    private static final class_1792 SUGAR_CANE_ITEM = class_1802.field_17531;
    private static final class_1792 BAMBOO_ITEM = class_1802.field_8648;
    private static final class_1792 COCOA_BEANS_ITEM = class_1802.field_8116;
    private static final class_1792 SWEET_BERRIES_ITEM = class_1802.field_16998;
    private static final Set<class_2248> SUGARCANE_BASE_BLOCKS = Set.of(class_2246.field_10219, class_2246.field_10566, class_2246.field_10253, class_2246.field_28685, class_2246.field_10102, class_2246.field_10534, class_2246.field_10520, class_2246.field_42728, class_2246.field_10402, class_2246.field_37576, class_2246.field_37547, class_2246.field_28681, class_2246.field_54731);
    private static final Set<class_1792> REFILLABLE_PLANT_ITEMS;
    private static final Set<class_2248> JUNGLE_LOG_BLOCKS;
    private static final Set<class_2248> SWEET_BERRY_PLANT;

    private static boolean hasSeed(class_746 player, Set<class_1792> seedItem) {
        if (seedItem.contains(player.method_6047().method_7909())) {
            return true;
        }
        if (seedItem.contains(player.method_6079().method_7909())) {
            return true;
        }
        for (int i = 0; i < 9; ++i) {
            if (!seedItem.contains(player.method_31548().method_5438(i).method_7909())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && !client.field_1724.method_68878() && !client.field_1724.method_7325() && client.field_1687 != null && AutoHarvestConfig.enableRefill()) {
            class_1799 mainHandStack = client.field_1724.method_6047();
            class_1799 offHandStack = client.field_1724.method_6079();
            if (!mainHandStack.method_7960() && mainHandStack.method_7947() < 64 && REFILLABLE_PLANT_ITEMS.contains(mainHandStack.method_7909())) {
                ItemRefillHelpermain.refillHands();
            }
            if (!offHandStack.method_7960() && offHandStack.method_7947() < 64 && REFILLABLE_PLANT_ITEMS.contains(offHandStack.method_7909())) {
                ItemRefillHelperoff.refillOffHand();
            }
        }
        class_638 world = BoxUtil.getWorld();
        class_746 player = BoxUtil.getPlayer();
        if (world == null || player == null) {
            return;
        }
        class_243 playerPos = BoxUtil.getPlayerPos();
        if (playerPos == null) {
            return;
        }
        double radius = AutoHarvestConfig.getInstance().getRadius();
        class_238 searchBox = BoxUtil.createSearchBox(playerPos, radius);
        int radiusInt = (int)Math.ceil(radius);
        for (class_2338 pos : class_2338.method_25996((class_2338)class_2338.method_49638((class_2374)playerPos), (int)radiusInt, (int)radiusInt, (int)radiusInt)) {
            if (!searchBox.method_1006(pos.method_46558()) || BoxUtil.isInSphere(pos, playerPos, radius) || !world.method_8320(pos).method_26215()) continue;
            class_2338 basePos = pos.method_10074();
            class_2248 baseBlock = world.method_8320(basePos).method_26204();
            boolean canPlantCrop = baseBlock == class_2246.field_10362 && PlantMode.hasSeed(player, CROP_SEEDS);
            boolean canPlantSugarcane = SUGARCANE_BASE_BLOCKS.contains(baseBlock) && WaterProximityChecker.isAdjacentToSourceWaterHorizontally((class_1937)world, basePos) && PlantMode.hasSeed(player, Set.of(SUGAR_CANE_ITEM));
            boolean canPlantNetherWart = baseBlock == class_2246.field_10114;
            boolean canPlantBamboo = SUGARCANE_BASE_BLOCKS.contains(baseBlock) && PlantMode.hasSeed(player, Set.of(BAMBOO_ITEM));
            class_2350 cocoaFacing = null;
            class_2338 cocoaLogPos = null;
            for (class_2350 dir : class_2350.class_2353.field_11062) {
                class_2338 logPos = pos.method_10093(dir.method_10153());
                if (!JUNGLE_LOG_BLOCKS.contains(world.method_8320(logPos).method_26204())) continue;
                cocoaFacing = dir;
                cocoaLogPos = logPos;
                break;
            }
            boolean canPlantCocoa = cocoaFacing != null;
            boolean canPlantSweetBerries = SWEET_BERRY_PLANT.contains(baseBlock);
            class_1792 targetSeed = null;
            if (canPlantNetherWart) {
                targetSeed = this.findBestSeed(player, Set.of(NETHER_WART_ITEM));
            } else if (canPlantCocoa) {
                targetSeed = this.findBestSeed(player, Set.of(COCOA_BEANS_ITEM));
            } else if (canPlantSugarcane) {
                targetSeed = this.findBestSeed(player, Set.of(SUGAR_CANE_ITEM));
            } else if (canPlantBamboo) {
                int bambooSpacing = AutoHarvestConfig.bambooRadius();
                if (bambooSpacing == 0) {
                    targetSeed = this.findBestSeed(player, Set.of(BAMBOO_ITEM));
                }
                boolean hasNearbyBamboo = false;
                if (bambooSpacing > 0) {
                    for (int dx = -bambooSpacing; dx <= bambooSpacing; ++dx) {
                        for (int dz = -bambooSpacing; dz <= bambooSpacing; ++dz) {
                            class_2338 checkPos = basePos.method_10069(dx, 1, dz);
                            class_2248 block = world.method_8320(checkPos).method_26204();
                            if (block != class_2246.field_10211 && block != class_2246.field_10108) continue;
                            hasNearbyBamboo = true;
                            break;
                        }
                        if (hasNearbyBamboo) break;
                    }
                }
                if (!hasNearbyBamboo) {
                    targetSeed = this.findBestSeed(player, Set.of(BAMBOO_ITEM));
                }
            } else if (canPlantCrop) {
                targetSeed = this.findBestSeed(player, CROP_SEEDS);
            } else if (canPlantSweetBerries) {
                targetSeed = this.findBestSeed(player, Set.of(SWEET_BERRIES_ITEM));
            }
            if (targetSeed == null) continue;
            class_1268 usedHand = null;
            if (player.method_6047().method_7909() == targetSeed) {
                usedHand = class_1268.field_5808;
            } else if (player.method_6079().method_7909() == targetSeed) {
                usedHand = class_1268.field_5810;
            }
            if (usedHand != null) {
                if (canPlantCocoa) {
                    InteractionHelper.interactBlock(player, cocoaLogPos, usedHand, cocoaFacing);
                } else {
                    InteractionHelper.interactBlock(player, basePos, usedHand, class_2350.field_11036);
                }
                return;
            }
            int currentSlot = player.method_31548().method_67532();
            int bestSlot = -1;
            int minDistance = Integer.MAX_VALUE;
            for (int i = 0; i < 9; ++i) {
                int distance;
                class_1799 stack = player.method_31548().method_5438(i);
                if (stack.method_7960() || stack.method_7909() != targetSeed || (distance = Math.abs(i - currentSlot)) >= minDistance) continue;
                minDistance = distance;
                bestSlot = i;
            }
            if (bestSlot == -1) continue;
            if (AutoHarvestConfig.autoSwitchHotbar()) {
                player.method_31548().method_61496(bestSlot);
            }
            InteractionHelper.interactBlock(player, basePos, class_1268.field_5808, class_2350.field_11036);
            return;
        }
    }

    private class_1792 findBestSeed(class_746 player, Set<class_1792> allowedSeeds) {
        if (allowedSeeds.contains(player.method_6047().method_7909())) {
            return player.method_6047().method_7909();
        }
        if (allowedSeeds.contains(player.method_6079().method_7909())) {
            return player.method_6079().method_7909();
        }
        int currentSlot = player.method_31548().method_67532();
        int bestSlot = -1;
        int minDistance = Integer.MAX_VALUE;
        for (int i = 0; i < 9; ++i) {
            int distance;
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7960() || !allowedSeeds.contains(stack.method_7909()) || (distance = Math.abs(i - currentSlot)) >= minDistance) continue;
            minDistance = distance;
            bestSlot = i;
        }
        return bestSlot != -1 ? player.method_31548().method_5438(bestSlot).method_7909() : null;
    }

    @Override
    public String getName() {
        return class_2561.method_43471((String)"autoharvest.mode.plant").getString();
    }

    @Override
    public void onDisable() {
    }

    static {
        HashSet<class_1792> set = new HashSet<class_1792>(CROP_SEEDS);
        set.add(NETHER_WART_ITEM);
        set.add(SUGAR_CANE_ITEM);
        set.add(BAMBOO_ITEM);
        set.add(COCOA_BEANS_ITEM);
        REFILLABLE_PLANT_ITEMS = Set.copyOf(set);
        JUNGLE_LOG_BLOCKS = Set.of(class_2246.field_10306, class_2246.field_10254, class_2246.field_10303, class_2246.field_10084);
        SWEET_BERRY_PLANT = Set.of(class_2246.field_10219, class_2246.field_10566, class_2246.field_10520, class_2246.field_10253, class_2246.field_10402, class_2246.field_28681, class_2246.field_54731, class_2246.field_28685, class_2246.field_37576, class_2246.field_37547, class_2246.field_10362);
    }
}

