/*
 * Decompiled with CFR 0.152.
 */
package kite.autoharvest;

import kite.autoharvest.command.ModeCommand;
import kite.autoharvest.config.AutoHarvestConfig;
import kite.autoharvest.config.modeEnum;
import kite.autoharvest.manager.ModeManager;
import kite.autoharvest.mode.AutoMode;
import kite.autoharvest.mode.BonemealMode;
import kite.autoharvest.mode.CompositeMode;
import kite.autoharvest.mode.FeedMode;
import kite.autoharvest.mode.FishingMode;
import kite.autoharvest.mode.HarvestMode;
import kite.autoharvest.mode.HoeMode;
import kite.autoharvest.mode.PlantMode;
import kite.autoharvest.mode.WeedMode;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoHarvest
implements ClientModInitializer {
    public static final String MOD_ID = "autoharvest";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"autoharvest");
    public static final class_304.class_11900 AUTOHARVEST_CATEGORY = new class_304.class_11900(class_2960.method_60655((String)"kite", (String)"autoharvest"));
    public static final class_304.class_11900 AUTOHARVEST_CATEGORY_MODE = new class_304.class_11900(class_2960.method_60655((String)"kite", (String)"autoharvest"));
    public static final class_304 TOGGLE_KEY = new class_304("key.autoharvest.toggle", class_3675.class_307.field_1668, 72, AUTOHARVEST_CATEGORY);
    public static final class_304 CYCLE_MODE_KEY = new class_304("key.autoharvest.cycle", class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), AUTOHARVEST_CATEGORY);
    public static final class_304 WEED_KEY = AutoHarvest.createModeKey("weed");
    public static final class_304 PLANT_KEY = AutoHarvest.createModeKey("plant");
    public static final class_304 HARVEST_KEY = AutoHarvest.createModeKey("harvest");
    public static final class_304 FARMER_KEY = AutoHarvest.createModeKey("farmer");
    public static final class_304 BONEMEAL_KEY = AutoHarvest.createModeKey("bonemeal");
    public static final class_304 FEED_KEY = AutoHarvest.createModeKey("feed");
    public static final class_304 FISHING_KEY = AutoHarvest.createModeKey("fishing");
    public static final class_304 HOE_KEY = AutoHarvest.createModeKey("hoeing");

    private static modeEnum getNextMode(modeEnum current) {
        return switch (current) {
            default -> throw new MatchException(null, null);
            case modeEnum.weed -> modeEnum.plant;
            case modeEnum.plant -> modeEnum.harvest;
            case modeEnum.harvest -> modeEnum.farmer;
            case modeEnum.farmer -> modeEnum.bonemeal;
            case modeEnum.bonemeal -> modeEnum.feed;
            case modeEnum.feed -> modeEnum.fishing;
            case modeEnum.fishing -> modeEnum.hoe;
            case modeEnum.hoe -> modeEnum.weed;
        };
    }

    private static class_304 createModeKey(String name) {
        return new class_304("autoharvest.mode." + name, class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), AUTOHARVEST_CATEGORY_MODE);
    }

    public void onInitializeClient() {
        LOGGER.info("Hello AutoHarvest!");
        AutoConfig.register(AutoHarvestConfig.class, GsonConfigSerializer::new);
        ModeCommand.register();
        KeyBindingHelper.registerKeyBinding((class_304)TOGGLE_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)CYCLE_MODE_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)WEED_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)PLANT_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)HARVEST_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)FARMER_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)BONEMEAL_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)FEED_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)FISHING_KEY);
        KeyBindingHelper.registerKeyBinding((class_304)HOE_KEY);
        ClientPlayConnectionEvents.DISCONNECT.register((hander, client) -> ModeManager.INSTANCE.clearMode());
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (CYCLE_MODE_KEY.method_1436()) {
                modeEnum current = AutoHarvestConfig.getInstance().thecurrentMode;
                modeEnum next = AutoHarvest.getNextMode(current);
                switch (next) {
                    case weed: {
                        this.setModeAndNotify(new WeedMode(), modeEnum.weed);
                        break;
                    }
                    case plant: {
                        this.setModeAndNotify(new PlantMode(), modeEnum.plant);
                        break;
                    }
                    case harvest: {
                        this.setModeAndNotify(new HarvestMode(), modeEnum.harvest);
                        break;
                    }
                    case farmer: {
                        this.setModeAndNotify(CompositeMode.farmer(), modeEnum.farmer);
                        break;
                    }
                    case bonemeal: {
                        this.setModeAndNotify(new BonemealMode(), modeEnum.bonemeal);
                        break;
                    }
                    case feed: {
                        this.setModeAndNotify(new FeedMode(), modeEnum.feed);
                        break;
                    }
                    case fishing: {
                        this.setModeAndNotify(new FishingMode(), modeEnum.fishing);
                        break;
                    }
                    case hoe: {
                        this.setModeAndNotify(new HoeMode(), modeEnum.hoe);
                    }
                }
            }
            if (TOGGLE_KEY.method_1436()) {
                ModeManager.INSTANCE.toggle();
            }
            if (WEED_KEY.method_1436()) {
                this.setModeAndNotify(new WeedMode(), modeEnum.weed);
            } else if (PLANT_KEY.method_1436()) {
                this.setModeAndNotify(new PlantMode(), modeEnum.plant);
            } else if (HARVEST_KEY.method_1436()) {
                this.setModeAndNotify(new HarvestMode(), modeEnum.harvest);
            } else if (FARMER_KEY.method_1436()) {
                this.setModeAndNotify(CompositeMode.farmer(), modeEnum.farmer);
            } else if (BONEMEAL_KEY.method_1436()) {
                this.setModeAndNotify(new BonemealMode(), modeEnum.bonemeal);
            } else if (FEED_KEY.method_1436()) {
                this.setModeAndNotify(new FeedMode(), modeEnum.feed);
            } else if (FISHING_KEY.method_1436()) {
                this.setModeAndNotify(new FishingMode(), modeEnum.fishing);
            } else if (HOE_KEY.method_1436()) {
                this.setModeAndNotify(new HoeMode(), modeEnum.hoe);
            }
            ModeManager.INSTANCE.tick();
        });
    }

    private void setModeAndNotify(AutoMode mode, modeEnum configEnum) {
        class_746 player = class_310.method_1551().field_1724;
        ModeManager.INSTANCE.setCurrentMode(mode);
        AutoHarvestConfig.getInstance().thecurrentMode = configEnum;
        AutoHarvestConfig.save();
        if (player != null) {
            String modeName = switch (configEnum) {
                default -> throw new MatchException(null, null);
                case modeEnum.weed -> class_2561.method_43471((String)"autoharvest.mode.weed").getString();
                case modeEnum.plant -> class_2561.method_43471((String)"autoharvest.mode.plant").getString();
                case modeEnum.harvest -> class_2561.method_43471((String)"autoharvest.mode.harvest").getString();
                case modeEnum.farmer -> CompositeMode.farmmerode_string();
                case modeEnum.bonemeal -> class_2561.method_43471((String)"autoharvest.mode.bonemeal").getString();
                case modeEnum.feed -> class_2561.method_43471((String)"autoharvest.mode.feed").getString();
                case modeEnum.fishing -> class_2561.method_43471((String)"autoharvest.mode.fishing").getString();
                case modeEnum.hoe -> class_2561.method_43471((String)"autoharvest.mode.hoeing").getString();
            };
            player.method_7353((class_2561)class_2561.method_43470((String)(class_2561.method_43471((String)"autoharvest.mode.switch").getString() + modeName)), false);
        }
    }
}

