/*
 * Decompiled with CFR 0.152.
 */
package kite.autoharvest.config;

import kite.autoharvest.config.modeEnum;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;

@Config(name="autoharvest")
public class AutoHarvestConfig
implements ConfigData {
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(min=1L, max=20L)
    public int ticksPerAction = 1;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.BoundedDiscrete(min=10L, max=65L)
    public int radiusCenti = 45;
    @ConfigEntry.Gui.Tooltip
    @ConfigEntry.Gui.EnumHandler
    public modeEnum thecurrentMode = modeEnum.plant;
    @ConfigEntry.Gui.Tooltip
    public boolean enableRefill = true;
    @ConfigEntry.Gui.Tooltip
    public boolean autoSwitchFortuneTool = true;
    @ConfigEntry.BoundedDiscrete(min=1L, max=60L)
    @ConfigEntry.Gui.Tooltip
    public long coolDown = 5L;
    @ConfigEntry.BoundedDiscrete(min=0L, max=3L)
    @ConfigEntry.Gui.Tooltip
    public int bambooRadius = 0;
    @ConfigEntry.Gui.Tooltip
    public boolean autoSwitchHotbar = true;
    @ConfigEntry.BoundedDiscrete(min=10L, max=100L)
    @ConfigEntry.Gui.Tooltip
    public int fishingReCastDelay = 10;
    @ConfigEntry.Gui.Tooltip
    public boolean autoSwitchRod = true;

    public double getRadius() {
        return (double)this.radiusCenti / 10.0;
    }

    public static AutoHarvestConfig getInstance() {
        return (AutoHarvestConfig)AutoConfig.getConfigHolder(AutoHarvestConfig.class).getConfig();
    }

    public static int ticksPerAction() {
        return AutoHarvestConfig.getInstance().ticksPerAction;
    }

    public static double radius() {
        return AutoHarvestConfig.getInstance().getRadius();
    }

    public static modeEnum thecurrentMode() {
        return AutoHarvestConfig.getInstance().thecurrentMode;
    }

    public static void save() {
        AutoConfig.getConfigHolder(AutoHarvestConfig.class).save();
    }

    public static boolean enableRefill() {
        return AutoHarvestConfig.getInstance().enableRefill;
    }

    public static boolean autoSwitchFortuneTool() {
        return AutoHarvestConfig.getInstance().autoSwitchFortuneTool;
    }

    public static long coolDown() {
        return AutoHarvestConfig.getInstance().coolDown * 1000L;
    }

    public static int bambooRadius() {
        return AutoHarvestConfig.getInstance().bambooRadius;
    }

    public static boolean autoSwitchHotbar() {
        return AutoHarvestConfig.getInstance().autoSwitchHotbar;
    }

    public static int fishingReCastDelay() {
        return AutoHarvestConfig.getInstance().fishingReCastDelay;
    }

    public static boolean autoSwitchRod() {
        return AutoHarvestConfig.getInstance().autoSwitchRod;
    }
}

