/*
 * Decompiled with CFR 0.152.
 */
package kite.autoharvest.mode;

import kite.autoharvest.config.AutoHarvestConfig;
import kite.autoharvest.mode.AutoMode;
import kite.autoharvest.util.InteractionHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1536;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class FishingMode
implements AutoMode {
    private long fishBitesAt = 0L;
    private long bobberSpawnTime = 0L;
    private double baselineY = Double.NaN;
    private double lastBobberX = Double.NaN;
    private double lastBobberY = Double.NaN;
    private double lastBobberZ = Double.NaN;
    private int stationaryTicks = 0;
    private long firstStuckTime = -1L;
    private static final int STATIONARY_THRESHOLD_TICKS = 60;
    private static final long REPEAT_MESSAGE_INTERVAL = 100L;
    private static final double HORIZONTAL_MOVEMENT_THRESHOLD = 0.01;
    private static final double DEPTH_THRESHOLD = 0.06;
    private static final int STABLE_DELAY_TICKS = 30;

    @Override
    public void tick() {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            this.resetAllState();
            return;
        }
        class_1268 rodHand = this.getFishingRodHand(player);
        if (rodHand == null) {
            int rodSlot = this.findFishingRodSlot(player);
            if (rodSlot != -1) {
                if (AutoHarvestConfig.autoSwitchRod()) {
                    player.method_31548().method_61496(rodSlot);
                }
                rodHand = this.getFishingRodHand(player);
            }
            if (rodHand == null) {
                this.resetAllState();
                return;
            }
        }
        class_1536 bobber = player.field_7513;
        long currentTime = this.getCurrentWorldTime();
        if (this.fishBitesAt != 0L) {
            int delay = AutoHarvestConfig.fishingReCastDelay();
            if (currentTime >= this.fishBitesAt + (long)delay) {
                InteractionHelper.interactItem(player, rodHand);
                this.resetAllState();
            }
            return;
        }
        if (bobber == null || !bobber.method_5805()) {
            this.resetAllState();
            return;
        }
        if (this.bobberSpawnTime == 0L) {
            this.bobberSpawnTime = currentTime;
        }
        if (currentTime < this.bobberSpawnTime + 30L) {
            if (Double.isNaN(this.baselineY) || bobber.method_23318() < this.baselineY) {
                this.baselineY = bobber.method_23318();
            }
            this.updateStationaryState(bobber, false, currentTime);
            return;
        }
        if (Double.isNaN(this.baselineY)) {
            this.baselineY = bobber.method_23318();
        }
        this.updateStationaryState(bobber, true, currentTime);
        this.checkAndNotifyStuck(player, currentTime);
        if (this.isFishBites(bobber, this.baselineY)) {
            this.fishBitesAt = currentTime;
            InteractionHelper.interactItem(player, rodHand);
        }
    }

    private int findFishingRodSlot(class_746 player) {
        for (int i = 0; i < 9; ++i) {
            if (!player.method_31548().method_5438(i).method_31574(class_1802.field_8378)) continue;
            return i;
        }
        return -1;
    }

    private void updateStationaryState(class_1536 bobber, boolean allowStuckDetection, long currentTime) {
        boolean hasMoved;
        double x = bobber.method_23317();
        double y = bobber.method_23318();
        double z = bobber.method_23321();
        boolean bl = hasMoved = Double.isNaN(this.lastBobberX) || x != this.lastBobberX || y != this.lastBobberY || z != this.lastBobberZ;
        if (hasMoved) {
            this.lastBobberX = x;
            this.lastBobberY = y;
            this.lastBobberZ = z;
            this.stationaryTicks = 0;
            this.firstStuckTime = -1L;
        } else {
            ++this.stationaryTicks;
            if (allowStuckDetection && this.firstStuckTime == -1L && this.stationaryTicks >= 60) {
                this.firstStuckTime = currentTime;
            }
        }
    }

    private void checkAndNotifyStuck(class_746 player, long currentTime) {
        if (this.firstStuckTime == -1L) {
            return;
        }
        if ((currentTime - this.firstStuckTime) % 100L == 0L && currentTime > this.firstStuckTime) {
            player.method_7353((class_2561)class_2561.method_43471((String)"autoharvest.mode.fishing.error"), true);
        }
    }

    private boolean isFishBites(class_1536 bobber, double baselineY) {
        double dx = bobber.method_23317() - bobber.field_6014;
        double dz = bobber.method_23321() - bobber.field_5969;
        double currentY = bobber.method_23318();
        boolean horizontalStill = Math.abs(dx) < 0.01 && Math.abs(dz) < 0.01;
        boolean hasSunk = baselineY - currentY > 0.06;
        return horizontalStill && hasSunk;
    }

    private void resetAllState() {
        this.fishBitesAt = 0L;
        this.bobberSpawnTime = 0L;
        this.baselineY = Double.NaN;
        this.lastBobberZ = Double.NaN;
        this.lastBobberY = Double.NaN;
        this.lastBobberX = Double.NaN;
        this.stationaryTicks = 0;
        this.firstStuckTime = -1L;
    }

    private long getCurrentWorldTime() {
        class_638 world = class_310.method_1551().field_1687;
        return world != null ? world.method_8510() : 0L;
    }

    private class_1268 getFishingRodHand(class_746 player) {
        if (player.method_6047().method_31574(class_1802.field_8378)) {
            return class_1268.field_5808;
        }
        if (player.method_6079().method_31574(class_1802.field_8378)) {
            return class_1268.field_5810;
        }
        return null;
    }

    @Override
    public String getName() {
        return class_2561.method_43471((String)"autoharvest.mode.fishing").getString();
    }

    @Override
    public void onDisable() {
        this.resetAllState();
    }
}

