/*
 * Decompiled with CFR 0.152.
 */
package kite.autoharvest.mode;

import java.util.Set;
import kite.autoharvest.config.AutoHarvestConfig;
import kite.autoharvest.mode.AutoMode;
import kite.autoharvest.util.BoxUtil;
import kite.autoharvest.util.InteractionHelper;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3489;
import net.minecraft.class_5455;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class HarvestMode
implements AutoMode {
    private static final Set<class_2248> HARVEST_CROPS = Set.of(class_2246.field_10293, class_2246.field_10609, class_2246.field_10247, class_2246.field_10341, class_2246.field_9974, class_2246.field_10424, class_2246.field_16999);

    @Override
    public void tick() {
        class_638 world = BoxUtil.getWorld();
        class_746 player = BoxUtil.getPlayer();
        if (world == null || player == null) {
            return;
        }
        class_243 playerPos = BoxUtil.getPlayerPos();
        if (playerPos == null) {
            return;
        }
        double radius = AutoHarvestConfig.getInstance().getRadius();
        class_238 searchBox = BoxUtil.createSearchBox(playerPos, radius);
        int radiusInt = (int)Math.ceil(radius);
        for (class_2338 pos : class_2338.method_25996((class_2338)class_2338.method_49638((class_2374)playerPos), (int)radiusInt, (int)radiusInt, (int)radiusInt)) {
            class_2680 state;
            class_2248 block;
            if (!searchBox.method_1006(pos.method_46558()) || BoxUtil.isInSphere(pos, playerPos, radius) || !HARVEST_CROPS.contains(block = (state = world.method_8320(pos)).method_26204())) continue;
            if (block == class_2246.field_10424) {
                class_2338 secondpos;
                if (world.method_8320(pos.method_10074()).method_27852(class_2246.field_10424) || !world.method_8320(secondpos = pos.method_10084()).method_27852(class_2246.field_10424) || !this.tryHarvest(player, pos.method_10084())) continue;
                return;
            }
            if (state.method_26204() == class_2246.field_16999 && !this.isNotFullyGrown(state, block)) {
                int fortuneSlot;
                if (AutoHarvestConfig.autoSwitchFortuneTool() && (fortuneSlot = this.findFortuneToolSlot(player)) != -1) {
                    player.method_31548().method_61496(fortuneSlot);
                }
                InteractionHelper.interactBlock(player, pos, class_1268.field_5808, class_2350.field_11036);
                return;
            }
            if (this.isNotFullyGrown(state, block) || !this.tryHarvest(player, pos)) continue;
            return;
        }
    }

    private boolean isNotFullyGrown(class_2680 state, class_2248 block) {
        if (block == class_2246.field_9974) {
            return (Integer)state.method_11654((class_2769)class_2741.field_12497) < 3;
        }
        if (block == class_2246.field_16999) {
            return (Integer)state.method_11654((class_2769)class_2741.field_12497) < 2;
        }
        if (block instanceof class_2302) {
            if (block == class_2246.field_10341) {
                return (Integer)state.method_11654((class_2769)class_2741.field_12497) < 3;
            }
            return (Integer)state.method_11654((class_2769)class_2741.field_12550) < 7;
        }
        return false;
    }

    private boolean tryHarvest(class_746 player, class_2338 pos) {
        int fortuneSlot;
        if (AutoHarvestConfig.autoSwitchFortuneTool() && (fortuneSlot = this.findFortuneToolSlot(player)) != -1) {
            player.method_31548().method_61496(fortuneSlot);
        }
        InteractionHelper.breakBlock(pos, class_2350.field_11036);
        return true;
    }

    private int findFortuneToolSlot(class_746 player) {
        class_5455 registryManager = player.method_73183().method_30349();
        class_2378 enchantmentRegistry = registryManager.method_30530(class_7924.field_41265);
        for (int i = 0; i < 9; ++i) {
            class_6880.class_6883 fortuneEntry;
            class_9304 enchantments;
            int fortuneLevel;
            class_1792 item;
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7960() || !this.isHarvestTool(item = stack.method_7909()) || (fortuneLevel = (enchantments = (class_9304)stack.method_58695(class_9334.field_49633, (Object)class_9304.field_49385)).method_57536((class_6880)(fortuneEntry = enchantmentRegistry.method_46747(class_1893.field_9130)))) < 1) continue;
            return i;
        }
        return -1;
    }

    private boolean isHarvestTool(class_1792 item) {
        if (item == null) {
            return false;
        }
        class_1799 stack = new class_1799((class_1935)item);
        return stack.method_31573(class_3489.field_42612) || stack.method_31573(class_3489.field_42615) || stack.method_31573(class_3489.field_42613) || stack.method_31573(class_3489.field_42614);
    }

    @Override
    public String getName() {
        return class_2561.method_43471((String)"autoharvest.mode.harvest").getString();
    }

    @Override
    public void onDisable() {
    }
}

