/*
 * Decompiled with CFR 0.152.
 */
package skylandsupport.item;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import skylandsupport.block.SkylandsPortalBlock;

public class SkylandsItem
extends Item {
    public SkylandsItem(Item.Properties properties) {
        super(properties.rarity(Rarity.UNCOMMON).durability(64));
    }

    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, TooltipDisplay tooltipDisplay, Consumer<Component> componentConsumer, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, tooltipDisplay, componentConsumer, flag);
        componentConsumer.accept((Component)Component.translatable((String)"item.skylands_upport.skylands.description_0"));
    }

    public InteractionResult useOn(UseOnContext context) {
        Player entity = context.getPlayer();
        BlockPos pos = context.getClickedPos().relative(context.getClickedFace());
        ItemStack itemstack = context.getItemInHand();
        Level world = context.getLevel();
        if (!entity.mayUseItemAt(pos, context.getClickedFace(), itemstack)) {
            return InteractionResult.FAIL;
        }
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        boolean success = false;
        if (world.isEmptyBlock(pos)) {
            SkylandsPortalBlock.portalSpawn(world, pos);
            itemstack.hurtAndBreak(1, (LivingEntity)entity, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
            success = true;
        }
        return success ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }
}

