/*
 * Decompiled with CFR 0.152.
 */
package me.ts.chromaworldborder.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.ts.chromaworldborder.ChromaWorldBorder;
import me.ts.chromaworldborder.config.Options;
import net.fabricmc.loader.api.FabricLoader;

public class Configuration {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().create();
    private static final Path CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("chromaworldborder.json");
    private Options options = this.loadConfig();

    public Options getOptions() {
        return this.options;
    }

    public Options loadConfig() {
        Options options;
        block9: {
            if (!Files.exists(CONFIG_FILE, new LinkOption[0])) {
                this.options = new Options();
                this.saveConfig();
            }
            BufferedReader reader = Files.newBufferedReader(CONFIG_FILE);
            try {
                options = (Options)GSON.fromJson((Reader)reader, Options.class);
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    ChromaWorldBorder.LOGGER.error("Failed to read configuration!", (Throwable)e);
                    return new Options();
                }
            }
            reader.close();
        }
        return options;
    }

    public void saveConfig() {
        try {
            if (CONFIG_FILE.toFile().createNewFile()) {
                ChromaWorldBorder.LOGGER.info("Created configuration file!");
            }
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_FILE, new OpenOption[0]);){
                GSON.toJson((Object)this.options, (Appendable)writer);
                ChromaWorldBorder.LOGGER.info("Saved configuration file!");
            }
        }
        catch (Exception e) {
            ChromaWorldBorder.LOGGER.error("Failed to save configuration!", (Throwable)e);
        }
    }
}

