/*
 * Decompiled with CFR 0.152.
 */
package dev.nyon.bbm.asm;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.nyon.bbm.config.Config;
import dev.nyon.bbm.config.ConfigKt;
import dev.nyon.bbm.logic.BbmBoat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.ModifyConstant;

@Mixin(value={Boat.class})
abstract class BoatMixin
extends Entity
implements BbmBoat {
    @Unique
    private boolean jumpCollision = false;
    @Shadow
    private Boat.Status status;
    @Unique
    private Boat instance = (Boat)this;

    public BoatMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void setJumpCollision(boolean b) {
        this.jumpCollision = b;
    }

    @Override
    public boolean getJumpCollision() {
        return this.jumpCollision;
    }

    @Unique
    private List<BlockState> getCarryingBlocks() {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        AABB aABB = this.getBoundingBox();
        AABB aABB2 = new AABB(aABB.minX, aABB.minY - 0.001, aABB.minZ, aABB.maxX, aABB.minY, aABB.maxZ);
        int i = Mth.floor((double)aABB2.minX) - 1;
        int j = Mth.ceil((double)aABB2.maxX) + 1;
        int k = Mth.floor((double)aABB2.minY) - 1;
        int l = Mth.ceil((double)aABB2.maxY) + 1;
        int m = Mth.floor((double)aABB2.minZ) - 1;
        int n = Mth.ceil((double)aABB2.maxZ) + 1;
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int p = i; p < j; ++p) {
            for (int q = m; q < n; ++q) {
                int r = (p != i && p != j - 1 ? 0 : 1) + (q != m && q != n - 1 ? 0 : 1);
                if (r == 2) continue;
                for (int s = k; s < l; ++s) {
                    if (r > 0 && (s == k || s == l - 1)) continue;
                    mutableBlockPos.set(p, s, q);
                    BlockState blockState = this.level().getBlockState((BlockPos)mutableBlockPos);
                    states.add(blockState);
                }
            }
        }
        return states;
    }

    @ModifyExpressionValue(method={"floatBoat()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/vehicle/Boat;getDeltaMovement()Lnet/minecraft/world/phys/Vec3;", ordinal=1)})
    private Vec3 changeMovement(Vec3 original) {
        if (this.failsPlayerCondition()) {
            return original;
        }
        BbmBoat bbmBoat = (BbmBoat)this.instance;
        switch (this.status) {
            case ON_LAND: {
                List<BlockState> carryingBlocks;
                if (!ConfigKt.getActiveConfig().getBoostOnBlocks() && !ConfigKt.getActiveConfig().getBoostOnIce()) {
                    return original;
                }
                if (ConfigKt.getActiveConfig().getBoostOnIce() && (carryingBlocks = this.getCarryingBlocks()).stream().noneMatch(state -> state.is(BlockTags.ICE))) {
                    return original;
                }
                if (bbmBoat.getJumpCollision() || this.horizontalCollision) break;
                return original;
            }
            case IN_WATER: {
                if (!ConfigKt.getActiveConfig().getBoostOnWater()) {
                    return original;
                }
                if (bbmBoat.getJumpCollision() || this.horizontalCollision) break;
                return original;
            }
            case UNDER_WATER: 
            case UNDER_FLOWING_WATER: {
                if (ConfigKt.getActiveConfig().getBoostUnderwater()) break;
                return original;
            }
            case IN_AIR: {
                return original;
            }
        }
        bbmBoat.setJumpCollision(false);
        return new Vec3(original.x, (double)ConfigKt.getActiveConfig().getStepHeight(), original.z);
    }

    @ModifyConstant(method={"tick()V"}, constant={@Constant(floatValue=60.0f, ordinal=0)})
    private float changeEjectTime(float constant) {
        Config config2 = ConfigKt.getActiveConfig();
        if (config2 == null) {
            return constant;
        }
        return config2.getPlayerEjectTicks();
    }

    @Unique
    private boolean failsPlayerCondition() {
        Config config2 = ConfigKt.getActiveConfig();
        if (config2 == null) {
            return true;
        }
        if (!config2.getOnlyForPlayers()) {
            return false;
        }
        return this.getPassengers().stream().noneMatch(entity -> entity instanceof Player);
    }
}

