/*
 * Decompiled with CFR 0.152.
 */
package dev.nyon.bbm.asm;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import dev.nyon.bbm.config.Config;
import dev.nyon.bbm.config.ConfigCacheKt;
import dev.nyon.bbm.config.ConfigKt;
import dev.nyon.bbm.extensions.NetworkingKt;
import dev.nyon.bbm.logic.BbmBoat;
import dev.nyon.bbm.logic.JumpCollisionPacket;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Unique
    private boolean expandCollision = false;
    @Unique
    private Entity instance = (Entity)this;

    @Shadow
    protected abstract Vec3 collide(Vec3 var1);

    @Shadow
    private static Vec3 collideWithShapes(Vec3 movement, AABB entityBoundingBox, List<VoxelShape> shapes) {
        return null;
    }

    @ModifyArg(method={"collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;collideBoundingBox(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/level/Level;Ljava/util/List;)Lnet/minecraft/world/phys/Vec3;", ordinal=0), index=2)
    private AABB changeBoatBox(Entity entity, Vec3 movement, AABB box, Level world, List<VoxelShape> shapes) {
        if (!this.expandCollision) {
            return box;
        }
        if (!(entity instanceof AbstractBoat)) {
            return box;
        }
        AbstractBoat boat = (AbstractBoat)entity;
        Config config2 = ConfigKt.getActiveConfig();
        if (config2 == null) {
            return box;
        }
        if (config2.getBoosting().getOnlyForPlayers() && boat.getPassengers().stream().filter(passenger -> passenger instanceof Player).toList().isEmpty()) {
            return box;
        }
        return box.inflate(config2.getBoosting().getExtraCollisionDetectionRange(), 0.0, config2.getBoosting().getExtraCollisionDetectionRange());
    }

    @Redirect(method={"collideBoundingBox(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/level/Level;Ljava/util/List;)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;collideWithShapes(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Ljava/util/List;)Lnet/minecraft/world/phys/Vec3;"))
    private static Vec3 checkForHorizontalCollision(Vec3 vec3, AABB bB, List<VoxelShape> foundCollisions, @Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, Level world, List<VoxelShape> expectedCollisions) {
        if (!(entity instanceof BbmBoat)) {
            return EntityMixin.collideWithShapes(vec3, bB, foundCollisions);
        }
        BbmBoat bbmBoat = (BbmBoat)entity;
        Set<Block> allowedSupportingBlocks = ConfigCacheKt.getAllowedCollidingBlocks();
        if (!allowedSupportingBlocks.isEmpty()) {
            boolean correctCollision = foundCollisions.stream().anyMatch(shape -> {
                BlockPos blockPos = new BlockPos(((Double)shape.getCoords(Direction.Axis.X).getFirst()).intValue(), ((Double)shape.getCoords(Direction.Axis.Y).getFirst()).intValue(), ((Double)shape.getCoords(Direction.Axis.Z).getFirst()).intValue());
                BlockState blockState = world.getBlockState(blockPos);
                return allowedSupportingBlocks.contains(blockState.getBlock());
            });
            bbmBoat.setCorrectCollision(correctCollision);
        }
        return EntityMixin.collideWithShapes(vec3, bB, foundCollisions);
    }

    @ModifyExpressionValue(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;")})
    private Vec3 setBoatCollision(Vec3 movement) {
        AbstractBoat boat;
        Entity entity;
        Vec3 original;
        block10: {
            block9: {
                original = this.collide(movement);
                Config config2 = ConfigKt.getActiveConfig();
                if (config2 == null) {
                    return original;
                }
                if (config2.getBoosting().getExtraCollisionDetectionRange() == 0.0) {
                    return original;
                }
                entity = this.instance;
                if (!(entity instanceof AbstractBoat)) break block9;
                boat = (AbstractBoat)entity;
                entity = this.instance;
                if (entity instanceof BbmBoat) break block10;
            }
            return original;
        }
        BbmBoat bbmBoat = (BbmBoat)entity;
        if (!boat.hasControllingPassenger()) {
            return original;
        }
        this.expandCollision = true;
        Vec3 withFakeBb = this.collide(movement);
        this.expandCollision = false;
        boolean xEqual = Mth.equal((double)movement.x, (double)withFakeBb.x);
        boolean zEqual = Mth.equal((double)movement.z, (double)withFakeBb.z);
        if (xEqual && zEqual) {
            return original;
        }
        if (!ConfigCacheKt.getAllowedCollidingBlocks().isEmpty() && !bbmBoat.getCorrectCollision()) {
            return original;
        }
        bbmBoat.setJumpCollision(true);
        LivingEntity controllingPassenger = this.instance.getControllingPassenger();
        if (!(controllingPassenger instanceof ServerPlayer)) {
            return original;
        }
        ServerPlayer player = (ServerPlayer)controllingPassenger;
        UUID id = this.instance.getUUID();
        NetworkingKt.sendToClient(player, new JumpCollisionPacket(id));
        return original;
    }
}

