/*
 * Decompiled with CFR 0.152.
 */
package dev.nyon.bbm.logic;

import dev.nyon.bbm.extensions.ResourceLocationKt;
import dev.nyon.bbm.logic.BbmBoat;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.Transient;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001a\u0010\u0015\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0018\u001a\u00020\u0017H\u00d6\u0001\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u000f\u00a8\u0006 "}, d2={"Ldev/nyon/bbm/logic/JumpCollisionPacket;", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload;", "Ljava/util/UUID;", "id", "<init>", "(Ljava/util/UUID;)V", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "type", "()Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "Lnet/minecraft/world/entity/player/Player;", "player", "", "handle", "(Lnet/minecraft/world/entity/player/Player;)V", "component1", "()Ljava/util/UUID;", "copy", "(Ljava/util/UUID;)Ldev/nyon/bbm/logic/JumpCollisionPacket;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/UUID;", "getId", "Companion", "better-boat-movement"})
public final class JumpCollisionPacket
implements CustomPacketPayload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UUID id;
    @NotNull
    private static final CustomPacketPayload.Type<JumpCollisionPacket> packetType;
    @NotNull
    private static final StreamCodec<FriendlyByteBuf, JumpCollisionPacket> codec;

    public JumpCollisionPacket(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.id = id;
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return packetType;
    }

    public final void handle(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Entity entity = player.level().getEntity(this.id);
        BbmBoat bbmBoat = entity instanceof BbmBoat ? (BbmBoat)entity : null;
        if (bbmBoat == null) {
            return;
        }
        BbmBoat boat = bbmBoat;
        boat.setJumpCollision(true);
    }

    @NotNull
    public final UUID component1() {
        return this.id;
    }

    @NotNull
    public final JumpCollisionPacket copy(@NotNull UUID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new JumpCollisionPacket(id);
    }

    public static /* synthetic */ JumpCollisionPacket copy$default(JumpCollisionPacket jumpCollisionPacket, UUID uUID, int n, Object object) {
        if ((n & 1) != 0) {
            uUID = jumpCollisionPacket.id;
        }
        return jumpCollisionPacket.copy(uUID);
    }

    @NotNull
    public String toString() {
        return "JumpCollisionPacket(id=" + this.id + ")";
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JumpCollisionPacket)) {
            return false;
        }
        JumpCollisionPacket jumpCollisionPacket = (JumpCollisionPacket)other;
        return Intrinsics.areEqual((Object)this.id, (Object)jumpCollisionPacket.id);
    }

    static {
        ResourceLocation resourceLocation = ResourceLocationKt.resourceLocation("bbm:jump_collision");
        Intrinsics.checkNotNull((Object)resourceLocation);
        packetType = new CustomPacketPayload.Type(resourceLocation);
        codec = (StreamCodec)new StreamCodec<FriendlyByteBuf, JumpCollisionPacket>(){

            public JumpCollisionPacket decode(FriendlyByteBuf buf) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                UUID id = buf.readUUID();
                Intrinsics.checkNotNull((Object)id);
                return new JumpCollisionPacket(id);
            }

            public void encode(FriendlyByteBuf buf, JumpCollisionPacket packet) {
                Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
                buf.writeUUID(packet.getId());
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R&\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u0007\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\b\u0010\tR,\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00050\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u0012\u0004\b\u0011\u0010\u0003\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Ldev/nyon/bbm/logic/JumpCollisionPacket$Companion;", "", "<init>", "()V", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "Ldev/nyon/bbm/logic/JumpCollisionPacket;", "packetType", "Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "getPacketType", "()Lnet/minecraft/network/protocol/common/custom/CustomPacketPayload$Type;", "getPacketType$annotations", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "codec", "Lnet/minecraft/network/codec/StreamCodec;", "getCodec", "()Lnet/minecraft/network/codec/StreamCodec;", "getCodec$annotations", "better-boat-movement"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CustomPacketPayload.Type<JumpCollisionPacket> getPacketType() {
            return packetType;
        }

        @Transient
        public static /* synthetic */ void getPacketType$annotations() {
        }

        @NotNull
        public final StreamCodec<FriendlyByteBuf, JumpCollisionPacket> getCodec() {
            return codec;
        }

        @Transient
        public static /* synthetic */ void getCodec$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

