/*
 * Decompiled with CFR 0.152.
 */
package dev.nyon.bbm.util;

import dev.nyon.bbm.config.Config;
import dev.nyon.bbm.config.ConfigCacheKt;
import dev.nyon.bbm.config.ConfigKt;
import dev.nyon.bbm.logic.BbmBoat;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CompatMixinHelper {
    public static void checkForHorizontalCollision(Entity entity, List<VoxelShape> blockCollisions, Level world) {
        boolean correctCollision;
        if (!(entity instanceof BbmBoat)) {
            return;
        }
        BbmBoat bbmBoat = (BbmBoat)entity;
        Set<Block> allowedSupportingBlocks = ConfigCacheKt.getAllowedCollidingBlocks();
        if (!allowedSupportingBlocks.isEmpty() && (correctCollision = blockCollisions.stream().anyMatch(shape -> {
            BlockPos blockPos = new BlockPos(((Double)shape.getCoords(Direction.Axis.X).getFirst()).intValue(), ((Double)shape.getCoords(Direction.Axis.Y).getFirst()).intValue(), ((Double)shape.getCoords(Direction.Axis.Z).getFirst()).intValue());
            BlockState blockState = world.getBlockState(blockPos);
            return allowedSupportingBlocks.contains(blockState.getBlock());
        }))) {
            bbmBoat.setCorrectCollision(true);
        }
    }

    public static AABB expandBox(AABB original, Entity entity) {
        if (!(entity instanceof BbmBoat)) {
            return original;
        }
        BbmBoat bbmBoat = (BbmBoat)entity;
        if (!bbmBoat.getExpandBb()) {
            return original;
        }
        if (!(entity instanceof AbstractBoat)) {
            return original;
        }
        AbstractBoat boat = (AbstractBoat)entity;
        Config config2 = ConfigKt.getActiveConfig();
        if (config2 == null) {
            return original;
        }
        if (config2.getBoosting().getOnlyForPlayers() && boat.getPassengers().stream().filter(passenger -> passenger instanceof Player).toList().isEmpty()) {
            return original;
        }
        return original.inflate(config2.getBoosting().getExtraCollisionDetectionRange(), 0.0, config2.getBoosting().getExtraCollisionDetectionRange());
    }
}

