/*
 * Decompiled with CFR 0.152.
 */
package dev.nyon.bbm.asm;

import dev.nyon.bbm.KeyBindings;
import dev.nyon.bbm.config.Config;
import dev.nyon.bbm.config.ConfigKt;
import dev.nyon.bbm.extensions.DistKt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Boat.class})
public abstract class BoatClientMixin
extends Entity {
    public BoatClientMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void triggerJump(CallbackInfo ci) {
        if (!DistKt.isClient()) {
            return;
        }
        Config config2 = ConfigKt.getActiveConfig();
        if (config2 == null) {
            return;
        }
        if (!KeyBindings.INSTANCE.getJumpKeyBind().isDown() || !config2.getKeybind().getAllowJumpKeybind()) {
            return;
        }
        if (config2.getKeybind().getOnlyKeybindJumpOnGroundOrWater() && !this.onGround() && !this.isInWater() && !this.isUnderWater()) {
            return;
        }
        this.addDeltaMovement(new Vec3(0.0, (double)config2.getStepHeight() * config2.getKeybind().getKeybindJumpHeightMultiplier(), 0.0));
    }
}

