/*
 * Decompiled with CFR 0.152.
 */
package xyz.lordrektor.itemframetooltip.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;

@Environment(value=EnvType.CLIENT)
public class TooltipConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("itemframetooltip.json");
    private static TooltipConfig INSTANCE = null;
    public Position position = Position.CURSOR_BOTTOM_RIGHT;
    public int offsetX = 12;
    public int offsetY = 0;
    public int paddingX = 4;
    public int paddingY = 4;
    public int tooltipBackgroundColor = -267386864;
    public int tooltipBorderColor = 0x505000FF;
    public int tooltipItemBorderColor = -8355712;

    public static TooltipConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = TooltipConfig.load();
        }
        return INSTANCE;
    }

    public static TooltipConfig load() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String json = Files.readString(CONFIG_PATH);
                return (TooltipConfig)GSON.fromJson(json, TooltipConfig.class);
            }
        }
        catch (IOException e) {
            System.err.println("Failed to load config: " + e.getMessage());
        }
        TooltipConfig config = new TooltipConfig();
        config.save();
        return config;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)this);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save config: " + e.getMessage());
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static enum Position {
        CURSOR_BOTTOM_RIGHT("Cursor - Bottom Right"),
        CURSOR_TOP_RIGHT("Cursor - Top Right"),
        CURSOR_BOTTOM_LEFT("Cursor - Bottom Left"),
        CURSOR_TOP_LEFT("Cursor - Top Left"),
        SCREEN_BOTTOM_RIGHT("Screen - Bottom Right"),
        SCREEN_TOP_RIGHT("Screen - Top Right"),
        SCREEN_BOTTOM_LEFT("Screen - Bottom Left"),
        SCREEN_TOP_LEFT("Screen - Top Left");

        private final String displayName;

        private Position(String displayName) {
            this.displayName = displayName;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

