/*
 * Decompiled with CFR 0.152.
 */
package xyz.lordrektor.itemframetooltip.mixin.client;

import java.util.List;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_3966;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_9779;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.lordrektor.itemframetooltip.config.TooltipConfig;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_329.class})
public class InGameHudMixin {
    @Shadow
    @Final
    private class_310 field_2035;

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void onRender(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        class_1533 itemFrame;
        class_1799 itemStack;
        class_3966 entityHitResult;
        class_1297 class_12972;
        if (this.field_2035 == null || this.field_2035.field_1687 == null || this.field_2035.field_1724 == null || this.field_2035.field_1755 != null || this.field_2035.field_1765 == null) {
            return;
        }
        class_239 hitResult = this.field_2035.field_1765;
        if (hitResult.method_17783() == class_239.class_240.field_1331 && (class_12972 = (entityHitResult = (class_3966)hitResult).method_17782()) instanceof class_1533 && !(itemStack = (itemFrame = (class_1533)class_12972).method_6940()).method_7960()) {
            this.renderCustomItemFrameTooltip(context, itemStack);
        }
    }

    @Unique
    private void renderCustomItemFrameTooltip(class_332 context, class_1799 itemStack) {
        int tooltipX;
        if (this.field_2035 == null || this.field_2035.field_1755 != null) {
            return;
        }
        TooltipConfig config = TooltipConfig.getInstance();
        int screenWidth = this.field_2035.method_22683().method_4486();
        int screenHeight = this.field_2035.method_22683().method_4502();
        class_1836.class_1837 tooltipType = this.field_2035.field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070;
        List tooltipLines = itemStack.method_7950(class_1792.class_9635.field_51353, (class_1657)this.field_2035.field_1724, (class_1836)tooltipType);
        if (tooltipLines.isEmpty()) {
            return;
        }
        int maxWidth = 0;
        for (class_2561 line : tooltipLines) {
            int width = this.field_2035.field_1772.method_27525((class_5348)line);
            if (width <= maxWidth) continue;
            maxWidth = width;
        }
        int iconSize = 16;
        int iconPadding = 2;
        int iconMargin = 2;
        int padding = config.paddingX;
        int paddingY = config.paddingY;
        int borderSize = 1;
        int lineHeight = 10;
        class_2561 itemName = (class_2561)tooltipLines.get(0);
        int itemNameWidth = this.field_2035.field_1772.method_27525((class_5348)itemName);
        int iconBoxWidth = iconMargin + iconSize + iconMargin;
        int firstLineWidth = iconBoxWidth + iconPadding + itemNameWidth;
        int tooltipWidth = Math.max(firstLineWidth, maxWidth) + padding * 2;
        int tooltipHeight = iconSize + iconMargin * 2 + iconPadding + (tooltipLines.size() - 1) * lineHeight + paddingY * 2;
        int tooltipY = switch (config.position) {
            case TooltipConfig.Position.CURSOR_BOTTOM_RIGHT -> {
                tooltipX = screenWidth / 2 + config.offsetX;
                yield screenHeight / 2 + config.offsetY;
            }
            case TooltipConfig.Position.CURSOR_TOP_RIGHT -> {
                tooltipX = screenWidth / 2 + config.offsetX;
                yield screenHeight / 2 - tooltipHeight + config.offsetY;
            }
            case TooltipConfig.Position.CURSOR_BOTTOM_LEFT -> {
                tooltipX = screenWidth / 2 - tooltipWidth + config.offsetX;
                yield screenHeight / 2 + config.offsetY;
            }
            case TooltipConfig.Position.CURSOR_TOP_LEFT -> {
                tooltipX = screenWidth / 2 - tooltipWidth + config.offsetX;
                yield screenHeight / 2 - tooltipHeight + config.offsetY;
            }
            case TooltipConfig.Position.SCREEN_BOTTOM_RIGHT -> {
                tooltipX = screenWidth - tooltipWidth - 10 + config.offsetX;
                yield screenHeight - tooltipHeight - 10 + config.offsetY;
            }
            case TooltipConfig.Position.SCREEN_TOP_RIGHT -> {
                tooltipX = screenWidth - tooltipWidth - 10 + config.offsetX;
                yield 10 + config.offsetY;
            }
            case TooltipConfig.Position.SCREEN_BOTTOM_LEFT -> {
                tooltipX = 10 + config.offsetX;
                yield screenHeight - tooltipHeight - 10 + config.offsetY;
            }
            case TooltipConfig.Position.SCREEN_TOP_LEFT -> {
                tooltipX = 10 + config.offsetX;
                yield 10 + config.offsetY;
            }
            default -> {
                tooltipX = screenWidth / 2 + config.offsetX;
                yield screenHeight / 2 + config.offsetY;
            }
        };
        if (tooltipX + tooltipWidth + borderSize * 2 > screenWidth) {
            tooltipX = screenWidth - tooltipWidth - borderSize * 2;
        }
        if (tooltipX < 0) {
            tooltipX = 0;
        }
        if (tooltipY + tooltipHeight + borderSize * 2 > screenHeight) {
            tooltipY = screenHeight - tooltipHeight - borderSize * 2;
        }
        if (tooltipY < 0) {
            tooltipY = 0;
        }
        context.method_25294(tooltipX - borderSize - 1, tooltipY - borderSize - 1, tooltipX + tooltipWidth + borderSize + 1, tooltipY + tooltipHeight + borderSize + 1, config.tooltipBackgroundColor);
        context.method_49601(tooltipX - 1, tooltipY - 1, tooltipWidth + 2, tooltipHeight + 2, config.tooltipBorderColor);
        int darkerBorder = this.adjustColorBrightness(config.tooltipBorderColor);
        context.method_49601(tooltipX, tooltipY, tooltipWidth, tooltipHeight, darkerBorder);
        context.method_25294(tooltipX, tooltipY, tooltipX + tooltipWidth, tooltipY + tooltipHeight, config.tooltipBackgroundColor);
        int firstRowX = tooltipX + (tooltipWidth - firstLineWidth) / 2;
        int iconX = firstRowX + iconMargin;
        int iconY = tooltipY + paddingY + iconMargin;
        context.method_25294(iconX - 1, iconY - 1, iconX + iconSize + 1, iconY + iconSize + 1, config.tooltipItemBorderColor);
        context.method_25294(iconX, iconY, iconX + iconSize, iconY + iconSize, -16777216);
        context.method_51427(itemStack, iconX, iconY);
        int itemNameX = firstRowX + iconBoxWidth + iconPadding;
        Objects.requireNonNull(this.field_2035.field_1772);
        int itemNameY = iconY + (iconSize - 9) / 2;
        class_5481 itemNameOrdered = itemName.method_30937();
        context.method_51430(this.field_2035.field_1772, itemNameOrdered, itemNameX, itemNameY, -1, true);
        int currentY = tooltipY + paddingY + iconSize + iconMargin * 2 + iconPadding;
        for (int i = 1; i < tooltipLines.size(); ++i) {
            class_2561 line = (class_2561)tooltipLines.get(i);
            class_5481 orderedText = line.method_30937();
            context.method_51430(this.field_2035.field_1772, orderedText, tooltipX + padding, currentY, -1, true);
            currentY += lineHeight;
        }
    }

    @Unique
    private int adjustColorBrightness(int color) {
        float factor = 0.5f;
        int alpha = color >> 24 & 0xFF;
        int red = (int)((float)(color >> 16 & 0xFF) * factor);
        int green = (int)((float)(color >> 8 & 0xFF) * factor);
        int blue = (int)((float)(color & 0xFF) * factor);
        return alpha << 24 | red << 16 | green << 8 | blue;
    }
}

