/*
 * Decompiled with CFR 0.152.
 */
package r0lanoff.tetherVillagers;

import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Villager;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class TetherVillagers
extends JavaPlugin
implements Listener {
    private int maxVillagers;

    public void onEnable() {
        this.saveDefaultConfig();
        this.maxVillagers = this.getConfig().getInt("max-villagers", 5);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public void onDisable() {
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        Player player = event.getPlayer();
        ItemStack itemInHand = player.getInventory().getItemInMainHand();
        if (event.getRightClicked() instanceof Villager && itemInHand.getType() == Material.LEAD) {
            Villager villager = (Villager)event.getRightClicked();
            if (villager.isLeashed()) {
                villager.setLeashHolder(null);
                player.getWorld().playSound(villager.getLocation(), Sound.ITEM_BUNDLE_INSERT, 1.0f, 1.0f);
            } else {
                int leashedCount = 0;
                for (Entity entity : player.getWorld().getEntities()) {
                    Villager v;
                    if (!(entity instanceof Villager) || !(v = (Villager)entity).isLeashed() || v.getLeashHolder() == null || !v.getLeashHolder().equals((Object)player)) continue;
                    ++leashedCount;
                }
                if (leashedCount >= this.maxVillagers) {
                    player.sendMessage("\u00a7c\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u0442\u044c \u0431\u043e\u043b\u044c\u0448\u0435 " + this.maxVillagers + " \u0436\u0438\u0442\u0435\u043b\u0435\u0439!");
                    player.getWorld().playSound(villager.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
                    event.setCancelled(true);
                    return;
                }
                villager.setLeashHolder((Entity)player);
                player.getWorld().playSound(villager.getLocation(), Sound.ITEM_BUNDLE_INSERT, 1.0f, 1.0f);
                if (!player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                    itemInHand.setAmount(itemInHand.getAmount() - 1);
                }
            }
            event.setCancelled(true);
        }
    }
}

