/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.client.gui.hud;

import java.util.Objects;
import me.roundaround.pickupnotifications.config.IconAlignment;
import me.roundaround.pickupnotifications.config.PickupNotificationsConfig;
import me.roundaround.pickupnotifications.roundalib.client.gui.util.GuiUtil;
import me.roundaround.pickupnotifications.roundalib.config.value.GuiAlignment;
import me.roundaround.pickupnotifications.roundalib.config.value.Position;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import net.minecraft.class_9779;
import org.joml.Matrix3x2fStack;

public abstract class PickupNotification<T> {
    public static final int SHOW_DURATION = 120;
    public static final int DURATION_INCREASE_ON_ADD = 60;
    public static final int POP_DURATION = 5;
    public static final int ANIM_DURATION = 6;
    public static final int ANIM_IN_FINISH_TIME = 114;
    public static final int LEFT_PADDING = 1;
    protected final boolean timeless;
    protected final class_310 client;
    protected int originalTimeRemaining;
    protected int timeRemaining;
    protected int popTimeRemaining;
    protected long lastTick;

    protected PickupNotification(boolean bl) {
        this.timeless = bl;
        this.client = class_310.method_1551();
        this.originalTimeRemaining = 120;
        this.timeRemaining = 120;
    }

    protected abstract void renderIcon(class_332 var1, class_9779 var2);

    protected abstract class_2561 getFormattedDisplayString(PickupNotificationsConfig var1);

    protected abstract boolean canAdd(Object var1);

    protected abstract void add(T var1);

    public void render(class_332 class_3322, class_9779 class_97792, int n) {
        PickupNotificationsConfig pickupNotificationsConfig = PickupNotificationsConfig.getInstance();
        GuiAlignment guiAlignment = (GuiAlignment)pickupNotificationsConfig.guiAlignment.getPendingValue();
        Position position = (Position)pickupNotificationsConfig.guiOffset.getPendingValue();
        float f = ((Float)pickupNotificationsConfig.guiScale.getPendingValue()).floatValue();
        float f2 = guiAlignment.getPosX() + position.x() * guiAlignment.getOffsetMultiplierX();
        float f3 = guiAlignment.getPosY() + position.y() * guiAlignment.getOffsetMultiplierY();
        class_2561 class_25612 = this.getFormattedDisplayString(pickupNotificationsConfig);
        class_327 class_3272 = this.client.field_1772;
        Objects.requireNonNull(class_3272);
        int n2 = 9 + 1;
        int n3 = class_3272.method_27525((class_5348)class_25612);
        int n4 = 3 + n3 + n2;
        float f4 = 0.0f;
        float f5 = 0.0f;
        if (guiAlignment.getAlignmentX() == GuiAlignment.AlignmentX.RIGHT) {
            f4 = -n4;
        }
        if (guiAlignment.getAlignmentY() == GuiAlignment.AlignmentY.BOTTOM) {
            Objects.requireNonNull(class_3272);
            f5 = -9 - 2;
        }
        Objects.requireNonNull(class_3272);
        this.renderBackgroundAndText(class_3322, class_97792, n, f2 += (f4 -= (float)n4 * this.getXOffsetPercent() * (float)guiAlignment.getOffsetMultiplierX()) * f, f3 += (f5 += (float)(n * (9 + 2) * guiAlignment.getOffsetMultiplierY())) * f, n4);
    }

    public boolean attemptAdd(Object object) {
        if (this.isExpired()) {
            return false;
        }
        if (this.canAdd(object)) {
            this.add(object);
            return true;
        }
        return false;
    }

    public void extendTime() {
        this.timeRemaining = Math.min(this.timeRemaining + 60, 120);
        this.pop();
    }

    public void pop() {
        this.popTimeRemaining = 5;
    }

    public boolean isExpired() {
        return this.timeRemaining <= 0;
    }

    public void tick() {
        --this.timeRemaining;
        --this.originalTimeRemaining;
        --this.popTimeRemaining;
        this.lastTick = class_156.method_658();
    }

    protected void renderBackgroundAndText(class_332 class_3322, class_9779 class_97792, int n, float f, float f2, int n2) {
        PickupNotificationsConfig pickupNotificationsConfig = PickupNotificationsConfig.getInstance();
        boolean bl = this.isRightAligned();
        float f3 = ((Float)pickupNotificationsConfig.guiScale.getPendingValue()).floatValue();
        class_2561 class_25612 = this.getFormattedDisplayString(pickupNotificationsConfig);
        class_327 class_3272 = this.client.field_1772;
        Objects.requireNonNull(class_3272);
        int n3 = 9 + 1;
        int n4 = bl ? 1 : 2 + n3;
        class_3322.method_71048();
        Matrix3x2fStack matrix3x2fStack = class_3322.method_51448();
        matrix3x2fStack.pushMatrix();
        matrix3x2fStack.translate(f, f2);
        matrix3x2fStack.scale(f3, f3);
        if (((Boolean)pickupNotificationsConfig.renderBackground.getPendingValue()).booleanValue()) {
            class_3322.method_25294(-1, -1, n2, n3, GuiUtil.genColorInt(0.0f, 0.0f, 0.0f, ((Float)pickupNotificationsConfig.backgroundOpacity.getPendingValue()).floatValue()));
        }
        matrix3x2fStack.pushMatrix();
        matrix3x2fStack.translate((float)n4, 0.0f);
        class_3322.method_51439(class_3272, class_25612, 0, 1, GuiUtil.LABEL_COLOR, ((Boolean)pickupNotificationsConfig.renderShadow.getPendingValue()).booleanValue());
        matrix3x2fStack.popMatrix();
        float f4 = (float)this.popTimeRemaining - class_97792.method_60637(false);
        matrix3x2fStack.pushMatrix();
        matrix3x2fStack.translate(bl ? (float)(n2 - 1 - n3) + 0.25f : 0.5f, -0.5f);
        matrix3x2fStack.scale((float)n3 / 16.0f, (float)n3 / 16.0f);
        float f5 = class_3532.method_15363((float)f4, (float)0.0f, (float)5.0f) / 5.0f;
        float f6 = 1.0f + f5;
        matrix3x2fStack.pushMatrix();
        matrix3x2fStack.translate(8.0f, 12.0f);
        matrix3x2fStack.scale(1.0f / f6, (1.0f + f6) / 2.0f);
        matrix3x2fStack.translate(-8.0f, -12.0f);
        this.renderIcon(class_3322, class_97792);
        matrix3x2fStack.popMatrix();
        matrix3x2fStack.popMatrix();
        matrix3x2fStack.popMatrix();
    }

    protected boolean isRightAligned() {
        PickupNotificationsConfig pickupNotificationsConfig = PickupNotificationsConfig.getInstance();
        IconAlignment iconAlignment = (IconAlignment)pickupNotificationsConfig.iconAlignment.getPendingValue();
        if (iconAlignment == IconAlignment.RIGHT) {
            return true;
        }
        return switch (((GuiAlignment)pickupNotificationsConfig.guiAlignment.getPendingValue()).getAlignmentX()) {
            default -> throw new MatchException(null, null);
            case GuiAlignment.AlignmentX.LEFT -> {
                if (iconAlignment == IconAlignment.INSIDE) {
                    yield true;
                }
                yield false;
            }
            case GuiAlignment.AlignmentX.RIGHT -> iconAlignment == IconAlignment.OUTSIDE;
        };
    }

    protected float getXOffsetPercent() {
        if (this.timeless) {
            return 0.0f;
        }
        long l = class_156.method_658();
        float f = class_3532.method_15363((float)((float)(l - this.lastTick) / 50.0f), (float)0.0f, (float)1.0f);
        float f2 = (float)this.timeRemaining - f;
        if (this.originalTimeRemaining > 114) {
            float f3 = Math.max(0.0f, f2) - 114.0f;
            float f4 = class_3532.method_15363((float)(f3 / 6.0f), (float)0.0f, (float)1.0f);
            return f4 * f4;
        }
        if (f2 < 6.0f) {
            float f5 = Math.max(0.0f, f2);
            float f6 = class_3532.method_15363((float)(f5 / 6.0f), (float)0.0f, (float)1.0f);
            return 1.0f - f6 * f6;
        }
        return 0.0f;
    }
}

