/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.client.gui.hud;

import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import me.roundaround.pickupnotifications.client.gui.hud.ExperiencePickupNotification;
import me.roundaround.pickupnotifications.client.gui.hud.ItemPickupNotification;
import me.roundaround.pickupnotifications.client.gui.hud.PickupNotification;
import me.roundaround.pickupnotifications.config.PickupNotificationsConfig;
import me.roundaround.pickupnotifications.event.ExperiencePickup;
import me.roundaround.pickupnotifications.event.ItemPickup;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.hud.HudElementRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_9779;

@Environment(value=EnvType.CLIENT)
public class PickupNotificationsHud {
    private static final PickupNotificationsHud INSTANCE = new PickupNotificationsHud();
    private final CopyOnWriteArrayList<PickupNotification<?>> currentlyShownNotifications = new CopyOnWriteArrayList();
    private final ConcurrentLinkedDeque<PickupNotification<?>> notificationQueue = new ConcurrentLinkedDeque();

    public static void init() {
        ClientTickEvents.END_CLIENT_TICK.register(INSTANCE::tick);
        HudElementRegistry.addLast((class_2960)class_2960.method_60655((String)"pickupnotifications", (String)"pickupnotifications"), INSTANCE::render);
        ExperiencePickup.EVENT.register(INSTANCE::handleExperiencePickedUp);
        ItemPickup.EVENT.register(INSTANCE::handleItemPickedUp);
    }

    private void tick(class_310 class_3102) {
        if (!((Boolean)PickupNotificationsConfig.getInstance().modEnabled.getValue()).booleanValue()) {
            return;
        }
        if (this.currentlyShownNotifications.isEmpty()) {
            return;
        }
        Object object = this.currentlyShownNotifications.iterator();
        while (object.hasNext()) {
            PickupNotification<?> pickupNotification = object.next();
            pickupNotification.tick();
            if (!pickupNotification.isExpired()) continue;
            this.currentlyShownNotifications.remove(pickupNotification);
        }
        while (this.hasRoomForNewNotification() && (object = this.notificationQueue.poll()) != null) {
            ((PickupNotification)object).pop();
            this.currentlyShownNotifications.add((PickupNotification<?>)object);
        }
    }

    private void render(class_332 class_3322, class_9779 class_97792) {
        if (!((Boolean)PickupNotificationsConfig.getInstance().modEnabled.getValue()).booleanValue()) {
            return;
        }
        if (this.currentlyShownNotifications.isEmpty()) {
            return;
        }
        if (!class_310.method_1498()) {
            return;
        }
        int n = 0;
        for (PickupNotification<?> pickupNotification : this.currentlyShownNotifications) {
            pickupNotification.render(class_3322, class_97792, n++);
        }
    }

    private void handleExperiencePickedUp(int n) {
        if (!((Boolean)PickupNotificationsConfig.getInstance().trackExperience.getValue()).booleanValue()) {
            return;
        }
        this.handlePickup(n, ExperiencePickupNotification::new);
    }

    private void handleItemPickedUp(class_1799 class_17992) {
        class_1799 class_17993 = (Boolean)PickupNotificationsConfig.getInstance().showUniqueInfo.getValue() != false ? class_17992.method_7972() : new class_1799((class_1935)class_17992.method_7909(), class_17992.method_7947());
        this.handlePickup(class_17993, ItemPickupNotification::new);
    }

    private <T> void handlePickup(T t, Function<T, PickupNotification<T>> function) {
        boolean bl = false;
        for (PickupNotification<?> pickupNotification : this.currentlyShownNotifications) {
            if (!pickupNotification.attemptAdd(t)) continue;
            bl = true;
            pickupNotification.extendTime();
            break;
        }
        if (!bl) {
            for (PickupNotification pickupNotification : this.notificationQueue) {
                if (!pickupNotification.attemptAdd(t)) continue;
                bl = true;
                break;
            }
        }
        if (!bl) {
            PickupNotification<T> pickupNotification = function.apply(t);
            if (this.notificationQueue.isEmpty() && this.hasRoomForNewNotification()) {
                pickupNotification.pop();
                this.currentlyShownNotifications.add(pickupNotification);
            } else {
                this.notificationQueue.add(pickupNotification);
            }
        }
    }

    private boolean hasRoomForNewNotification() {
        return this.currentlyShownNotifications.size() < (Integer)PickupNotificationsConfig.getInstance().maxNotifications.getValue();
    }
}

