/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.client.gui.util;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import me.roundaround.pickupnotifications.roundalib.client.gui.util.FourSided;

public final class Spacing
extends Record
implements FourSided<Integer> {
    private final Integer top;
    private final Integer right;
    private final Integer bottom;
    private final Integer left;

    public Spacing(Integer n, Integer n2, Integer n3, Integer n4) {
        this.top = n;
        this.right = n2;
        this.bottom = n3;
        this.left = n4;
    }

    public static Spacing zero() {
        return Spacing.of(0);
    }

    public static Spacing of(int n) {
        return new Spacing(n, n, n, n);
    }

    public static Spacing of(int n, int n2) {
        return new Spacing(n, n2, n, n2);
    }

    public static Spacing of(int n, int n2, int n3) {
        return new Spacing(n, n2, n3, n2);
    }

    public static Spacing of(int n, int n2, int n3, int n4) {
        return new Spacing(n, n2, n3, n4);
    }

    public int getVertical() {
        return this.top() + this.bottom();
    }

    public int getHorizontal() {
        return this.left() + this.right();
    }

    public Spacing setVertical(int n) {
        return Spacing.of(n, this.right, n, this.left);
    }

    public Spacing setHorizontal(int n) {
        return Spacing.of(this.top, n, this.bottom, n);
    }

    public Spacing expand(int n) {
        return this.expand(Spacing.of(n));
    }

    public Spacing expand(FourSided<Integer> fourSided) {
        return Spacing.of(this.top + fourSided.top(), this.right + fourSided.right(), this.bottom + fourSided.bottom(), this.left + fourSided.left());
    }

    public Spacing reduce(int n) {
        return this.reduce(Spacing.of(n));
    }

    public Spacing reduce(FourSided<Integer> fourSided) {
        return Spacing.of(this.top - fourSided.top(), this.right - fourSided.right(), this.bottom - fourSided.bottom(), this.left - fourSided.left());
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{Spacing.class, "top;right;bottom;left", "top", "right", "bottom", "left"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Spacing.class, "top;right;bottom;left", "top", "right", "bottom", "left"}, this);
    }

    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Spacing.class, "top;right;bottom;left", "top", "right", "bottom", "left"}, this, object);
    }

    @Override
    public Integer top() {
        return this.top;
    }

    @Override
    public Integer right() {
        return this.right;
    }

    @Override
    public Integer bottom() {
        return this.bottom;
    }

    @Override
    public Integer left() {
        return this.left;
    }
}

