/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.client.gui.widget.drawable;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import me.roundaround.pickupnotifications.roundalib.client.gui.util.Alignment;
import me.roundaround.pickupnotifications.roundalib.client.gui.util.Dimensions;
import me.roundaround.pickupnotifications.roundalib.client.gui.util.GuiUtil;
import me.roundaround.pickupnotifications.roundalib.client.gui.util.IntRect;
import me.roundaround.pickupnotifications.roundalib.client.gui.util.Spacing;
import me.roundaround.pickupnotifications.roundalib.client.gui.widget.drawable.DrawableWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_8030;

@Environment(value=EnvType.CLIENT)
public class LabelWidget
extends DrawableWidget {
    public static final Spacing PADDING = Spacing.of(2, 2, 1, 3);
    private final class_327 textRenderer;
    private List<class_2561> lines;
    private int color;
    private Alignment alignSelfX;
    private Alignment alignSelfY;
    private Alignment alignTextX;
    private Alignment alignTextY;
    private OverflowBehavior overflowBehavior;
    private int maxLines;
    private int lineSpacing;
    private boolean showBackground;
    private int bgColor;
    private boolean shadow;
    private IntRect textBounds = IntRect.zero();
    private IntRect bgBounds = IntRect.zero();
    private boolean inBatchUpdate = false;

    private LabelWidget(class_327 class_3272, List<class_2561> list, int n, int n2, int n3, int n4, int n5, Alignment alignment, Alignment alignment2, Alignment alignment3, Alignment alignment4, OverflowBehavior overflowBehavior, int n6, int n7, boolean bl, int n8, boolean bl2, class_7919 class_79192, Duration duration) {
        super(n2, n3, n4, n5, class_5244.field_39003);
        this.textRenderer = class_3272;
        this.lines = new ArrayList<class_2561>(list);
        this.color = n;
        this.alignSelfX = alignment;
        this.alignSelfY = alignment2;
        this.alignTextX = alignment3;
        this.alignTextY = alignment4;
        this.overflowBehavior = overflowBehavior;
        this.maxLines = n6;
        this.lineSpacing = n7;
        this.showBackground = bl;
        this.bgColor = n8;
        this.shadow = bl2;
        this.method_47400(class_79192);
        if (duration != null) {
            this.method_47402(duration);
        }
        this.calculateBounds();
    }

    public void calculateBounds() {
        int n;
        if (this.inBatchUpdate) {
            return;
        }
        int n2 = this.showBackground ? PADDING.left() : 0;
        int n3 = this.showBackground ? PADDING.top() : 0;
        int n4 = this.method_46426() + n2;
        int n5 = this.method_46427() + n3;
        if (this.lines.isEmpty()) {
            this.textBounds = IntRect.byDimensions(n4, n5, 0, 0);
            this.bgBounds = this.textBounds.expand(PADDING);
            return;
        }
        Dimensions dimensions = this.lines.size() == 1 && this.overflowBehavior == OverflowBehavior.WRAP ? this.getWrappedTextDimensions() : this.getFullTextDimensions();
        int n6 = Math.min(dimensions.width(), this.getAvailableWidth());
        int n7 = Math.min(dimensions.height(), this.getAvailableHeight());
        if (this.field_22758 != 0) {
            n = this.showBackground ? PADDING.getHorizontal() : 0;
            n4 = this.alignTextX.getPosInContainer(n4, this.field_22758 - n, n6);
        }
        if (this.field_22759 != 0) {
            n = this.showBackground ? PADDING.getVertical() : 0;
            n5 = this.alignTextY.getPosInContainer(n5, this.field_22759 - n, n7);
        }
        this.textBounds = IntRect.byDimensions(n4, n5, n6, n7);
        this.bgBounds = this.textBounds.expand(PADDING);
    }

    private Dimensions getFullTextDimensions() {
        int n = this.lines.stream().mapToInt(arg_0 -> ((class_327)this.textRenderer).method_27525(arg_0)).max().orElse(0);
        int n2 = this.lines.size();
        Objects.requireNonNull(this.textRenderer);
        return Dimensions.of(n, n2 * 9 + (this.lines.size() - 1) * this.lineSpacing);
    }

    private Dimensions getWrappedTextDimensions() {
        return GuiUtil.measureWrappedText(this.textRenderer, this.lines.getFirst(), this.getAvailableWidth(), this.maxLines, this.lineSpacing);
    }

    public void method_48579(class_332 class_3322, int n, int n2, float f) {
        if (this.lines.isEmpty()) {
            return;
        }
        boolean bl = this.field_22762 = class_3322.method_58135(n, n2) && this.getBounds().contains(n, n2);
        if (this.showBackground) {
            GuiUtil.fill(class_3322, this.bgBounds, this.bgColor);
        }
        OverflowBehavior overflowBehavior = this.overflowBehavior;
        if (this.lines.size() > 1 && !overflowBehavior.supportsMultiline()) {
            overflowBehavior = OverflowBehavior.CLIP;
        }
        if (overflowBehavior == OverflowBehavior.CLIP) {
            GuiUtil.enableScissor(class_3322, this.textBounds);
        }
        for (int i = 0; i < this.lines.size(); ++i) {
            this.renderLine(i, overflowBehavior, class_3322, n, n2, f);
        }
        if (overflowBehavior == OverflowBehavior.CLIP) {
            GuiUtil.disableScissor(class_3322);
        }
    }

    protected void renderLine(int n, OverflowBehavior overflowBehavior, class_332 class_3322, int n2, int n3, float f) {
        class_2561 class_25612 = this.lines.get(n);
        int n4 = this.textBounds.left();
        int n5 = this.textBounds.top() + GuiUtil.getLineYOffset(this.textRenderer, n, this.lineSpacing);
        int n6 = this.textBounds.getWidth();
        switch (overflowBehavior.ordinal()) {
            case 0: 
            case 3: {
                GuiUtil.drawText(class_3322, this.textRenderer, class_25612, n4, n5, this.color, this.shadow, n6, this.alignTextX);
                break;
            }
            case 1: {
                GuiUtil.drawTruncatedText(class_3322, this.textRenderer, class_25612, n4, n5, this.color, this.shadow, n6, this.alignTextX);
                break;
            }
            case 2: {
                GuiUtil.drawWrappedText(class_3322, this.textRenderer, class_25612, n4, n5, this.color, this.shadow, n6, this.maxLines, this.lineSpacing, this.alignTextX);
                break;
            }
            case 4: {
                GuiUtil.drawScrollingText(class_3322, this.textRenderer, class_25612, n4, n5, this.color, this.shadow, n6, this.alignTextX);
            }
        }
    }

    public class_2561 getText() {
        if (this.lines.isEmpty()) {
            return class_2561.method_43473();
        }
        Iterator<class_2561> iterator = this.lines.iterator();
        class_5250 class_52502 = iterator.next().method_27661();
        while (iterator.hasNext()) {
            class_52502.method_10852(class_5244.field_33849);
            class_52502.method_10852(iterator.next());
        }
        return class_52502;
    }

    public List<class_2561> getLines() {
        return this.lines;
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public int getDefaultHeight() {
        int n = Math.max(1, this.getLineCount());
        Objects.requireNonNull(this.textRenderer);
        return n * 9 + (n - 1) * this.lineSpacing + PADDING.getVertical();
    }

    public void batchUpdates(Runnable runnable) {
        if (this.inBatchUpdate) {
            runnable.run();
            return;
        }
        this.inBatchUpdate = true;
        try {
            runnable.run();
        }
        finally {
            this.inBatchUpdate = false;
            this.calculateBounds();
        }
    }

    public void setText(class_2561 class_25612) {
        this.lines = List.of(class_25612);
        this.calculateBounds();
    }

    public void setText(List<class_2561> list) {
        this.lines = new ArrayList<class_2561>(list);
        this.calculateBounds();
    }

    public void appendLine(class_2561 class_25612) {
        this.lines.add(class_25612);
        this.calculateBounds();
    }

    public void setColor(int n) {
        this.color = n;
    }

    public void setAlignSelfX(Alignment alignment) {
        this.alignSelfX = alignment;
        this.calculateBounds();
    }

    public void setAlignSelfY(Alignment alignment) {
        this.alignSelfY = alignment;
        this.calculateBounds();
    }

    public void setAlignTextX(Alignment alignment) {
        this.alignTextX = alignment;
        this.calculateBounds();
    }

    public void setAlignTextY(Alignment alignment) {
        this.alignTextY = alignment;
        this.calculateBounds();
    }

    public void setOverflowBehavior(OverflowBehavior overflowBehavior) {
        this.overflowBehavior = overflowBehavior;
        this.calculateBounds();
    }

    public void setMaxLines(int n) {
        this.maxLines = n;
        this.calculateBounds();
    }

    public void setLineSpacing(int n) {
        this.lineSpacing = n;
        this.calculateBounds();
    }

    public void setShowBackground(boolean bl) {
        this.showBackground = bl;
        this.calculateBounds();
    }

    public void setBgColor(int n) {
        this.bgColor = n;
    }

    public void setShadow(boolean bl) {
        this.shadow = bl;
    }

    public void method_46421(int n) {
        super.method_46421(n);
        this.calculateBounds();
    }

    public void method_46419(int n) {
        super.method_46419(n);
        this.calculateBounds();
    }

    public void method_48229(int n, int n2) {
        this.batchUpdates(() -> super.method_48229(n, n2));
    }

    public void method_25358(int n) {
        super.method_25358(n);
        this.calculateBounds();
    }

    public void method_53533(int n) {
        super.method_53533(n);
        this.calculateBounds();
    }

    public void method_55445(int n, int n2) {
        this.batchUpdates(() -> super.method_55445(n, n2));
    }

    public void method_55444(int n, int n2, int n3, int n4) {
        this.batchUpdates(() -> super.method_55444(n, n2, n3, n4));
    }

    public int method_46426() {
        return this.alignSelfX.getPos(super.method_46426(), this.method_25368());
    }

    public int method_46427() {
        return this.alignSelfY.getPos(super.method_46427(), this.method_25364());
    }

    public int method_25368() {
        return this.field_22758 != 0 ? this.field_22758 : this.getBounds().getWidth();
    }

    public int method_25364() {
        return this.field_22759 != 0 ? this.field_22759 : this.getBounds().getHeight();
    }

    public class_8030 method_48202() {
        return this.getBounds().toScreenRect();
    }

    public IntRect getBounds() {
        return this.showBackground ? this.bgBounds : this.textBounds;
    }

    public IntRect getWidgetBounds() {
        return IntRect.byDimensions(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
    }

    public int getTextWidth() {
        return this.getBounds().getWidth();
    }

    public int getTextHeight() {
        return this.getBounds().getHeight();
    }

    protected int getAvailableWidth() {
        if (this.field_22758 == 0 || this.overflowBehavior == OverflowBehavior.SHOW) {
            return Integer.MAX_VALUE;
        }
        return Math.max(0, this.showBackground ? this.field_22758 - PADDING.getHorizontal() : this.field_22758);
    }

    protected int getAvailableHeight() {
        if (this.field_22759 == 0 || this.overflowBehavior == OverflowBehavior.SHOW) {
            return Integer.MAX_VALUE;
        }
        return Math.max(0, this.showBackground ? this.field_22759 - PADDING.getVertical() : this.field_22759);
    }

    public static Builder builder(class_327 class_3272, class_2561 class_25612) {
        return new Builder(class_3272, class_25612);
    }

    public static Builder builder(class_327 class_3272, List<class_2561> list) {
        return new Builder(class_3272, list);
    }

    public static int getDefaultHeight(class_327 class_3272) {
        return LabelWidget.getDefaultHeight(class_3272, 1);
    }

    public static int getDefaultHeight(class_327 class_3272, int n) {
        return LabelWidget.getDefaultHeight(class_3272, n, 0);
    }

    public static int getDefaultHeight(class_327 class_3272, int n, int n2) {
        Objects.requireNonNull(class_3272);
        return n * 9 + (n - 1) * n2 + PADDING.getVertical();
    }

    @Environment(value=EnvType.CLIENT)
    public static enum OverflowBehavior {
        SHOW("show", true),
        TRUNCATE("truncate", true),
        WRAP("wrap", false),
        CLIP("clip", true),
        SCROLL("scroll", true);

        private final String id;
        private final boolean supportsMultiline;

        private OverflowBehavior(String string2, boolean bl) {
            this.id = string2;
            this.supportsMultiline = bl;
        }

        public String getI18nKey(String string) {
            return String.format("%s.roundalib.overflow_behavior.%s", string, this.id);
        }

        public class_2561 getDisplayText(String string) {
            return class_2561.method_43471((String)this.getI18nKey(string));
        }

        public String getDisplayString(String string) {
            return class_1074.method_4662((String)this.getI18nKey(string), (Object[])new Object[0]);
        }

        public boolean supportsMultiline() {
            return this.supportsMultiline;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Builder {
        private final class_327 textRenderer;
        private final List<class_2561> lines;
        private int x;
        private int y;
        private int width;
        private int height;
        private int color = GuiUtil.LABEL_COLOR;
        private Alignment alignSelfX = Alignment.START;
        private Alignment alignSelfY = Alignment.START;
        private Alignment alignTextX = Alignment.START;
        private Alignment alignTextY = Alignment.CENTER;
        private OverflowBehavior overflowBehavior = OverflowBehavior.SHOW;
        private int maxLines = 0;
        private int lineSpacing = 0;
        private boolean background = true;
        private int bgColor = GuiUtil.BACKGROUND_COLOR;
        private boolean shadow = false;
        private class_7919 tooltip = null;
        private Duration tooltipDelay = null;

        public Builder(class_327 class_3272) {
            this(class_3272, List.of());
        }

        public Builder(class_327 class_3272, class_2561 class_25612) {
            this(class_3272, List.of(class_25612));
        }

        public Builder(class_327 class_3272, List<class_2561> list) {
            this.textRenderer = class_3272;
            this.lines = new ArrayList<class_2561>(list);
        }

        public Builder configure(Consumer<Builder> consumer) {
            consumer.accept(this);
            return this;
        }

        public Builder position(int n, int n2) {
            this.x = n;
            this.y = n2;
            return this;
        }

        public Builder width(int n) {
            this.width = n;
            return this;
        }

        public Builder height(int n) {
            this.height = n;
            return this;
        }

        public Builder dimensions(int n, int n2) {
            this.width = n;
            this.height = n2;
            return this;
        }

        public Builder color(int n) {
            this.color = n;
            return this;
        }

        public Builder color(int n, int n2, int n3) {
            return this.color(GuiUtil.genColorInt(n, n2, n3));
        }

        public Builder color(float f, float f2, float f3) {
            return this.color(GuiUtil.genColorInt(f, f2, f3));
        }

        public Builder color(int n, int n2, int n3, int n4) {
            return this.color(GuiUtil.genColorInt(n, n2, n3, n4));
        }

        public Builder color(float f, float f2, float f3, float f4) {
            return this.color(GuiUtil.genColorInt(f, f2, f3, f4));
        }

        public Builder overflowBehavior(OverflowBehavior overflowBehavior) {
            this.overflowBehavior = overflowBehavior;
            return this;
        }

        public Builder maxLines(int n) {
            this.maxLines = n;
            return this;
        }

        public Builder lineSpacing(int n) {
            this.lineSpacing = n;
            return this;
        }

        public Builder alignSelfX(Alignment alignment) {
            this.alignSelfX = alignment;
            return this;
        }

        public Builder alignSelfLeft() {
            return this.alignSelfX(Alignment.START);
        }

        public Builder alignSelfCenterX() {
            return this.alignSelfX(Alignment.CENTER);
        }

        public Builder alignSelfRight() {
            return this.alignSelfX(Alignment.END);
        }

        public Builder alignSelfY(Alignment alignment) {
            this.alignSelfY = alignment;
            return this;
        }

        public Builder alignSelfTop() {
            return this.alignSelfY(Alignment.START);
        }

        public Builder alignSelfCenterY() {
            return this.alignSelfY(Alignment.CENTER);
        }

        public Builder alignSelfBottom() {
            return this.alignSelfY(Alignment.END);
        }

        public Builder alignTextX(Alignment alignment) {
            this.alignTextX = alignment;
            return this;
        }

        public Builder alignTextLeft() {
            return this.alignTextX(Alignment.START);
        }

        public Builder alignTextCenterX() {
            return this.alignTextX(Alignment.CENTER);
        }

        public Builder alignTextRight() {
            return this.alignTextX(Alignment.END);
        }

        public Builder alignTextY(Alignment alignment) {
            this.alignTextY = alignment;
            return this;
        }

        public Builder alignTextTop() {
            return this.alignTextY(Alignment.START);
        }

        public Builder alignTextCenterY() {
            return this.alignTextY(Alignment.CENTER);
        }

        public Builder alignTextBottom() {
            return this.alignTextY(Alignment.END);
        }

        public Builder hideBackground() {
            return this.background(false);
        }

        public Builder background(boolean bl) {
            this.background = bl;
            return this;
        }

        public Builder bgColor(int n) {
            this.bgColor = n;
            return this;
        }

        public Builder bgColor(int n, int n2, int n3) {
            return this.bgColor(GuiUtil.genColorInt(n, n2, n3));
        }

        public Builder bgColor(int n, int n2, int n3, int n4) {
            return this.bgColor(GuiUtil.genColorInt(n, n2, n3, n4));
        }

        public Builder showShadow() {
            return this.shadow(true);
        }

        public Builder shadow(boolean bl) {
            this.shadow = bl;
            return this;
        }

        public Builder tooltip(class_2561 class_25612) {
            return this.tooltip(class_7919.method_47407((class_2561)class_25612));
        }

        public Builder tooltip(class_7919 class_79192) {
            this.tooltip = class_79192;
            return this;
        }

        public Builder tooltipDelay(Duration duration) {
            this.tooltipDelay = duration;
            return this;
        }

        public LabelWidget build() {
            return new LabelWidget(this.textRenderer, this.lines, this.color, this.x, this.y, this.width, this.height, this.alignSelfX, this.alignSelfY, this.alignTextX, this.alignTextY, this.overflowBehavior, this.maxLines, this.lineSpacing, this.background, this.bgColor, this.shadow, this.tooltip, this.tooltipDelay);
        }
    }
}

