/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.config.value;

import java.util.Arrays;
import me.roundaround.pickupnotifications.roundalib.config.value.EnumValue;
import net.minecraft.class_310;

public enum GuiAlignmentWithCenter implements EnumValue<GuiAlignmentWithCenter>
{
    TOP_LEFT(AlignmentY.TOP, AlignmentX.LEFT),
    TOP_CENTER(AlignmentY.TOP, AlignmentX.CENTER),
    TOP_RIGHT(AlignmentY.TOP, AlignmentX.RIGHT),
    MIDDLE_LEFT(AlignmentY.MIDDLE, AlignmentX.LEFT),
    MIDDLE_CENTER(AlignmentY.MIDDLE, AlignmentX.CENTER),
    MIDDLE_RIGHT(AlignmentY.MIDDLE, AlignmentX.RIGHT),
    BOTTOM_LEFT(AlignmentY.BOTTOM, AlignmentX.LEFT),
    BOTTOM_CENTER(AlignmentY.BOTTOM, AlignmentX.CENTER),
    BOTTOM_RIGHT(AlignmentY.BOTTOM, AlignmentX.RIGHT);

    private final AlignmentX alignmentX;
    private final AlignmentY alignmentY;
    private final String id;

    private GuiAlignmentWithCenter(AlignmentY alignmentY, AlignmentX alignmentX) {
        this.alignmentX = alignmentX;
        this.alignmentY = alignmentY;
        this.id = String.valueOf((Object)alignmentY) + "_" + String.valueOf((Object)alignmentX);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getI18nKey(String string) {
        return string + ".roundalib.gui_alignment." + this.id;
    }

    @Override
    public GuiAlignmentWithCenter getFromId(String string) {
        return GuiAlignmentWithCenter.fromId(string);
    }

    @Override
    public GuiAlignmentWithCenter getNext() {
        return GuiAlignmentWithCenter.values()[this.ordinal() + 1 % GuiAlignmentWithCenter.values().length];
    }

    @Override
    public GuiAlignmentWithCenter getPrev() {
        return GuiAlignmentWithCenter.values()[this.ordinal() + GuiAlignmentWithCenter.values().length - 1 % GuiAlignmentWithCenter.values().length];
    }

    public AlignmentX getAlignmentX() {
        return this.alignmentX;
    }

    public AlignmentY getAlignmentY() {
        return this.alignmentY;
    }

    public int getPosX() {
        return GuiAlignmentWithCenter.getPosX(this);
    }

    public int getPosY() {
        return GuiAlignmentWithCenter.getPosY(this);
    }

    public int getOffsetMultiplierX() {
        return GuiAlignmentWithCenter.getOffsetMultiplierX(this);
    }

    public int getOffsetMultiplierY() {
        return GuiAlignmentWithCenter.getOffsetMultiplierY(this);
    }

    public static GuiAlignmentWithCenter getDefault() {
        return TOP_LEFT;
    }

    public static GuiAlignmentWithCenter fromId(String string) {
        return Arrays.stream(GuiAlignmentWithCenter.values()).filter(guiAlignmentWithCenter -> guiAlignmentWithCenter.id.equals(string)).findFirst().orElse(GuiAlignmentWithCenter.getDefault());
    }

    public static int getPosX(GuiAlignmentWithCenter guiAlignmentWithCenter) {
        return guiAlignmentWithCenter.alignmentX.getPos();
    }

    public static int getPosY(GuiAlignmentWithCenter guiAlignmentWithCenter) {
        return guiAlignmentWithCenter.alignmentY.getPos();
    }

    public static int getOffsetMultiplierX(GuiAlignmentWithCenter guiAlignmentWithCenter) {
        return guiAlignmentWithCenter.alignmentX.getOffsetMultiplier();
    }

    public static int getOffsetMultiplierY(GuiAlignmentWithCenter guiAlignmentWithCenter) {
        return guiAlignmentWithCenter.alignmentY.getOffsetMultiplier();
    }

    private static int getScaledWindowWidth() {
        return class_310.method_1551().method_22683().method_4486();
    }

    private static int getScaledWindowHeight() {
        return class_310.method_1551().method_22683().method_4502();
    }

    public static enum AlignmentX {
        LEFT("left"),
        CENTER("center"),
        RIGHT("right");

        private final String value;

        private AlignmentX(String string2) {
            this.value = string2;
        }

        public String toString() {
            return this.value;
        }

        public int getPos() {
            return switch (this.value) {
                case "center" -> GuiAlignmentWithCenter.getScaledWindowWidth() / 2;
                case "right" -> GuiAlignmentWithCenter.getScaledWindowWidth();
                default -> 0;
            };
        }

        public int getOffsetMultiplier() {
            return switch (this.value) {
                case "center" -> 0;
                case "right" -> -1;
                default -> 1;
            };
        }
    }

    public static enum AlignmentY {
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String value;

        private AlignmentY(String string2) {
            this.value = string2;
        }

        public String toString() {
            return this.value;
        }

        public int getPos() {
            return switch (this.value) {
                case "middle" -> GuiAlignmentWithCenter.getScaledWindowHeight() / 2;
                case "bottom" -> GuiAlignmentWithCenter.getScaledWindowHeight();
                default -> 0;
            };
        }

        public int getOffsetMultiplier() {
            return switch (this.value) {
                case "middle" -> 0;
                case "bottom" -> -1;
                default -> 1;
            };
        }
    }
}

