/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.Config;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.EnumGetMethod;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.utils.StringUtils;

public class ConfigSpec {
    protected final Config storage;

    public ConfigSpec() {
        this(Config.inMemoryUniversal());
    }

    public ConfigSpec(Config config) {
        this.storage = config;
    }

    public void define(String string, Object object) {
        this.define(StringUtils.split(string, '.'), object);
    }

    public void define(List<String> list, Object object) {
        this.define(list, object, (Object object2) -> object2 != null && object.getClass().isAssignableFrom(object2.getClass()));
    }

    public void define(String string, Object object, Predicate<Object> predicate) {
        this.define(StringUtils.split(string, '.'), object, predicate);
    }

    public void define(String string, Supplier<?> supplier, Predicate<Object> predicate) {
        this.define(StringUtils.split(string, '.'), supplier, predicate);
    }

    public void define(List<String> list, Object object, Predicate<Object> predicate) {
        this.storage.set(list, (Object)new ValueSpec(object, predicate));
    }

    public void define(List<String> list, Supplier<?> supplier, Predicate<Object> predicate) {
        this.storage.set(list, (Object)new ValueSpec(supplier, predicate));
    }

    public <V> void defineOfClass(String string, V v, Class<? super V> clazz) {
        this.defineOfClass(StringUtils.split(string, '.'), (Supplier<V>)new DumbSupplier<V>(v), clazz);
    }

    public <V> void defineOfClass(String string, Supplier<V> supplier, Class<? super V> clazz) {
        this.defineOfClass(StringUtils.split(string, '.'), supplier, clazz);
    }

    public <V> void defineOfClass(List<String> list, V v, Class<? super V> clazz) {
        this.defineOfClass(list, (Supplier<V>)new DumbSupplier<V>(v), clazz);
    }

    public <V> void defineOfClass(List<String> list, Supplier<V> supplier, Class<? super V> clazz) {
        this.define(list, supplier, (Object object) -> object != null && clazz.isAssignableFrom(object.getClass()));
    }

    public void defineInList(String string, Object object, Collection<?> collection) {
        this.defineInList(StringUtils.split(string, '.'), object, collection);
    }

    public void defineInList(String string, Supplier<?> supplier, Collection<?> collection) {
        this.defineInList(StringUtils.split(string, '.'), supplier, collection);
    }

    public void defineInList(List<String> list, Object object, Collection<?> collection) {
        this.defineInList(list, new DumbSupplier<Object>(object), collection);
    }

    public void defineInList(List<String> list, Supplier<?> supplier, Collection<?> collection) {
        this.define(list, supplier, collection::contains);
    }

    public <V extends Comparable<? super V>> void defineInRange(String string, V v, V v2, V v3) {
        this.defineInRange(StringUtils.split(string, '.'), v, v2, v3);
    }

    public <V extends Comparable<? super V>> void defineInRange(String string, Supplier<V> supplier, V v, V v2) {
        this.defineInRange(StringUtils.split(string, '.'), supplier, v, v2);
    }

    public <V extends Comparable<? super V>> void defineInRange(List<String> list, V v, V v2, V v3) {
        this.defineInRange(list, new DumbSupplier<V>(v), v2, v3);
    }

    public <V extends Comparable<? super V>> void defineInRange(List<String> list, Supplier<V> supplier, V v, V v2) {
        if (v.compareTo(v2) > 0) {
            throw new IllegalArgumentException("The minimum must be less than the maximum.");
        }
        this.define(list, supplier, (Object object) -> {
            if (!(object instanceof Comparable)) {
                return false;
            }
            Comparable comparable3 = (Comparable)object;
            try {
                return comparable3.compareTo(v) >= 0 && comparable3.compareTo(v2) <= 0;
            }
            catch (ClassCastException classCastException) {
                if (comparable3 instanceof Number && v instanceof Number) {
                    Class<?> clazz = comparable3.getClass();
                    Class<?> clazz2 = v.getClass();
                    if (clazz == Long.class || clazz == Integer.class) {
                        if (clazz2 == Integer.class || clazz2 == Short.class || clazz2 == Character.class) {
                            long l = ((Number)((Object)comparable3)).longValue();
                            return l >= ((Number)((Object)v)).longValue() && l <= ((Number)((Object)v2)).longValue();
                        }
                        if (clazz2 == Float.class || clazz2 == Double.class) {
                            double d = ((Number)((Object)comparable3)).doubleValue();
                            return d >= ((Number)((Object)v)).doubleValue() && d <= ((Number)((Object)v2)).doubleValue();
                        }
                    }
                    if (clazz == Double.class || clazz == Float.class) {
                        double d = ((Number)((Object)comparable3)).doubleValue();
                        return d >= ((Number)((Object)v)).doubleValue() && d <= ((Number)((Object)v2)).doubleValue();
                    }
                }
                return false;
            }
        });
    }

    public void defineList(String string, List<?> list, Predicate<Object> predicate) {
        this.defineList(StringUtils.split(string, '.'), list, predicate);
    }

    public void defineList(String string, Supplier<List<?>> supplier, Predicate<Object> predicate) {
        this.defineList(StringUtils.split(string, '.'), supplier, predicate);
    }

    public void defineList(List<String> list, List<?> list2, Predicate<Object> predicate) {
        this.defineList(list, new DumbSupplier(list2), predicate);
    }

    public void defineList(List<String> list, Supplier<List<?>> supplier, Predicate<Object> predicate) {
        this.define(list, supplier, (Object object) -> {
            if (!(object instanceof List)) {
                return false;
            }
            List list = (List)object;
            for (Object e : list) {
                if (predicate.test(e)) continue;
                return false;
            }
            return true;
        });
    }

    public <T extends Enum<T>> void defineEnum(String string, T t, EnumGetMethod enumGetMethod) {
        this.defineEnum(StringUtils.split(string, '.'), t, enumGetMethod);
    }

    public <T extends Enum<T>> void defineEnum(List<String> list, T t, EnumGetMethod enumGetMethod) {
        this.defineEnum(list, t.getDeclaringClass(), enumGetMethod, new DumbSupplier<T>(t));
    }

    public <T extends Enum<T>> void defineEnum(String string, Class<T> clazz, EnumGetMethod enumGetMethod, Supplier<T> supplier) {
        this.defineEnum(StringUtils.split(string, '.'), clazz, enumGetMethod, supplier);
    }

    public <T extends Enum<T>> void defineEnum(List<String> list, Class<T> clazz, EnumGetMethod enumGetMethod, Supplier<T> supplier) {
        this.define(list, supplier, (Object object) -> enumGetMethod.validate(object, clazz));
    }

    public <T extends Enum<T>> void defineRestrictedEnum(String string, T t, Collection<T> collection, EnumGetMethod enumGetMethod) {
        this.defineRestrictedEnum(StringUtils.split(string, '.'), t, collection, enumGetMethod);
    }

    public <T extends Enum<T>> void defineRestrictedEnum(List<String> list, T t, Collection<T> collection, EnumGetMethod enumGetMethod) {
        this.defineRestrictedEnum(list, t.getDeclaringClass(), collection, enumGetMethod, new DumbSupplier<T>(t));
    }

    public <T extends Enum<T>> void defineRestrictedEnum(String string, Class<T> clazz, Collection<T> collection, EnumGetMethod enumGetMethod, Supplier<T> supplier) {
        this.defineRestrictedEnum(StringUtils.split(string, '.'), clazz, collection, enumGetMethod, supplier);
    }

    public <T extends Enum<T>> void defineRestrictedEnum(List<String> list, Class<T> clazz, Collection<T> collection, EnumGetMethod enumGetMethod, Supplier<T> supplier) {
        this.define(list, supplier, (Object object) -> enumGetMethod.validate(object, clazz) && collection.contains(enumGetMethod.get(object, clazz)));
    }

    public void undefine(String string) {
        this.undefine(StringUtils.split(string, '.'));
    }

    public void undefine(List<String> list) {
        this.storage.remove(list);
    }

    public boolean isDefined(String string) {
        return this.isDefined(StringUtils.split(string, '.'));
    }

    public boolean isDefined(List<String> list) {
        return this.storage.contains(list);
    }

    public boolean isCorrect(String string, Object object) {
        return this.isCorrect(StringUtils.split(string, '.'), object);
    }

    public boolean isCorrect(List<String> list, Object object) {
        ValueSpec valueSpec = (ValueSpec)this.storage.getRaw(list);
        return valueSpec.validator.test(object);
    }

    public boolean isCorrect(Config config) {
        return this.isCorrect(config.valueMap(), this.storage.valueMap());
    }

    private boolean isCorrect(Map<String, Object> map, Map<String, Object> map2) {
        Object object;
        String string;
        for (Map.Entry<String, Object> entry : map2.entrySet()) {
            string = entry.getKey();
            object = entry.getValue();
            Object object2 = map.get(string);
            if (object2 == null) {
                return false;
            }
            if (object instanceof Config) {
                if (!(object2 instanceof Config)) {
                    return false;
                }
                if (this.isCorrect(((Config)object2).valueMap(), ((Config)object).valueMap())) continue;
                return false;
            }
            ValueSpec valueSpec = (ValueSpec)object;
            if (valueSpec.validator.test(object2)) continue;
            return false;
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            string = entry.getKey();
            object = map2.get(string);
            if (object != null) continue;
            return false;
        }
        return true;
    }

    public Object correct(String string, Object object) {
        return this.correct(StringUtils.split(string, '.'), object);
    }

    public Object correct(List<String> list, Object object) {
        ValueSpec valueSpec = (ValueSpec)this.storage.getRaw(list);
        return valueSpec.validator.test(object) ? object : valueSpec.defaultValueSupplier.get();
    }

    public int correct(Config config) {
        return this.correct(config, (CorrectionAction correctionAction, List<String> list, Object object, Object object2) -> {});
    }

    public int correct(Config config, CorrectionListener correctionListener) {
        return this.correct(config.valueMap(), this.storage.valueMap(), new ArrayList<String>(), correctionListener, config::createSubConfig);
    }

    private int correct(Map<String, Object> map, Map<String, Object> map2, List<String> list, CorrectionListener correctionListener, Supplier<Config> supplier) {
        Object object;
        Object object2;
        String string;
        int n = 0;
        for (Map.Entry<String, Object> entry : map2.entrySet()) {
            Object object3;
            Map<String, Object> map3;
            string = entry.getKey();
            object2 = entry.getValue();
            object = map.get(string);
            if (object2 instanceof Config) {
                if (!(object instanceof Config)) {
                    map3 = supplier.get();
                    map.put(string, map3);
                    object3 = object == null ? CorrectionAction.ADD : CorrectionAction.REPLACE;
                    this.handleCorrection(list, string, object, map3, correctionListener, (CorrectionAction)((Object)object3));
                    ++n;
                    object = map3;
                }
                list.add(string);
                map3 = ((Config)object).valueMap();
                object3 = ((Config)object2).valueMap();
                n += this.correct(map3, (Map<String, Object>)object3, list, correctionListener, supplier);
                list.remove(list.size() - 1);
                continue;
            }
            map3 = (ValueSpec)object2;
            if (((ValueSpec)((Object)map3)).validator.test(object)) continue;
            object3 = ((ValueSpec)((Object)map3)).defaultValueSupplier.get();
            map.put(string, object3);
            CorrectionAction correctionAction = object == null ? CorrectionAction.ADD : CorrectionAction.REPLACE;
            this.handleCorrection(list, string, object, object3, correctionListener, correctionAction);
            ++n;
        }
        Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry;
            entry = iterator.next();
            string = entry.getKey();
            object2 = entry.getValue();
            object = map2.get(string);
            if (object != null) continue;
            iterator.remove();
            this.handleCorrection(list, string, object2, null, correctionListener, CorrectionAction.REMOVE);
            ++n;
        }
        return n;
    }

    private void handleCorrection(List<String> list, String string, Object object, Object object2, CorrectionListener correctionListener, CorrectionAction correctionAction) {
        list.add(string);
        List<String> list2 = Collections.unmodifiableList(list);
        correctionListener.onCorrect(correctionAction, list2, object, object2);
        list.remove(list.size() - 1);
    }

    private static final class ValueSpec {
        private final Supplier<?> defaultValueSupplier;
        private final Predicate<Object> validator;

        private ValueSpec(Object object, Predicate<Object> predicate) {
            this(new DumbSupplier<Object>(Objects.requireNonNull(object, "The default value must not be null.")), predicate);
        }

        private ValueSpec(Supplier<?> supplier, Predicate<Object> predicate) {
            this.defaultValueSupplier = Objects.requireNonNull(supplier, "The supplier of the default value must not be null.");
            this.validator = Objects.requireNonNull(predicate, "The validator must not be null.");
        }
    }

    private static final class DumbSupplier<T>
    implements Supplier<T> {
        private final T value;

        private DumbSupplier(T t) {
            this.value = t;
        }

        @Override
        public T get() {
            return this.value;
        }
    }

    @FunctionalInterface
    public static interface CorrectionListener {
        public void onCorrect(CorrectionAction var1, List<String> var2, Object var3, Object var4);
    }

    public static enum CorrectionAction {
        ADD,
        REPLACE,
        REMOVE;

    }
}

