/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.core.conversion;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.Config;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.conversion.ConvertedFormat;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.utils.ConfigWrapper;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.utils.TransformingMap;

abstract class AbstractConvertedConfig<C extends Config>
extends ConfigWrapper<C> {
    final Function<Object, Object> readConversion;
    final Function<Object, Object> writeConversion;
    final Predicate<Class<?>> supportPredicate;
    final ConfigFormat<?> format;

    AbstractConvertedConfig(C c, Function<Object, Object> function, Function<Object, Object> function2, Predicate<Class<?>> predicate) {
        super(c);
        this.readConversion = function;
        this.writeConversion = function2;
        this.supportPredicate = predicate;
        this.format = new ConvertedFormat(c.configFormat(), predicate);
    }

    @Override
    public <T> T set(List<String> list, Object object) {
        return (T)this.readConversion.apply(((Config)this.config).set(list, this.writeConversion.apply(object)));
    }

    @Override
    public Map<String, Object> valueMap() {
        return new TransformingMap<String, Object, Object>(((Config)this.config).valueMap(), this.readConversion, this.writeConversion, this.writeConversion);
    }

    @Override
    public <T> T getRaw(List<String> list) {
        return (T)this.readConversion.apply(((Config)this.config).getRaw(list));
    }

    @Override
    public ConfigFormat<?> configFormat() {
        return this.format;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ":" + String.valueOf(this.valueMap()) + " (original: " + String.valueOf(this.config) + ")";
    }
}

