/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.core.file;

import java.io.File;
import java.nio.file.Path;
import java.util.function.Function;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.CommentedConfig;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.Config;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.file.CommentedFileConfig;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.file.FileWatcher;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.utils.CommentedConfigWrapper;

final class AutoreloadFileConfig<C extends CommentedFileConfig>
extends CommentedConfigWrapper<C>
implements CommentedFileConfig {
    private final FileWatcher watcher;
    private final Runnable autoListener;

    AutoreloadFileConfig(C c, FileWatcher fileWatcher, Runnable runnable) {
        super(c);
        this.watcher = fileWatcher;
        this.autoListener = runnable;
        fileWatcher.addWatch(c.getNioPath(), this::autoReload);
    }

    private void autoReload() {
        this.load();
        this.autoListener.run();
    }

    @Override
    public File getFile() {
        return ((CommentedFileConfig)this.config).getFile();
    }

    @Override
    public Path getNioPath() {
        return ((CommentedFileConfig)this.config).getNioPath();
    }

    @Override
    public void save() {
        ((CommentedFileConfig)this.config).save();
    }

    @Override
    public void load() {
        ((CommentedFileConfig)this.config).load();
    }

    @Override
    public void close() {
        try {
            this.watcher.removeWatch(((CommentedFileConfig)this.config).getNioPath());
        }
        finally {
            ((CommentedFileConfig)this.config).close();
        }
    }

    @Override
    public <R> R bulkCommentedUpdate(Function<? super CommentedConfig, R> function) {
        return ((CommentedFileConfig)this.config).bulkCommentedUpdate(function);
    }

    @Override
    public <R> R bulkUpdate(Function<? super Config, R> function) {
        return ((CommentedFileConfig)this.config).bulkUpdate(function);
    }
}

