/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.core.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.ConfigFormat;

@FunctionalInterface
public interface FileNotFoundAction {
    public static final FileNotFoundAction CREATE_EMPTY = (path, configFormat) -> {
        Files.createFile(path, new FileAttribute[0]);
        configFormat.initEmptyFile(path);
        return false;
    };
    public static final FileNotFoundAction READ_NOTHING = (path, configFormat) -> false;
    public static final FileNotFoundAction THROW_ERROR = (path, configFormat) -> {
        throw new NoSuchFileException(path.toAbsolutePath().toString());
    };

    public boolean run(Path var1, ConfigFormat<?> var2) throws IOException;

    public static FileNotFoundAction copyData(URL uRL) {
        return (path, configFormat) -> {
            Files.copy(uRL.openStream(), path, new CopyOption[0]);
            return true;
        };
    }

    public static FileNotFoundAction copyData(File file) {
        return (path, configFormat) -> {
            Files.copy(new FileInputStream(file), path, new CopyOption[0]);
            return true;
        };
    }

    public static FileNotFoundAction copyData(Path path) {
        return (path2, configFormat) -> {
            Files.copy(path, path2, new CopyOption[0]);
            return true;
        };
    }

    public static FileNotFoundAction copyData(InputStream inputStream) {
        return (path, configFormat) -> {
            Files.copy(inputStream, path, new CopyOption[0]);
            return true;
        };
    }

    public static FileNotFoundAction copyResource(String string) {
        return FileNotFoundAction.copyData(FileNotFoundAction.class.getResource(string));
    }
}

