/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.core.file;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.file.DebouncedRunnable;

public final class FileWatcher {
    private static final AtomicInteger instanceCount = new AtomicInteger(0);
    private static volatile FileWatcher DEFAULT_INSTANCE = null;
    private static final Duration DEFAULT_SERVICE_POLL_TIMEOUT = Duration.ofMillis(200L);
    private static final Duration DEFAULT_DEBOUNCE_TIME = Duration.ofMillis(500L);
    private final ThreadGroup threadGroup;
    private final AtomicInteger threadCount = new AtomicInteger(0);
    private final ConcurrentMap<FileSystem, FsWatcher> watchers = new ConcurrentHashMap<FileSystem, FsWatcher>();
    private final Consumer<Throwable> exceptionHandler;
    private final Duration debounceTime;
    private final long servicePollTimeoutNanos;
    private final int instanceId = instanceCount.getAndIncrement();
    private volatile boolean running = true;

    public static synchronized FileWatcher defaultInstance() {
        if (DEFAULT_INSTANCE == null || !FileWatcher.DEFAULT_INSTANCE.running) {
            DEFAULT_INSTANCE = new FileWatcher();
        }
        return DEFAULT_INSTANCE;
    }

    public FileWatcher() {
        this(DEFAULT_DEBOUNCE_TIME);
    }

    public FileWatcher(Consumer<Exception> consumer) {
        this(DEFAULT_DEBOUNCE_TIME, throwable -> {
            if (throwable instanceof Exception) {
                consumer.accept((Exception)throwable);
            } else {
                consumer.accept(new RuntimeException((Throwable)throwable));
            }
        });
    }

    public FileWatcher(Duration duration) {
        this(duration, Throwable::printStackTrace);
    }

    public FileWatcher(Duration duration, Consumer<Throwable> consumer) {
        this(duration, DEFAULT_SERVICE_POLL_TIMEOUT, consumer);
    }

    FileWatcher(Duration duration, Duration duration2, Consumer<Throwable> consumer) {
        this.debounceTime = duration;
        this.servicePollTimeoutNanos = duration2.toNanos();
        this.exceptionHandler = consumer;
        this.threadGroup = new ThreadGroup("watchers-" + this.instanceId);
    }

    public void addWatch(File file, Runnable runnable) {
        this.addWatch(file.toPath(), runnable);
    }

    public void addWatch(Path path, Runnable runnable) {
        this.addOrPutWatch(path, runnable, ControlMessageKind.ADD);
    }

    public void setWatch(File file, Runnable runnable) {
        this.setWatch(file.toPath(), runnable);
    }

    public void setWatch(Path path, Runnable runnable) {
        this.addOrPutWatch(path, runnable, ControlMessageKind.PUT);
    }

    private void addOrPutWatch(Path path, Runnable runnable, ControlMessageKind controlMessageKind) {
        this.failIfStopped();
        try {
            if (Files.exists(path, new LinkOption[0]) && Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]).isDirectory()) {
                throw new IllegalArgumentException("FileWatcher is designed to watch files but this path is a directory, not a file: " + String.valueOf(path));
            }
        }
        catch (IOException iOException) {
            throw new WatchingException("Failed to get information about path: " + String.valueOf(path), iOException);
        }
        CanonicalPath canonicalPath = CanonicalPath.from(path);
        FileSystem fileSystem = canonicalPath.parentDirectory.getFileSystem();
        try {
            FsWatcher fsWatcher = this.watchers.computeIfAbsent(fileSystem, fileSystem2 -> {
                try {
                    WatchService watchService = fileSystem.newWatchService();
                    FsWatcher fsWatcher = new FsWatcher(this.exceptionHandler, this.debounceTime, this.servicePollTimeoutNanos, watchService);
                    String string = "config-file-watcher-" + this.instanceId + "-" + this.threadCount.getAndIncrement();
                    Thread thread = new Thread(this.threadGroup, fsWatcher, string);
                    thread.setDaemon(true);
                    thread.start();
                    return fsWatcher;
                }
                catch (IOException iOException) {
                    throw new WatchingException("Failed to start a new watcher thread for directory " + String.valueOf(canonicalPath.parentDirectory), iOException);
                }
            });
            fsWatcher.send(ControlMessage.addOrPut(controlMessageKind, canonicalPath, runnable));
        }
        catch (Exception exception) {
            throw new WatchingException("Failed to watch path '" + String.valueOf(path) + "', canonical path '" + String.valueOf(canonicalPath) + "'", exception);
        }
    }

    public void removeWatch(File file) {
        this.removeWatch(file.toPath());
    }

    public void removeWatch(Path path) {
        this.failIfStopped();
        CanonicalPath canonicalPath = CanonicalPath.from(path);
        FileSystem fileSystem = canonicalPath.parentDirectory.getFileSystem();
        FsWatcher fsWatcher = (FsWatcher)this.watchers.get(fileSystem);
        if (fsWatcher != null) {
            fsWatcher.send(ControlMessage.remove(canonicalPath));
        }
    }

    public void stop() {
        this.running = false;
        for (FsWatcher fsWatcher : this.watchers.values()) {
            fsWatcher.send(ControlMessage.poison());
        }
        this.threadGroup.interrupt();
    }

    private void failIfStopped() {
        if (!this.running) {
            throw new IllegalStateException("FileWatcher " + this.instanceId + " has been stopped and cannot be used anymore.");
        }
    }

    private static enum ControlMessageKind {
        PUT,
        ADD,
        REMOVE,
        POISON;

    }

    public static class WatchingException
    extends RuntimeException {
        public WatchingException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public WatchingException(Throwable throwable) {
            super(throwable);
        }

        public WatchingException(String string) {
            super(string);
        }
    }

    private static class CanonicalPath {
        public final Path parentDirectory;
        public final Path fileName;

        private CanonicalPath(Path path, Path path2) {
            this.parentDirectory = path;
            this.fileName = path2;
        }

        public static CanonicalPath from(Path path) {
            try {
                Path path2;
                Path path3;
                try {
                    Path path4 = path.toRealPath(new LinkOption[0]);
                    path3 = path4.getParent();
                    path2 = path4.getFileName();
                }
                catch (NoSuchFileException noSuchFileException) {
                    path3 = path.getParent().toRealPath(new LinkOption[0]);
                    path2 = path.getFileName();
                }
                return new CanonicalPath(path3, path2);
            }
            catch (IOException iOException) {
                throw new WatchingException("Failed to determine the canonical path of: " + String.valueOf(path) + "\nHint: make sure that all parent directories exist.", iOException);
            }
        }

        public String toString() {
            return String.valueOf(this.parentDirectory) + "/" + String.valueOf(this.fileName);
        }
    }

    private static final class FsWatcher
    implements Runnable {
        private final Consumer<Throwable> exceptionHandler;
        private final Duration debounceTime;
        private final long servicePollTimeoutNanos;
        private final WatchService watchService;
        private final Map<Path, WatchedDirectory> watchedDirectories = new HashMap<Path, WatchedDirectory>();
        private final ConcurrentLinkedQueue<ControlMessage> controlMessages = new ConcurrentLinkedQueue();

        FsWatcher(Consumer<Throwable> consumer, Duration duration, long l, WatchService watchService) {
            this.exceptionHandler = consumer;
            this.debounceTime = duration;
            this.servicePollTimeoutNanos = l;
            this.watchService = watchService;
        }

        void send(ControlMessage controlMessage) {
            this.controlMessages.add(controlMessage);
        }

        private WatchedDirectory watchDirectory(Path path) {
            return this.watchedDirectories.computeIfAbsent(path, path2 -> {
                try {
                    WatchKey watchKey = path.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE);
                    return new WatchedDirectory(watchKey, new HashMap<Path, DebouncedRunnable>(8));
                }
                catch (IOException iOException) {
                    this.exceptionHandler.accept(iOException);
                    return null;
                }
            });
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
            block12: while (true) {
                Iterator<WatchEvent<?>> iterator;
                WatchEvent<?> watchEvent;
                WatchEvent.Kind kind;
                Object object;
                Path path;
                Object object2;
                block19: {
                    block18: {
                        block17: {
                            ControlMessage controlMessage;
                            if ((controlMessage = this.controlMessages.poll()) == null) break block17;
                            object2 = controlMessage.path;
                            switch (controlMessage.kind.ordinal()) {
                                case 1: {
                                    path = ((CanonicalPath)object2).parentDirectory;
                                    object = ((CanonicalPath)object2).fileName;
                                    WatchedDirectory watchedDirectory = this.watchDirectory(path);
                                    if (watchedDirectory == null) break;
                                    kind = watchedDirectory.fileChangeHandlers.get(object);
                                    watchEvent = kind != null ? ((DebouncedRunnable)((Object)kind)).andThen(controlMessage.handler) : new DebouncedRunnable(controlMessage.handler, this.debounceTime);
                                    watchedDirectory.fileChangeHandlers.put((Path)object, (DebouncedRunnable)((Object)watchEvent));
                                    continue block12;
                                }
                                case 0: {
                                    path = ((CanonicalPath)object2).parentDirectory;
                                    object = ((CanonicalPath)object2).fileName;
                                    WatchedDirectory watchedDirectory = this.watchDirectory(path);
                                    if (watchedDirectory == null) break;
                                    watchEvent = new DebouncedRunnable(controlMessage.handler, this.debounceTime);
                                    watchedDirectory.fileChangeHandlers.put((Path)object, (DebouncedRunnable)((Object)watchEvent));
                                    continue block12;
                                }
                                case 2: {
                                    path = ((CanonicalPath)object2).parentDirectory;
                                    object = ((CanonicalPath)object2).fileName;
                                    WatchedDirectory watchedDirectory = this.watchedDirectories.get(path);
                                    if (watchedDirectory == null) break;
                                    watchedDirectory.fileChangeHandlers.remove(object);
                                    if (!watchedDirectory.fileChangeHandlers.isEmpty()) break;
                                    watchedDirectory.key.cancel();
                                    continue block12;
                                }
                                case 3: {
                                    break block18;
                                }
                            }
                            continue;
                        }
                        object2 = null;
                        try {
                            object2 = this.watchService.poll(this.servicePollTimeoutNanos, TimeUnit.NANOSECONDS);
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        if (object2 == null) continue;
                        path = (Path)object2.watchable();
                        object = this.watchedDirectories.get(path);
                        iterator = object2.pollEvents().iterator();
                        break block19;
                    }
                    try {
                        scheduledExecutorService.shutdown();
                        this.watchService.close();
                        this.watchedDirectories.clear();
                        return;
                    }
                    catch (IOException iOException) {
                        this.exceptionHandler.accept(iOException);
                    }
                    return;
                }
                while (iterator.hasNext()) {
                    watchEvent = iterator.next();
                    kind = watchEvent.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW) {
                        this.exceptionHandler.accept(new WatchingException("Got watch event OVERFLOW"));
                    } else {
                        Path path2 = (Path)watchEvent.context();
                        DebouncedRunnable debouncedRunnable = ((WatchedDirectory)object).fileChangeHandlers.get(path2);
                        if (debouncedRunnable != null) {
                            try {
                                debouncedRunnable.run(scheduledExecutorService);
                            }
                            catch (Exception exception) {
                                this.exceptionHandler.accept(exception);
                            }
                        }
                    }
                    if (!Thread.interrupted()) continue;
                    continue block12;
                }
                boolean bl = object2.reset();
                if (bl) continue;
                this.watchedDirectories.remove(path);
            }
        }
    }

    private static final class ControlMessage {
        private final ControlMessageKind kind;
        private final CanonicalPath path;
        private final Runnable handler;

        private ControlMessage(ControlMessageKind controlMessageKind, CanonicalPath canonicalPath, Runnable runnable) {
            this.path = canonicalPath;
            this.kind = controlMessageKind;
            this.handler = runnable;
        }

        static ControlMessage addOrPut(ControlMessageKind controlMessageKind, CanonicalPath canonicalPath, Runnable runnable) {
            if (controlMessageKind != ControlMessageKind.ADD && controlMessageKind != ControlMessageKind.PUT) {
                throw new IllegalArgumentException("Unexpected message kind " + String.valueOf((Object)controlMessageKind));
            }
            return new ControlMessage(controlMessageKind, canonicalPath, runnable);
        }

        static ControlMessage remove(CanonicalPath canonicalPath) {
            return new ControlMessage(ControlMessageKind.REMOVE, canonicalPath, null);
        }

        static ControlMessage poison() {
            return new ControlMessage(ControlMessageKind.POISON, null, null);
        }
    }

    private static final class WatchedDirectory {
        private final WatchKey key;
        private final Map<Path, DebouncedRunnable> fileChangeHandlers;

        WatchedDirectory(WatchKey watchKey, Map<Path, DebouncedRunnable> map) {
            this.key = Objects.requireNonNull(watchKey);
            this.fileChangeHandlers = Objects.requireNonNull(map);
        }
    }
}

