/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.core.io;

import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.CharacterOutput;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.Utils;

public final class CharsWrapper
implements CharSequence,
Cloneable,
Iterable<Character> {
    final char[] chars;
    final int offset;
    final int limit;

    public CharsWrapper(char ... cArray) {
        this(cArray, 0, cArray.length);
    }

    public CharsWrapper(char[] cArray, int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("limit must be bigger than offset");
        }
        this.chars = Objects.requireNonNull(cArray, "chars must not be null");
        this.offset = n;
        this.limit = n2;
    }

    public CharsWrapper(String string) {
        this(string, 0, string.length());
    }

    public CharsWrapper(String string, int n, int n2) {
        this.offset = 0;
        this.limit = n2 - n;
        this.chars = new char[this.limit];
        string.getChars(n, n2, this.chars, 0);
    }

    public CharsWrapper(CharSequence charSequence) {
        this(charSequence, 0, charSequence.length());
    }

    public CharsWrapper(CharSequence charSequence, int n, int n2) {
        this.offset = 0;
        this.limit = n2 - n;
        this.chars = new char[this.limit];
        for (int i = n; i < n2; ++i) {
            this.chars[i - n] = charSequence.charAt(i);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.limit == this.offset;
    }

    @Override
    public int length() {
        return this.limit - this.offset;
    }

    @Override
    public char charAt(int n) {
        return this.chars[this.offset + n];
    }

    public char get(int n) {
        return this.chars[this.offset + n];
    }

    public void set(int n, char c) {
        this.chars[this.offset + n] = c;
    }

    public void replaceAll(char c, char c2) {
        for (int i = this.offset; i < this.limit; ++i) {
            if (this.chars[i] != c) continue;
            this.chars[i] = c2;
        }
    }

    public boolean contains(char c) {
        return this.indexOf(c) != -1;
    }

    public int indexOf(char c) {
        for (int i = this.offset; i < this.limit; ++i) {
            if (this.chars[i] != c) continue;
            return i - this.offset;
        }
        return -1;
    }

    public int indexOfFirst(char ... cArray) {
        for (int i = this.offset; i < this.limit; ++i) {
            if (!Utils.arrayContains(cArray, this.chars[i])) continue;
            return i - this.offset;
        }
        return -1;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof CharsWrapper)) {
            return false;
        }
        CharsWrapper charsWrapper = (CharsWrapper)object;
        int n = charsWrapper.length();
        if (this.length() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = this.chars[this.offset + i];
            char c2 = charsWrapper.chars[charsWrapper.offset + i];
            if (c == c2) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(CharSequence charSequence) {
        if (charSequence == this) {
            return true;
        }
        if (charSequence == null || charSequence.length() != this.length()) {
            return false;
        }
        for (int i = 0; i < this.limit; ++i) {
            char c;
            char c2 = Character.toUpperCase(this.chars[this.offset + i]);
            if (c2 == (c = Character.toUpperCase(charSequence.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    public boolean contentEquals(CharSequence charSequence) {
        int n = this.length();
        if (charSequence == null || charSequence.length() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.chars[this.offset + i] == charSequence.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean contentEquals(char[] cArray) {
        int n = this.length();
        if (cArray == null || cArray.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.chars[this.offset + i] == cArray[i]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        int n = charSequence.length();
        if (n > this.length()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.chars[this.offset + i] == charSequence.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public CharsWrapper subSequence(int n, int n2) {
        if (this.offset + n2 > this.limit) {
            throw new ArrayIndexOutOfBoundsException(String.format("Out of bounds: this wrapper has a length of %d, but chars [%d..<%d] were requested", this.length(), n, n2));
        }
        return new CharsWrapper(Arrays.copyOfRange(this.chars, n + this.offset, n2 + this.offset));
    }

    public CharsWrapper subView(int n, int n2) {
        if (this.offset + n2 > this.limit) {
            throw new ArrayIndexOutOfBoundsException(String.format("Out of bounds: this wrapper has a length of %d, but chars [%d..<%d] were requested", this.length(), n, n2));
        }
        return new CharsWrapper(this.chars, n + this.offset, n2 + this.offset);
    }

    public CharsWrapper subView(int n) {
        if (this.offset + n > this.limit) {
            throw new ArrayIndexOutOfBoundsException(String.format("Out of bounds: this wrapper has a length of %d, but chars [%d..] were requested", this.length(), n));
        }
        return new CharsWrapper(this.chars, n + this.offset, this.limit);
    }

    public CharsWrapper trimmedView() {
        int n;
        int n2 = this.limit;
        for (n = this.offset; n < n2 && this.chars[n] <= ' '; ++n) {
        }
        while (n2 > n && this.chars[n2 - 1] <= ' ') {
            --n2;
        }
        return new CharsWrapper(this.chars, n, n2);
    }

    @Override
    public String toString() {
        return new String(this.chars, this.offset, this.length());
    }

    public int hashCode() {
        int n = 0;
        for (int i = this.offset; i < this.limit; ++i) {
            n = 31 * n + this.chars[i];
        }
        return n;
    }

    public CharsWrapper clone() {
        return new CharsWrapper(Arrays.copyOf(this.chars, this.chars.length));
    }

    @Override
    public Iterator<Character> iterator() {
        return new Iterator<Character>(){
            private int index;
            {
                this.index = CharsWrapper.this.offset;
            }

            @Override
            public boolean hasNext() {
                return this.index < CharsWrapper.this.limit;
            }

            @Override
            public Character next() {
                if (this.index >= CharsWrapper.this.limit) {
                    throw new NoSuchElementException("Index beyond limit: " + this.index);
                }
                return Character.valueOf(CharsWrapper.this.chars[this.index++]);
            }
        };
    }

    public static final class Builder
    extends Writer
    implements CharacterOutput {
        private static final char[] NULL = new char[]{'n', 'u', 'l', 'l'};
        private char[] data;
        private int cursor = 0;

        public Builder(int n) {
            this.data = new char[Math.min(2, n)];
        }

        private void ensureCapacity(int n) {
            if (this.data.length < n) {
                int n2 = Math.max(n, this.data.length * 2);
                this.data = Arrays.copyOf(this.data, n2);
            }
        }

        @Override
        public Builder append(char c) {
            this.write(c);
            return this;
        }

        @Override
        public Builder append(CharSequence charSequence) {
            if (charSequence == null) {
                return this.append(NULL);
            }
            if (charSequence instanceof String) {
                return this.append((String)charSequence);
            }
            return this.append(charSequence, 0, charSequence.length());
        }

        @Override
        public Builder append(CharSequence charSequence, int n, int n2) {
            if (charSequence == null) {
                return this.append(NULL, n, n2);
            }
            if (charSequence instanceof String) {
                return this.append((String)charSequence, n, n2);
            }
            int n3 = n2 - n;
            int n4 = this.cursor + n3;
            this.ensureCapacity(n4);
            for (int i = n; i < n2; ++i) {
                this.data[this.cursor + i] = charSequence.charAt(i);
            }
            this.cursor = n4;
            return this;
        }

        public Builder append(char ... cArray) {
            this.write(cArray);
            return this;
        }

        public Builder append(char[] cArray, int n, int n2) {
            int n3 = n2 - n;
            this.write(cArray, n, n3);
            return this;
        }

        public Builder append(String string) {
            this.write(string);
            return this;
        }

        public Builder append(String string, int n, int n2) {
            int n3 = n2 - n;
            this.write(string, n, n3);
            return this;
        }

        public Builder append(CharsWrapper charsWrapper) {
            this.write(charsWrapper);
            return this;
        }

        public Builder append(Object object) {
            if (object == null) {
                return this.append(NULL);
            }
            return this.append(object.toString());
        }

        public Builder append(Object ... objectArray) {
            for (Object object : objectArray) {
                this.append(object);
            }
            return this;
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        @Override
        public void write(int n) {
            this.write((char)n);
        }

        @Override
        public void write(char c) {
            int n = this.cursor + 1;
            this.ensureCapacity(n);
            this.data[this.cursor] = c;
            this.cursor = n;
        }

        @Override
        public void write(char ... cArray) {
            CharacterOutput.super.write(cArray);
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            int n3 = this.cursor + n2;
            this.ensureCapacity(n3);
            System.arraycopy(cArray, n, this.data, this.cursor, n2);
            this.cursor = n3;
        }

        @Override
        public void write(String string) {
            CharacterOutput.super.write(string);
        }

        @Override
        public void write(String string, int n, int n2) {
            int n3 = n + n2;
            int n4 = this.cursor + n2;
            this.ensureCapacity(n4);
            string.getChars(n, n3, this.data, this.cursor);
            this.cursor = n4;
        }

        @Override
        public void write(CharsWrapper charsWrapper) {
            CharacterOutput.super.write(charsWrapper);
        }

        public int length() {
            return this.cursor;
        }

        public char[] getChars() {
            return this.data;
        }

        public char get(int n) {
            return this.data[n];
        }

        public void set(int n, char c) {
            if (n >= this.cursor) {
                throw new IndexOutOfBoundsException("Index must not be larger than the builder's length");
            }
            this.data[n] = c;
        }

        public void compact() {
            if (this.cursor != this.data.length) {
                this.data = Arrays.copyOf(this.data, this.cursor);
            }
        }

        public CharsWrapper build() {
            return this.build(0);
        }

        public CharsWrapper build(int n) {
            return new CharsWrapper(this.data, n, this.cursor);
        }

        public CharsWrapper build(int n, int n2) {
            if (n2 > this.cursor) {
                throw new IndexOutOfBoundsException("Specified end index is larger than the builder's length!");
            }
            return new CharsWrapper(this.data, n, n2);
        }

        public CharsWrapper copyAndBuild() {
            return this.build(0);
        }

        public CharsWrapper copyAndBuild(int n) {
            return new CharsWrapper(Arrays.copyOfRange(this.data, n, this.cursor));
        }

        public CharsWrapper copyAndBuild(int n, int n2) {
            if (n2 > this.cursor) {
                throw new IndexOutOfBoundsException("Specified end index is larger than the builder's length!");
            }
            return new CharsWrapper(Arrays.copyOfRange(this.data, n, n2));
        }

        public String toString() {
            return this.toString(0);
        }

        public String toString(int n) {
            return new String(this.data, n, this.cursor - n);
        }

        public String toString(int n, int n2) {
            if (n2 > this.cursor) {
                throw new IndexOutOfBoundsException("Specified end index is larger than the builder's length!");
            }
            return new String(this.data, n, n2 - n);
        }
    }
}

