/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.core.io;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.ParsingException;

class CharsetUnicodeBom
extends Charset {
    private boolean utf8Only;

    protected CharsetUnicodeBom(boolean bl) {
        super(bl ? "UTF-8" : "UTF-8-autodetect", new String[]{"UTF-8"});
    }

    @Override
    public boolean canEncode() {
        return true;
    }

    @Override
    public boolean contains(Charset charset) {
        return StandardCharsets.UTF_8.contains(charset);
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static final class Decoder
    extends CharsetDecoder {
        private boolean utf8Only;
        private CharsetDecoder decoder = null;

        Decoder(CharsetUnicodeBom charsetUnicodeBom) {
            super(charsetUnicodeBom, 0.5f, 1.0f);
            this.utf8Only = charsetUnicodeBom.utf8Only;
        }

        private void setupDecoder(Charset charset) {
            this.decoder = charset.newDecoder().onMalformedInput(this.malformedInputAction()).onUnmappableCharacter(this.unmappableCharacterAction()).replaceWith(this.replacement());
        }

        @Override
        public boolean isAutoDetecting() {
            return true;
        }

        @Override
        public boolean isCharsetDetected() {
            return this.decoder != null;
        }

        @Override
        public Charset detectedCharset() {
            return this.decoder.charset();
        }

        @Override
        protected CoderResult implFlush(CharBuffer charBuffer) {
            return this.decoder.flush(charBuffer);
        }

        @Override
        protected void implReset() {
            this.decoder.reset();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (this.decoder != null) return this.decoder.decode(byteBuffer, charBuffer, false);
            int n = byteBuffer.position();
            try {
                if (byteBuffer.remaining() >= 2) {
                    int n2 = byteBuffer.get() & 0xFF;
                    int n3 = byteBuffer.get() & 0xFF;
                    if (n2 == 254 && n3 == 255) {
                        if (this.utf8Only) {
                            throw new ParsingException("Invalid input: it begins with an UTF-16 BE byte-order mark, but it should be plain UTF-8.");
                        }
                        this.setupDecoder(StandardCharsets.UTF_16BE);
                        n += 2;
                        return this.decoder.decode(byteBuffer, charBuffer, false);
                    }
                    if (n2 == 255 && n3 == 254) {
                        if (this.utf8Only) {
                            throw new ParsingException("Invalid input: it begins with an UTF-16 LE byte-order mark, but it should be plain UTF-8.");
                        }
                        this.setupDecoder(StandardCharsets.UTF_16LE);
                        n += 2;
                        return this.decoder.decode(byteBuffer, charBuffer, false);
                    }
                    if (n2 == 239 && n3 == 187) {
                        if (!byteBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int n4 = byteBuffer.get() & 0xFF;
                        if (n4 == 191) {
                            n += 3;
                        }
                        this.setupDecoder(StandardCharsets.UTF_8);
                        return this.decoder.decode(byteBuffer, charBuffer, false);
                    }
                    this.setupDecoder(StandardCharsets.UTF_8);
                    return this.decoder.decode(byteBuffer, charBuffer, false);
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }
    }

    private static final class Encoder
    extends CharsetEncoder {
        private final CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();

        Encoder(CharsetUnicodeBom charsetUnicodeBom) {
            super(charsetUnicodeBom, 1.1f, 3.0f);
        }

        @Override
        public boolean canEncode(char c) {
            return this.encoder.canEncode(c);
        }

        @Override
        public boolean canEncode(CharSequence charSequence) {
            return this.encoder.canEncode(charSequence);
        }

        @Override
        public boolean isLegalReplacement(byte[] byArray) {
            return this.encoder.isLegalReplacement(byArray);
        }

        @Override
        protected void implReset() {
            this.encoder.reset();
        }

        @Override
        protected CoderResult implFlush(ByteBuffer byteBuffer) {
            return this.encoder.flush(byteBuffer);
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            return this.encoder.encode(charBuffer, byteBuffer, false);
        }
    }
}

