/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.core.io;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.CharsWrapper;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.WritingException;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.WritingMode;

public interface ConfigWriter {
    public void write(UnmodifiableConfig var1, Writer var2);

    default public void write(UnmodifiableConfig unmodifiableConfig, OutputStream outputStream, Charset charset) {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, charset));){
            this.write(unmodifiableConfig, bufferedWriter);
        }
        catch (IOException iOException) {
            throw new WritingException("An I/O error occured", iOException);
        }
    }

    default public void write(UnmodifiableConfig unmodifiableConfig, OutputStream outputStream) {
        this.write(unmodifiableConfig, outputStream, StandardCharsets.UTF_8);
    }

    default public void write(UnmodifiableConfig unmodifiableConfig, Path path, WritingMode writingMode) {
        this.write(unmodifiableConfig, path, writingMode, StandardCharsets.UTF_8);
    }

    default public void write(UnmodifiableConfig unmodifiableConfig, Path path, WritingMode writingMode, Charset charset) {
        block18: {
            if (writingMode == WritingMode.REPLACE_ATOMIC) {
                Path path2 = path.resolveSibling(path.getFileName().toString() + ".new.tmp");
                try (OutputStream outputStream = Files.newOutputStream(path2, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                    this.write(unmodifiableConfig, outputStream, charset);
                    Files.move(path2, path, StandardCopyOption.ATOMIC_MOVE);
                    break block18;
                }
                catch (AtomicMoveNotSupportedException atomicMoveNotSupportedException) {
                    String string = String.format("Failed to atomically move the config from '%s' to '%s': WritingMode.REPLACE_ATOMIC is not supported for this path, use WritingMode.REPLACE instead.\n%s", path2.toString(), path.toString(), "Note: you may see *.new.tmp files after this error, they contain the \"new version\" of your configurations and can be safely removed.If you want, you can manually copy their content into your regular configuration files (replacing the old config).");
                    throw new WritingException(string, atomicMoveNotSupportedException);
                }
                catch (IOException iOException) {
                    String string = String.format("Failed to write (%s) the config to: %s", writingMode.toString(), path.toString());
                    throw new WritingException(string, iOException);
                }
            }
            StandardOpenOption standardOpenOption = writingMode == WritingMode.APPEND ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING;
            try (OutputStream outputStream = Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE, standardOpenOption);){
                this.write(unmodifiableConfig, outputStream, charset);
            }
            catch (IOException iOException) {
                String string = String.format("Failed to write (%s) the config to: %s", writingMode.toString(), path.toString());
                throw new WritingException(string, iOException);
            }
        }
    }

    default public void write(UnmodifiableConfig unmodifiableConfig, File file, WritingMode writingMode) {
        this.write(unmodifiableConfig, file, writingMode, StandardCharsets.UTF_8);
    }

    default public void write(UnmodifiableConfig unmodifiableConfig, File file, WritingMode writingMode, Charset charset) {
        this.write(unmodifiableConfig, file.toPath(), writingMode, charset);
    }

    default public void write(UnmodifiableConfig unmodifiableConfig, URL uRL) {
        URLConnection uRLConnection;
        try {
            uRLConnection = uRL.openConnection();
        }
        catch (IOException iOException) {
            throw new WritingException("Unable to connect to the URL", iOException);
        }
        String string = uRLConnection.getContentEncoding();
        Charset charset = string == null ? StandardCharsets.UTF_8 : Charset.forName(string);
        try (OutputStream outputStream = uRLConnection.getOutputStream();){
            this.write(unmodifiableConfig, outputStream, charset);
        }
        catch (IOException iOException) {
            throw new WritingException("An I/O error occured", iOException);
        }
    }

    default public String writeToString(UnmodifiableConfig unmodifiableConfig) {
        CharsWrapper.Builder builder = new CharsWrapper.Builder(64);
        this.write(unmodifiableConfig, builder);
        return builder.toString();
    }
}

