/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde;

import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.ObjectSerializer;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.SerializerContext;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.StandardSerializers;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.Util;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.ValueSerializer;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.ValueSerializerProvider;

public final class ObjectSerializerBuilder {
    final IdentityHashMap<Class<?>, ValueSerializer<?, ?>> classBasedSerializers = new IdentityHashMap(7);
    final List<ValueSerializerProvider<?, ?>> generalProviders = new ArrayList();
    ValueSerializerProvider<?, ?> defaultProvider = NoProvider.INSTANCE;
    boolean applyTransientModifier = true;

    ObjectSerializerBuilder(boolean bl) {
        if (bl) {
            this.registerStandardSerializers();
        }
    }

    public ObjectSerializer build() {
        return new ObjectSerializer(this);
    }

    public <V, R> void withSerializerForExactClass(Class<V> clazz, ValueSerializer<? super V, ? extends R> valueSerializer) {
        this.classBasedSerializers.put(clazz, valueSerializer);
    }

    public <V, R> void withSerializerForClass(Class<V> clazz, ValueSerializer<? super V, ? extends R> valueSerializer) {
        this.generalProviders.add((clazz2, serializerContext) -> clazz2 != null && Util.canAssign(clazz, clazz2) ? valueSerializer : null);
    }

    public <V, R> void withSerializerProvider(ValueSerializerProvider<V, R> valueSerializerProvider) {
        this.generalProviders.add(valueSerializerProvider);
    }

    public <V, R> void withDefaultSerializerProvider(ValueSerializerProvider<V, R> valueSerializerProvider) {
        this.defaultProvider = valueSerializerProvider;
    }

    public void withDefaultSerializerProvider() {
        StandardSerializers.TrivialSerializer trivialSerializer = new StandardSerializers.TrivialSerializer();
        StandardSerializers.FieldsToConfigSerializer fieldsToConfigSerializer = new StandardSerializers.FieldsToConfigSerializer();
        ValueSerializer<Object, Object> valueSerializer = (object, serializerContext) -> ((Number)object).intValue();
        ValueSerializer<Object, Object> valueSerializer2 = (object, serializerContext) -> (int)((Character)object).charValue();
        this.defaultProvider = (clazz, serializerContext) -> {
            ConfigFormat<Integer> configFormat = serializerContext.configFormat();
            if (configFormat == null || configFormat.supportsType(clazz)) {
                return trivialSerializer;
            }
            if (clazz != null && (Util.isPrimitiveOrWrapper(clazz) || clazz == String.class || clazz.isArray())) {
                if (configFormat.supportsType(Integer.TYPE) && Util.canAssign(Integer.TYPE, clazz)) {
                    if (clazz == Character.class || clazz == Character.TYPE) {
                        return valueSerializer2;
                    }
                    return valueSerializer;
                }
                return null;
            }
            return fieldsToConfigSerializer;
        };
    }

    public void serializeTransientFields() {
        this.applyTransientModifier = false;
    }

    private void registerStandardSerializers() {
        this.withDefaultSerializerProvider();
        StandardSerializers.MapSerializer mapSerializer = new StandardSerializers.MapSerializer();
        StandardSerializers.CollectionSerializer collectionSerializer = new StandardSerializers.CollectionSerializer();
        StandardSerializers.IterableSerializer iterableSerializer = new StandardSerializers.IterableSerializer();
        StandardSerializers.ArraySerializer arraySerializer = new StandardSerializers.ArraySerializer();
        StandardSerializers.EnumSerializer enumSerializer = new StandardSerializers.EnumSerializer();
        StandardSerializers.TrivialSerializer trivialSerializer = new StandardSerializers.TrivialSerializer();
        StandardSerializers.UuidSerializer uuidSerializer = new StandardSerializers.UuidSerializer();
        this.withSerializerProvider((clazz, serializerContext) -> {
            if (clazz == null) {
                ConfigFormat<?> configFormat = serializerContext.configFormat();
                if (configFormat == null || configFormat.supportsType(null)) {
                    return trivialSerializer;
                }
                return null;
            }
            if (Map.class.isAssignableFrom(clazz)) {
                return mapSerializer;
            }
            if (Collection.class.isAssignableFrom(clazz)) {
                return collectionSerializer;
            }
            if (Iterable.class.isAssignableFrom(clazz)) {
                return iterableSerializer;
            }
            if (UnmodifiableConfig.class.isAssignableFrom(clazz)) {
                return trivialSerializer;
            }
            if (Enum.class.isAssignableFrom(clazz)) {
                return enumSerializer;
            }
            if (clazz.isArray()) {
                return arraySerializer;
            }
            if (clazz == UUID.class) {
                return uuidSerializer;
            }
            return null;
        });
    }

    static final class NoProvider
    implements ValueSerializerProvider<Object, Object> {
        static final NoProvider INSTANCE = new NoProvider();

        NoProvider() {
        }

        @Override
        public ValueSerializer<Object, Object> provide(Class<?> clazz, SerializerContext serializerContext) {
            return null;
        }
    }
}

