/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.CommentedConfig;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.Config;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.AnnotationProcessor;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.ObjectSerializer;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.SerdeAssertException;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.SerdeException;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.ValueSerializer;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.annotations.SerdeAssert;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.annotations.SerdeComment;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.annotations.SerdeKey;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.annotations.SerdePhase;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.annotations.SerdeSkipSerializingIf;

public final class SerializerContext {
    final ObjectSerializer settings;
    final Supplier<? extends ConfigFormat<?>> formatSupplier;
    final Supplier<? extends Config> configSupplier;

    SerializerContext(ObjectSerializer objectSerializer, Supplier<? extends ConfigFormat<?>> supplier, Supplier<? extends Config> supplier2) {
        this.settings = objectSerializer;
        this.formatSupplier = supplier;
        this.configSupplier = supplier2;
    }

    public ConfigFormat<?> configFormat() {
        return this.formatSupplier.get();
    }

    public Config createConfig() {
        return this.configSupplier.get();
    }

    public CommentedConfig createCommentedConfig() {
        return CommentedConfig.fake(this.createConfig());
    }

    public Object serializeValue(Object object) {
        ValueSerializer valueSerializer = this.settings.findValueSerializer(object, this);
        return valueSerializer.serialize(object, this);
    }

    public void serializeFields(Object object, Config config) {
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                Object object2;
                if (!this.preCheck(field)) continue;
                try {
                    object2 = field.get(object);
                }
                catch (Exception exception) {
                    throw new SerdeException("Failed to read field `" + String.valueOf(field) + "`", exception);
                }
                if (this.skipField(field, object, object2)) continue;
                List<String> list = Collections.singletonList(this.configKey(field));
                String string = this.configComment(field);
                Supplier<?> supplier = this.settings.findDefaultValueSupplier(object2, field, object);
                if (supplier != null) {
                    try {
                        object2 = supplier.get();
                    }
                    catch (Exception exception) {
                        throw new SerdeException("Error in default value provider for field " + String.valueOf(field));
                    }
                }
                if (!this.assertField(field, object, object2)) {
                    throw new SerdeAssertException("Field `" + String.valueOf(field) + "` has an invalid value: " + String.valueOf(object2));
                }
                ValueSerializer valueSerializer = this.settings.findValueSerializer(object2, this);
                try {
                    Object r = valueSerializer.serialize(object2, this);
                    config.set(list, r);
                    if (string == null || !(config instanceof CommentedConfig)) continue;
                    ((CommentedConfig)config).setComment(list, string);
                }
                catch (Exception exception) {
                    throw new SerdeException("Error during serialization of field `" + String.valueOf(field) + "` with serializer " + String.valueOf(valueSerializer), exception);
                }
            }
        }
    }

    private String configKey(Field field) {
        SerdeKey serdeKey = field.getAnnotation(SerdeKey.class);
        return serdeKey == null ? field.getName() : serdeKey.value();
    }

    private String configComment(Field field) {
        SerdeComment[] serdeCommentArray = (SerdeComment[])field.getDeclaredAnnotationsByType(SerdeComment.class);
        if (serdeCommentArray.length == 0) {
            return null;
        }
        Object object = serdeCommentArray[0].value();
        for (int i = 1; i < serdeCommentArray.length; ++i) {
            object = (String)object + "\n";
            object = (String)object + serdeCommentArray[i].value();
        }
        return object;
    }

    private boolean skipField(Field field, Object object, Object object2) {
        SerdeSkipSerializingIf serdeSkipSerializingIf = field.getAnnotation(SerdeSkipSerializingIf.class);
        if (serdeSkipSerializingIf == null) {
            return false;
        }
        try {
            Predicate<?> predicate = AnnotationProcessor.resolveSkipSerializingIfPredicate(serdeSkipSerializingIf, object, field);
            return predicate.test(object2);
        }
        catch (Exception exception) {
            String string = "Failed to resolve or apply skip predicate for serialization of field " + String.valueOf(field);
            throw new SerdeException(string, exception);
        }
    }

    private boolean assertField(Field field, Object object, Object object2) {
        SerdeAssert[] serdeAssertArray = (SerdeAssert[])field.getAnnotationsByType(SerdeAssert.class);
        if (serdeAssertArray == null || serdeAssertArray.length == 0) {
            return true;
        }
        try {
            Predicate<?> predicate = AnnotationProcessor.resolveAssertPredicate(serdeAssertArray, object, SerdePhase.SERIALIZING, field);
            if (predicate == null) {
                return true;
            }
            return predicate.test(object2);
        }
        catch (Exception exception) {
            String string = "Failed to resolve or apply assertion for serialization of field " + String.valueOf(field);
            throw new SerdeException(string, exception);
        }
    }

    private boolean preCheck(Field field) {
        int n = field.getModifiers();
        if (Modifier.isStatic(n) || field.isSynthetic()) {
            return false;
        }
        if (Modifier.isTransient(n) && this.settings.applyTransientModifier) {
            return false;
        }
        if (Modifier.isFinal(n) || !Modifier.isPublic(n)) {
            field.setAccessible(true);
        }
        return true;
    }
}

