/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.Config;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.SerdeException;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.SerializerContext;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.ValueSerializer;

final class StandardSerializers {
    private StandardSerializers() {
    }

    static final class UuidSerializer
    implements ValueSerializer<UUID, String> {
        UuidSerializer() {
        }

        @Override
        public String serialize(UUID uUID, SerializerContext serializerContext) {
            return uUID.toString();
        }
    }

    static final class FieldsToConfigSerializer
    implements ValueSerializer<Object, Config> {
        FieldsToConfigSerializer() {
        }

        @Override
        public Config serialize(Object object, SerializerContext serializerContext) {
            Config config = serializerContext.createConfig();
            serializerContext.serializeFields(object, config);
            return config;
        }
    }

    static final class TrivialSerializer
    implements ValueSerializer<Object, Object> {
        TrivialSerializer() {
        }

        @Override
        public Object serialize(Object object, SerializerContext serializerContext) {
            return object;
        }
    }

    static final class EnumSerializer
    implements ValueSerializer<Enum<?>, String> {
        EnumSerializer() {
        }

        @Override
        public String serialize(Enum<?> enum_, SerializerContext serializerContext) {
            return enum_.name();
        }
    }

    static final class ArraySerializer
    implements ValueSerializer<Object, List<?>> {
        ArraySerializer() {
        }

        @Override
        public List<?> serialize(Object object, SerializerContext serializerContext) {
            int n = Array.getLength(object);
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            for (int i = 0; i < n; ++i) {
                Object object2 = Array.get(object, i);
                Object object3 = serializerContext.serializeValue(object2);
                arrayList.add(object3);
            }
            return arrayList;
        }
    }

    static final class IterableSerializer
    implements ValueSerializer<Iterable<?>, List<?>> {
        IterableSerializer() {
        }

        @Override
        public List<?> serialize(Iterable<?> iterable, SerializerContext serializerContext) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Object obj : iterable) {
                Object object = serializerContext.serializeValue(obj);
                arrayList.add(object);
            }
            return arrayList;
        }
    }

    static final class CollectionSerializer
    implements ValueSerializer<Collection<?>, List<?>> {
        CollectionSerializer() {
        }

        @Override
        public List<?> serialize(Collection<?> collection, SerializerContext serializerContext) {
            ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
            for (Object obj : collection) {
                Object object = serializerContext.serializeValue(obj);
                arrayList.add(object);
            }
            return arrayList;
        }
    }

    static final class MapSerializer
    implements ValueSerializer<Map<?, ?>, Config> {
        MapSerializer() {
        }

        @Override
        public Config serialize(Map<?, ?> map, SerializerContext serializerContext) {
            Config config = serializerContext.createConfig();
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                Object object;
                Object obj = entry.getKey();
                if (!(obj instanceof String)) {
                    object = obj == null ? "null" : obj.getClass().toString();
                    throw new SerdeException("Map keys must be strings, invalid key type " + (String)object + " in value.");
                }
                object = Collections.singletonList((String)obj);
                Object object2 = serializerContext.serializeValue(entry.getValue());
                config.set((List<String>)object, object2);
            }
            return config;
        }
    }
}

