/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.Buffer;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.serde.SerdeException;

final class Util {
    private static final IdentityHashMap<Class<?>, TypeAndOrder> PRIMITIVE_TO_WRAPPER = new IdentityHashMap();
    private static final IdentityHashMap<Class<?>, TypeAndOrder> WRAPPER_TO_PRIMITIVE = new IdentityHashMap();

    Util() {
    }

    static boolean isEmpty(Object object) {
        Class<?> clazz;
        if (object instanceof Collection) {
            return ((Collection)object).isEmpty();
        }
        if (object instanceof Map) {
            return ((Map)object).isEmpty();
        }
        if (object instanceof UnmodifiableConfig) {
            return ((UnmodifiableConfig)object).isEmpty();
        }
        if (object instanceof CharSequence) {
            return ((CharSequence)object).length() == 0;
        }
        if (object instanceof Optional) {
            return !((Optional)object).isPresent();
        }
        if (object instanceof Buffer) {
            ((Buffer)object).hasRemaining();
        }
        if ((clazz = object.getClass()).isArray()) {
            return Array.getLength(object) == 0;
        }
        return Util.isEmptyWithReflection(clazz, object);
    }

    private static boolean isEmptyWithReflection(Class<?> clazz, Object object) {
        Method method;
        AdditionalEmptyables.EmptyableClass emptyableClass = AdditionalEmptyables.scalaIterableOnce;
        if (emptyableClass != null && emptyableClass.isInstance(clazz)) {
            return emptyableClass.isEmpty(object);
        }
        AdditionalEmptyables.EmptyableClass emptyableClass2 = AdditionalEmptyables.kotlinCollection;
        if (emptyableClass2 != null && emptyableClass2.isInstance(clazz)) {
            return emptyableClass2.isEmpty(object);
        }
        try {
            method = clazz.getMethod("isEmpty", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return false;
        }
        if (method.getReturnType() != Boolean.TYPE) {
            return false;
        }
        try {
            return (Boolean)method.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            throw new SerdeException("Exception during call to isEmpty() on " + String.valueOf(object), exception);
        }
    }

    static boolean canAssign(Class<?> clazz, Class<?> clazz2) {
        if (clazz2 == null) {
            return !clazz.isPrimitive();
        }
        if (clazz.isPrimitive() || clazz2.isPrimitive()) {
            TypeAndOrder typeAndOrder = clazz.isPrimitive() ? PRIMITIVE_TO_WRAPPER.get(clazz) : WRAPPER_TO_PRIMITIVE.get(clazz);
            TypeAndOrder typeAndOrder2 = clazz2.isPrimitive() ? PRIMITIVE_TO_WRAPPER.get(clazz2) : WRAPPER_TO_PRIMITIVE.get(clazz2);
            return typeAndOrder != null && typeAndOrder2 != null && typeAndOrder.canAssignValue(typeAndOrder2);
        }
        return clazz.isAssignableFrom(clazz2);
    }

    static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        return clazz.isPrimitive() || WRAPPER_TO_PRIMITIVE.get(clazz) != null;
    }

    static boolean isPrimitiveOrWrapperNumber(Class<?> clazz) {
        return Util.isPrimitiveOrWrapper(clazz) && clazz != Boolean.class && clazz != Boolean.TYPE && clazz != Character.class && clazz != Character.TYPE;
    }

    static void addPrimitiveAndWrapper(Class<?> clazz, Class<?> clazz2) {
        PRIMITIVE_TO_WRAPPER.put(clazz, new TypeAndOrder(PRIMITIVE_TO_WRAPPER.size(), clazz2));
        WRAPPER_TO_PRIMITIVE.put(clazz2, new TypeAndOrder(WRAPPER_TO_PRIMITIVE.size(), clazz));
    }

    static {
        Util.addPrimitiveAndWrapper(Boolean.TYPE, Boolean.class);
        Util.addPrimitiveAndWrapper(Byte.TYPE, Byte.class);
        Util.addPrimitiveAndWrapper(Short.TYPE, Short.class);
        Util.addPrimitiveAndWrapper(Character.TYPE, Character.class);
        Util.addPrimitiveAndWrapper(Integer.TYPE, Integer.class);
        Util.addPrimitiveAndWrapper(Long.TYPE, Long.class);
        Util.addPrimitiveAndWrapper(Float.TYPE, Float.class);
        Util.addPrimitiveAndWrapper(Double.TYPE, Double.class);
    }

    private static final class AdditionalEmptyables {
        static final EmptyableClass scalaIterableOnce = AdditionalEmptyables.classOrNull("scala.collection.IterableOnce");
        static final EmptyableClass kotlinCollection = AdditionalEmptyables.classOrNull("kotlin.collections.Collection");

        private AdditionalEmptyables() {
        }

        private static EmptyableClass classOrNull(String string) {
            Method method;
            Class<?> clazz;
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            try {
                method = clazz.getMethod("isEmpty", new Class[0]);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                return null;
            }
            if (method.getReturnType() != Boolean.TYPE) {
                return null;
            }
            return new EmptyableClass(clazz, method);
        }

        private static class EmptyableClass {
            final Class<?> cls;
            final Method isEmptyMethod;

            EmptyableClass(Class<?> clazz, Method method) {
                this.cls = clazz;
                this.isEmptyMethod = method;
            }

            boolean isInstance(Class<?> clazz) {
                return this.cls.isAssignableFrom(clazz);
            }

            boolean isEmpty(Object object) {
                try {
                    return (Boolean)this.isEmptyMethod.invoke(object, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
                    throw new SerdeException("Exception during call to isEmpty() on " + String.valueOf(object), exception);
                }
            }
        }
    }

    private static final class TypeAndOrder {
        final int order;
        final Class<?> type;

        TypeAndOrder(int n, Class<?> clazz) {
            this.order = n;
            this.type = clazz;
        }

        boolean canAssignValue(TypeAndOrder typeAndOrder) {
            if (this.order == 0) {
                return typeAndOrder.order == 0;
            }
            if (typeAndOrder.order == 0) {
                return false;
            }
            return this.order >= typeAndOrder.order;
        }

        public String toString() {
            return "TypeAndOrder [order=" + this.order + ", type=" + String.valueOf(this.type) + "]";
        }
    }
}

