/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.core.utils;

import java.io.Reader;
import java.util.Objects;

public final class FastStringReader
extends Reader {
    private final String str;
    private final int lim;
    private int cursor = 0;
    private int mark;

    public FastStringReader(String string, int n) {
        if (n > string.length() || n < 0) {
            throw new IllegalArgumentException("Invalid limit " + n + ": must be >= 0 and < str.length()");
        }
        this.str = Objects.requireNonNull(string, "The string must not be null.");
        this.lim = n;
    }

    public FastStringReader(String string) {
        this.str = Objects.requireNonNull(string, "The string must not be null.");
        this.lim = string.length();
    }

    @Override
    public int read() {
        return this.cursor < this.lim ? (int)this.str.charAt(this.cursor++) : -1;
    }

    @Override
    public int read(char[] cArray, int n, int n2) {
        if (this.cursor == this.lim) {
            return -1;
        }
        n2 = Math.min(n2, this.lim - this.cursor);
        int n3 = this.cursor + n2;
        this.str.getChars(this.cursor, n3, cArray, n);
        this.cursor = n3;
        return n2;
    }

    @Override
    public long skip(long l) {
        int n = (int)l;
        this.cursor += n;
        return n;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int n) {
        this.mark = this.cursor;
    }

    @Override
    public void reset() {
        this.cursor = this.mark;
    }

    @Override
    public boolean ready() {
        return true;
    }

    @Override
    public void close() {
    }
}

