/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.toml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.CommentedConfig;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.Config;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.CharacterInput;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.CharsWrapper;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.ParsingException;
import me.roundaround.pickupnotifications.roundalib.nightconfig.toml.StringParser;
import me.roundaround.pickupnotifications.roundalib.nightconfig.toml.Toml;
import me.roundaround.pickupnotifications.roundalib.nightconfig.toml.TomlParser;
import me.roundaround.pickupnotifications.roundalib.nightconfig.toml.ValueParser;

final class TableParser {
    private static final char[] KEY_END = new char[]{'\t', ' ', '=', '.', '\n', '\r', ']', ':'};

    static <T extends CommentedConfig> T parseInline(CharacterInput characterInput, TomlParser tomlParser, T t) {
        tomlParser.registerInlineTable(t);
        boolean bl = t.isEmpty();
        boolean bl2 = false;
        while (true) {
            char c;
            if ((c = Toml.readNonSpaceChar(characterInput, false)) == '}') {
                if (bl2) {
                    throw new ParsingException("Invalid trailing comma in inline table");
                }
                return t;
            }
            List<String> list = TableParser.parseDottedKey(characterInput, c, tomlParser);
            TableParser.checkDuplicateKeyBecauseOfParents(list, t, bl);
            Object object = ValueParser.parse(characterInput, tomlParser, t);
            Object object2 = tomlParser.getParsingMode().put(t, list, object);
            TableParser.checkDuplicateKey(list, object2, true);
            char c2 = Toml.readNonSpaceChar(characterInput, false);
            if (c2 == '}') {
                return t;
            }
            if (c2 != ',') {
                throw new ParsingException("Invalid entry separator '" + c2 + "' in inline table.");
            }
            bl2 = true;
        }
    }

    static <T extends CommentedConfig> T parseNormal(CharacterInput characterInput, TomlParser tomlParser, T t) {
        boolean bl = t.isEmpty();
        while (true) {
            ArrayList<CharsWrapper> arrayList;
            int n;
            if ((n = Toml.readUseful(characterInput, arrayList = new ArrayList<CharsWrapper>(2))) == -1 || n == 91) {
                tomlParser.setComment(arrayList);
                return t;
            }
            List<String> list = TableParser.parseDottedKey(characterInput, (char)n, tomlParser);
            TableParser.checkDuplicateKeyBecauseOfParents(list, t, bl);
            Object object = ValueParser.parse(characterInput, tomlParser, t);
            Object object2 = tomlParser.getParsingMode().put(t, list, object);
            TableParser.checkDuplicateKey(list, object2, tomlParser.configWasEmpty());
            int n2 = Toml.readNonSpace(characterInput, false);
            if (n2 == -1) {
                return t;
            }
            if (n2 == 35) {
                CharsWrapper charsWrapper = Toml.readLine(characterInput);
                arrayList.add(charsWrapper);
            } else if (n2 != 10 && n2 != 13) {
                throw new ParsingException("Invalid character '" + (char)n2 + "' after table entry \"" + String.valueOf(list) + "\" = " + String.valueOf(object));
            }
            tomlParser.setComment(arrayList);
            t.setComment(list, tomlParser.consumeComment());
        }
    }

    private static void checkDuplicateKeyBecauseOfParents(List<String> list, Config config, boolean bl) {
        if (!bl || list.size() <= 1) {
            return;
        }
        Config config2 = config;
        int n = 0;
        for (String string : list.subList(0, list.size() - 1)) {
            List<String> list2 = Collections.singletonList(string);
            Object t = config2.get(list2);
            if (t == null) {
                return;
            }
            if (!(t instanceof Config)) {
                throw new ParsingException(String.format("Wrong duplicate key %s: intermediary level %s already exists", list, list.subList(0, n + 1)));
            }
            config2 = (Config)t;
            ++n;
        }
    }

    private static void checkDuplicateKey(Object object, Object object2, boolean bl) {
        if (object2 != null && bl) {
            throw new ParsingException("Invalid TOML data: entry \"" + String.valueOf(object) + "\" defined twice in its table.");
        }
    }

    static CommentedConfig parseNormal(CommentedConfig commentedConfig, CharacterInput characterInput, TomlParser tomlParser) {
        return TableParser.parseNormal(characterInput, tomlParser, commentedConfig.createSubConfig());
    }

    static List<String> parseTableName(CharacterInput characterInput, TomlParser tomlParser, boolean bl) {
        char c;
        List<String> list = tomlParser.createList();
        do {
            char c2;
            char c3;
            if ((c3 = Toml.readNonSpaceChar(characterInput, false)) == ']') {
                throw new ParsingException("Tables names must not be empty.");
            }
            String string = TableParser.parseNonDottedKey(characterInput, c3, tomlParser);
            list.add(string);
            c = Toml.readNonSpaceChar(characterInput, false);
            if (c != ']') continue;
            if (bl && (c2 = characterInput.readChar()) != ']') {
                throw new ParsingException("Invalid declaration of an element of an array of tables: it ends by ]" + c2 + " but should end by ]]");
            }
            c2 = Toml.readNonSpaceChar(characterInput, false);
            if (c2 == '#') {
                CharsWrapper charsWrapper = Toml.readLine(characterInput);
                tomlParser.setComment(charsWrapper);
            } else if (c2 != '\n' && c2 != '\r') {
                throw new ParsingException("Invalid character '" + c2 + "' after a table declaration.");
            }
            return list;
        } while (c == '.');
        throw new ParsingException("Invalid separator '" + c + "' in table name.");
    }

    static List<String> parseDottedKey(CharacterInput characterInput, char c, TomlParser tomlParser) {
        List<String> list = tomlParser.createList();
        char c2 = c;
        while (true) {
            String string = TableParser.parseNonDottedKey(characterInput, c2, tomlParser);
            list.add(string);
            char c3 = Toml.readNonSpaceChar(characterInput, false);
            if (Toml.isKeyValueSeparator(c3, tomlParser.isLenientWithSeparators())) {
                return list;
            }
            if (c3 != '.') {
                throw new ParsingException("Invalid character '" + c3 + "' after key " + String.valueOf(list));
            }
            c2 = Toml.readNonSpaceChar(characterInput, false);
        }
    }

    static String parseNonDottedKey(CharacterInput characterInput, char c, TomlParser tomlParser) {
        if (c == '\"') {
            return StringParser.parseBasic(characterInput, tomlParser);
        }
        if (c == '\'') {
            return StringParser.parseLiteral(characterInput, tomlParser);
        }
        CharsWrapper charsWrapper = characterInput.readCharsUntil(KEY_END);
        String string = new CharsWrapper.Builder(charsWrapper.length() + 1).append(c).append(charsWrapper).toString();
        if (string.isEmpty()) {
            throw new ParsingException("Empty bare keys aren't allowed.");
        }
        if (!Toml.isValidBareKey(string, tomlParser.isLenientWithBareKeys())) {
            throw new ParsingException("Invalid bare key: '" + string + "'");
        }
        return string;
    }

    private TableParser() {
    }
}

