/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.toml;

import java.time.ZoneOffset;
import java.time.temporal.ChronoField;
import java.time.temporal.Temporal;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.CharacterOutput;

final class TemporalWriter {
    static void write(Temporal temporal, CharacterOutput characterOutput) {
        if (temporal.isSupported(ChronoField.YEAR)) {
            TemporalWriter.writeDate(temporal, characterOutput);
            if (temporal.isSupported(ChronoField.HOUR_OF_DAY)) {
                characterOutput.write('T');
                TemporalWriter.writeHour(temporal, characterOutput);
                if (temporal.isSupported(ChronoField.OFFSET_SECONDS)) {
                    int n = temporal.get(ChronoField.OFFSET_SECONDS);
                    ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n);
                    characterOutput.write(zoneOffset.getId());
                }
            }
        } else if (temporal.isSupported(ChronoField.HOUR_OF_DAY)) {
            TemporalWriter.writeHour(temporal, characterOutput);
        }
    }

    private static void writeDate(Temporal temporal, CharacterOutput characterOutput) {
        int n = temporal.get(ChronoField.YEAR);
        int n2 = temporal.get(ChronoField.MONTH_OF_YEAR);
        int n3 = temporal.get(ChronoField.DAY_OF_MONTH);
        TemporalWriter.writePadded(n, 4, characterOutput);
        characterOutput.write('-');
        TemporalWriter.writePadded(n2, 2, characterOutput);
        characterOutput.write('-');
        TemporalWriter.writePadded(n3, 2, characterOutput);
    }

    private static void writeHour(Temporal temporal, CharacterOutput characterOutput) {
        int n;
        int n2 = temporal.get(ChronoField.HOUR_OF_DAY);
        int n3 = temporal.get(ChronoField.MINUTE_OF_HOUR);
        int n4 = temporal.get(ChronoField.SECOND_OF_MINUTE);
        TemporalWriter.writePadded(n2, 2, characterOutput);
        characterOutput.write(':');
        TemporalWriter.writePadded(n3, 2, characterOutput);
        characterOutput.write(':');
        TemporalWriter.writePadded(n4, 2, characterOutput);
        if (temporal.isSupported(ChronoField.NANO_OF_SECOND)) {
            int n5 = temporal.get(ChronoField.NANO_OF_SECOND);
            if (n5 != 0) {
                characterOutput.write('.');
                TemporalWriter.writePaddedAndTrimmed(n5, 9, characterOutput);
            }
        } else if (temporal.isSupported(ChronoField.MILLI_OF_SECOND) && (n = temporal.get(ChronoField.MILLI_OF_SECOND)) != 0) {
            characterOutput.write('.');
            TemporalWriter.writePaddedAndTrimmed(n, 6, characterOutput);
        }
    }

    private static void writePadded(int n, int n2, CharacterOutput characterOutput) {
        String string = Integer.toString(n);
        for (int i = string.length(); i < n2; ++i) {
            characterOutput.write('0');
        }
        characterOutput.write(string);
    }

    private static void writePaddedAndTrimmed(int n, int n2, CharacterOutput characterOutput) {
        int n3;
        int n4;
        String string = Integer.toString(n);
        for (n4 = n3 = string.length(); n4 < n2; ++n4) {
            characterOutput.write('0');
        }
        for (n4 = n3 - 1; n4 >= 1; --n4) {
            if (string.charAt(n4) != '0') continue;
            --n3;
        }
        characterOutput.write(string, 0, n3);
    }

    private TemporalWriter() {
    }
}

