/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.toml;

import java.util.List;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.CharacterInput;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.CharsWrapper;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.Utils;

final class Toml {
    private static final char[] WHITESPACE_OR_NEWLINE = new char[]{'\t', ' ', '\n', '\r'};
    private static final char[] WHITESPACE = new char[]{'\t', ' '};
    private static final char[] NEWLINE = new char[]{'\n'};
    private static final char[] FORBIDDEN_IN_ALL_BARE_KEYS = new char[]{'.', '[', ']', '#', '='};

    static char readUsefulChar(CharacterInput characterInput) {
        char c = characterInput.readCharAndSkip(WHITESPACE_OR_NEWLINE);
        while (c == '#') {
            characterInput.readCharsUntil(NEWLINE);
            c = characterInput.readCharAndSkip(WHITESPACE_OR_NEWLINE);
        }
        return c;
    }

    static int readUseful(CharacterInput characterInput, List<CharsWrapper> list) {
        int n = characterInput.readAndSkip(WHITESPACE_OR_NEWLINE);
        while (n == 35) {
            CharsWrapper charsWrapper = Toml.readLine(characterInput);
            list.add(charsWrapper);
            n = characterInput.readAndSkip(WHITESPACE_OR_NEWLINE);
        }
        return n;
    }

    static char readNonSpaceChar(CharacterInput characterInput, boolean bl) {
        return bl ? characterInput.readCharAndSkip(WHITESPACE_OR_NEWLINE) : characterInput.readCharAndSkip(WHITESPACE);
    }

    static int readNonSpace(CharacterInput characterInput, boolean bl) {
        return bl ? characterInput.readAndSkip(WHITESPACE_OR_NEWLINE) : characterInput.readAndSkip(WHITESPACE);
    }

    static CharsWrapper readLine(CharacterInput characterInput) {
        CharsWrapper charsWrapper = characterInput.readUntil(NEWLINE);
        int n = charsWrapper.length() - 1;
        if (n >= 0 && charsWrapper.get(n) == '\r') {
            return charsWrapper.subView(0, n);
        }
        return charsWrapper;
    }

    static boolean isControlChar(char c) {
        return (c <= '\u001f' || c == '\u007f') && !Character.isSurrogate(c);
    }

    static boolean isControlChar(int n) {
        return n <= 31 || n == 127;
    }

    static boolean isValidCodePoint(int n) {
        return n <= 55295 || n >= 57344 && n <= 0x10FFFF;
    }

    static boolean isValidInBareKey(char c, boolean bl) {
        if (bl) {
            return c > ' ' && !Utils.arrayContains(FORBIDDEN_IN_ALL_BARE_KEYS, c) && !Toml.isControlChar(c);
        }
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '-' || c == '_';
    }

    static boolean isValidBareKey(CharSequence charSequence, boolean bl) {
        int n = charSequence.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Toml.isValidInBareKey(charSequence.charAt(i), bl)) continue;
            return false;
        }
        return true;
    }

    static boolean isKeyValueSeparator(char c, boolean bl) {
        return c == '=' || bl && c == ':';
    }

    private Toml() {
    }
}

