/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.toml;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.CommentedConfig;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.Config;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.ConfigFormat;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.CharacterInput;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.CharsWrapper;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.ConfigParser;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.ParsingException;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.ParsingMode;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.ReaderInput;
import me.roundaround.pickupnotifications.roundalib.nightconfig.toml.TableParser;
import me.roundaround.pickupnotifications.roundalib.nightconfig.toml.TomlFormat;

public final class TomlParser
implements ConfigParser<CommentedConfig> {
    private int initialStringBuilderCapacity = 16;
    private int initialListCapacity = 10;
    private boolean lenientBareKeys = false;
    private boolean lenientSeparators = false;
    private boolean configWasEmpty = false;
    private ParsingMode parsingMode;
    private final Set<Config> inlineTables = Collections.newSetFromMap(new IdentityHashMap());
    private String currentComment;

    void registerInlineTable(Config config) {
        this.inlineTables.add(config);
    }

    boolean isInlineTable(Config config) {
        return this.inlineTables.contains(config);
    }

    private void clearParsingState() {
        this.inlineTables.clear();
    }

    @Override
    public CommentedConfig parse(Reader reader) {
        this.configWasEmpty = true;
        return this.parse(new ReaderInput(reader), (CommentedConfig)TomlFormat.instance().createConfig(), ParsingMode.MERGE);
    }

    @Override
    public void parse(Reader reader, Config config, ParsingMode parsingMode) {
        if (parsingMode == ParsingMode.REPLACE) {
            this.configWasEmpty = true;
        }
        this.parse(new ReaderInput(reader), config, parsingMode);
    }

    private <T extends Config> T parse(CharacterInput characterInput, T t, ParsingMode parsingMode) {
        int n;
        this.parsingMode = parsingMode;
        parsingMode.prepareParsing(t);
        CommentedConfig commentedConfig = CommentedConfig.fake(t);
        CommentedConfig commentedConfig2 = TableParser.parseNormal(characterInput, this, commentedConfig);
        while ((n = characterInput.peek()) != -1) {
            Object object;
            Object object2;
            Object object3;
            boolean bl;
            boolean bl2 = bl = n == 91;
            if (bl) {
                characterInput.skipPeeks();
            }
            List<String> list = TableParser.parseTableName(characterInput, this, bl);
            int n2 = list.size() - 1;
            List<String> list2 = list.subList(0, n2);
            List<String> list3 = Collections.singletonList(list.get(n2));
            Config config = this.getSubTable(commentedConfig2, list2);
            if (this.hasPendingComment()) {
                object3 = this.consumeComment();
                if (config instanceof CommentedConfig) {
                    ((CommentedConfig)config).setComment(list3, (String)object3);
                }
            }
            if (bl) {
                if (config == null) {
                    throw new ParsingException("Cannot create entry " + String.valueOf(list) + " because of an invalid parent that isn't a table.");
                }
                object3 = TableParser.parseNormal(commentedConfig, characterInput, this);
                object2 = config.get(list3);
                if (object2 instanceof List) {
                    object = (List<T>)object2;
                    object.add(object3);
                    continue;
                }
                if (object2 == null) {
                    object = this.createList();
                    object.add(object3);
                    parsingMode.put(config, list3, object);
                    continue;
                }
                throw new ParsingException("Cannot create entry " + String.valueOf(list) + " because of an invalid parent that is not an array of tables");
            }
            if (config == null) {
                throw new ParsingException("Cannot create entry " + String.valueOf(list) + " because of an invalid parent that isn't a table.");
            }
            object3 = config.get(list3);
            if (object3 == null) {
                object2 = TableParser.parseNormal(commentedConfig, characterInput, this);
                parsingMode.put(config, list3, object2);
                continue;
            }
            if (object3 instanceof Config) {
                object2 = (Config)object3;
                this.checkContainsOnlySubtables((Config)object2, list);
                object = CommentedConfig.fake(object2);
                TableParser.parseNormal(characterInput, this, object);
                continue;
            }
            if (!this.configWasEmpty) continue;
            throw new ParsingException("Entry " + String.valueOf(list) + " has been defined twice.");
        }
        this.clearParsingState();
        return t;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Config getSubTable(Config config, List<String> list) {
        if (list.isEmpty()) {
            return config;
        }
        Config config2 = config;
        for (String string : list) {
            List<String> list2 = Collections.singletonList(string);
            Object t = config2.get(list2);
            if (t == null) {
                var8_8 = config.createSubConfig();
                config2.set(list2, var8_8);
                config2 = var8_8;
            } else if (t instanceof Config) {
                config2 = (Config)t;
            } else {
                if (!(t instanceof List)) return null;
                var8_8 = (List)t;
                if (var8_8.isEmpty()) return null;
                if (!var8_8.stream().allMatch(Config.class::isInstance)) return null;
                int n = var8_8.size() - 1;
                config2 = (Config)var8_8.get(n);
            }
            if (!this.isInlineTable(config2)) continue;
            throw new ParsingException("Cannot modify an inline table after its creation. Key path: " + String.valueOf(list));
        }
        return config2;
    }

    private void checkContainsOnlySubtables(Config config, List<String> list) {
        for (Config.Entry entry : config.entrySet()) {
            Object t = entry.getValue();
            if (t instanceof Config || t instanceof List && !((List)t).isEmpty() && ((List)t).get(0) instanceof Config) continue;
            throw new ParsingException("Table with path " + String.valueOf(list) + " has been declared twice.");
        }
    }

    public boolean isLenientWithSeparators() {
        return this.lenientSeparators;
    }

    public TomlParser setLenientWithSeparators(boolean bl) {
        this.lenientSeparators = bl;
        return this;
    }

    public boolean isLenientWithBareKeys() {
        return this.lenientBareKeys;
    }

    public TomlParser setLenientWithBareKeys(boolean bl) {
        this.lenientBareKeys = bl;
        return this;
    }

    public TomlParser setInitialStringBuilderCapacity(int n) {
        this.initialStringBuilderCapacity = n;
        return this;
    }

    public TomlParser setInitialListCapacity(int n) {
        this.initialListCapacity = n;
        return this;
    }

    @Override
    public ConfigFormat<CommentedConfig> getFormat() {
        return TomlFormat.instance();
    }

    boolean configWasEmpty() {
        return this.configWasEmpty;
    }

    ParsingMode getParsingMode() {
        return this.parsingMode;
    }

    <T> List<T> createList() {
        return new ArrayList(this.initialListCapacity);
    }

    CharsWrapper.Builder createBuilder() {
        return new CharsWrapper.Builder(this.initialStringBuilderCapacity);
    }

    boolean hasPendingComment() {
        return this.currentComment != null;
    }

    String consumeComment() {
        String string = this.currentComment;
        this.currentComment = null;
        return string;
    }

    void setComment(CharsWrapper charsWrapper) {
        if (charsWrapper != null) {
            String string = charsWrapper.toString();
            string.codePoints().forEach(n -> {
                if (n == 9 || n == 10) {
                    return;
                }
                if (n <= 31 || n == 127) {
                    throw new ParsingException("Invalid control character in comment: " + string);
                }
                if (n > 55295 && n < 57344) {
                    throw new ParsingException("Invalid unicode codepoint in comment: " + string);
                }
            });
            this.currentComment = this.currentComment == null ? string : this.currentComment + "\n" + string;
        }
    }

    void setComment(List<CharsWrapper> list) {
        CharsWrapper.Builder builder = new CharsWrapper.Builder(32);
        if (!list.isEmpty()) {
            Iterator<CharsWrapper> iterator = list.iterator();
            builder.append(iterator.next());
            while (iterator.hasNext()) {
                builder.append('\n');
                builder.append(iterator.next());
            }
            this.setComment(builder.build());
        }
    }
}

