/*
 * Decompiled with CFR 0.152.
 */
package me.roundaround.pickupnotifications.roundalib.nightconfig.toml;

import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.UnmodifiableConfig;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.CharacterOutput;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.ConfigWriter;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.IndentStyle;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.NewlineStyle;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.io.WriterOutput;
import me.roundaround.pickupnotifications.roundalib.nightconfig.core.utils.StringUtils;
import me.roundaround.pickupnotifications.roundalib.nightconfig.toml.StringWriter;
import me.roundaround.pickupnotifications.roundalib.nightconfig.toml.TableWriter;
import me.roundaround.pickupnotifications.roundalib.nightconfig.toml.Toml;

public final class TomlWriter
implements ConfigWriter {
    private boolean lenientBareKeys = false;
    private Predicate<UnmodifiableConfig> writeTableInlinePredicate = UnmodifiableConfig::isEmpty;
    private Predicate<String> writeStringLiteralPredicate = string -> false;
    private Predicate<String> writeStringMultilinePredicate = string -> {
        int n = string.indexOf(10);
        int n2 = string.indexOf(10, n + 1);
        int n3 = string.indexOf(10, n2 + 1);
        int n4 = string.indexOf(13);
        return n4 == -1 && (n >= 0 && n2 > 0 && n3 > 0 || n > 0 && n < string.length() - 1);
    };
    private Predicate<List<?>> indentArrayElementsPredicate = list -> false;
    private char[] indent;
    private char[] newline;
    private boolean hideRedundantLevels;
    private int currentIndentLevel;

    public TomlWriter() {
        this.indent = IndentStyle.TABS.chars;
        this.newline = NewlineStyle.system().chars;
        this.hideRedundantLevels = true;
    }

    @Override
    public void write(UnmodifiableConfig unmodifiableConfig, Writer writer) {
        this.currentIndentLevel = -1;
        WriterOutput writerOutput = new WriterOutput(writer);
        TableWriter.writeTopLevel(unmodifiableConfig, new ArrayList<String>(), writerOutput, this);
    }

    public boolean isHidingRedundantLevels() {
        return this.hideRedundantLevels;
    }

    public void setHideRedundantLevels(boolean bl) {
        this.hideRedundantLevels = bl;
    }

    public boolean isOmitIntermediateLevels() {
        return this.hideRedundantLevels;
    }

    public void setOmitIntermediateLevels(boolean bl) {
        this.setHideRedundantLevels(bl);
    }

    public boolean isLenientWithBareKeys() {
        return this.lenientBareKeys;
    }

    public void setLenientWithBareKeys(boolean bl) {
        this.lenientBareKeys = bl;
    }

    public void setWriteTableInlinePredicate(Predicate<UnmodifiableConfig> predicate) {
        this.writeTableInlinePredicate = predicate;
    }

    public void setWriteStringLiteralPredicate(Predicate<String> predicate) {
        this.writeStringLiteralPredicate = predicate;
    }

    public void setWriteStringMultilinePredicate(Predicate<String> predicate) {
        this.writeStringMultilinePredicate = predicate;
    }

    public void setIndentArrayElementsPredicate(Predicate<List<?>> predicate) {
        this.indentArrayElementsPredicate = predicate;
    }

    public void setIndent(IndentStyle indentStyle) {
        this.indent = indentStyle.chars;
    }

    public void setIndent(String string) {
        this.indent = string.toCharArray();
    }

    public void setNewline(NewlineStyle newlineStyle) {
        this.newline = newlineStyle.chars;
    }

    public void setNewline(String string) {
        this.newline = string.toCharArray();
    }

    void increaseIndentLevel() {
        ++this.currentIndentLevel;
    }

    void decreaseIndentLevel() {
        --this.currentIndentLevel;
    }

    void writeIndent(CharacterOutput characterOutput) {
        for (int i = 0; i < this.currentIndentLevel; ++i) {
            characterOutput.write(this.indent);
        }
    }

    void writeNewline(CharacterOutput characterOutput) {
        characterOutput.write(this.newline);
    }

    void writeIndentedComment(String string, CharacterOutput characterOutput) {
        List<String> list = StringUtils.splitLines(string);
        for (String string2 : list) {
            this.writeIndent(characterOutput);
            characterOutput.write('#');
            characterOutput.write(string2);
            characterOutput.write(this.newline);
        }
    }

    void writeIndentedKey(String string, CharacterOutput characterOutput) {
        this.writeIndent(characterOutput);
        this.writeKey(string, characterOutput);
    }

    void writeKey(String string, CharacterOutput characterOutput) {
        if (Toml.isValidBareKey(string, this.lenientBareKeys)) {
            characterOutput.write(string);
        } else if (this.writeStringLiteralPredicate.test(string)) {
            StringWriter.writeLiteral(string, characterOutput);
        } else {
            StringWriter.writeBasic(string, characterOutput);
        }
    }

    boolean writesInline(UnmodifiableConfig unmodifiableConfig) {
        return this.writeTableInlinePredicate.test(unmodifiableConfig);
    }

    boolean writesLiteral(String string) {
        return this.writeStringLiteralPredicate.test(string);
    }

    boolean writesMultiline(String string) {
        return this.writeStringMultilinePredicate.test(string);
    }

    boolean writesIndented(List<?> list) {
        return this.indentArrayElementsPredicate.test(list);
    }
}

