/*
 * Decompiled with CFR 0.152.
 */
package com.github.hardcoredeath;

import com.github.hardcoredeath.DeathListener;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class HardcoreDeath
extends JavaPlugin {
    private List<String> enabledWorlds;

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadSettings();
        this.getServer().getPluginManager().registerEvents((Listener)new DeathListener(this), (Plugin)this);
        if (this.enabledWorlds == null || this.enabledWorlds.isEmpty()) {
            this.getLogger().info("HardcoreDeath enabled (no worlds configured)");
        } else {
            this.getLogger().info("HardcoreDeath enabled \u2014 active in worlds: " + String.join((CharSequence)", ", this.enabledWorlds));
        }
    }

    public void onDisable() {
        this.getLogger().info("HardcoreDeath disabled");
    }

    public void reloadSettings() {
        FileConfiguration cfg = this.getConfig();
        this.enabledWorlds = cfg.getStringList("enabled-worlds");
    }

    public boolean isWorldEnabled(String worldName) {
        if (this.enabledWorlds == null) {
            return false;
        }
        return this.enabledWorlds.contains(worldName);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("hardcoredeath")) {
            if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("hardcoredeath.reload") && !sender.hasPermission("hardcoredeath.use")) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to do that.");
                    return true;
                }
                this.reloadConfig();
                this.reloadSettings();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "HardcoreDeath config reloaded.");
                return true;
            }
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "HardcoreDeath commands:");
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + "/hardcoredeath reload" + String.valueOf(ChatColor.WHITE) + " - Reload the config");
            return true;
        }
        return false;
    }
}

