/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.simple_modpack_money;

import com.lithiumcraft.simple_modpack_money.Config;
import com.lithiumcraft.simple_modpack_money.client.ModMenus;
import com.lithiumcraft.simple_modpack_money.item.ModCreativeModeTabs;
import com.lithiumcraft.simple_modpack_money.item.ModItems;
import com.lithiumcraft.simple_modpack_money.network.ModVariables;
import com.lithiumcraft.simple_modpack_money.registry.ModDataComponents;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadHandler;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;

@Mod(value="simple_modpack_money")
public class SimpleModpackMoney {
    public static final String MOD_ID = "simple_modpack_money";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static boolean networkingRegistered = false;
    private static final Map<CustomPacketPayload.Type<? extends CustomPacketPayload>, NetworkMessage<? extends CustomPacketPayload>> MESSAGES = new HashMap<CustomPacketPayload.Type<? extends CustomPacketPayload>, NetworkMessage<? extends CustomPacketPayload>>();
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public SimpleModpackMoney(IEventBus modEventBus, ModContainer modContainer) {
        NeoForge.EVENT_BUS.register((Object)this);
        modEventBus.addListener(this::registerNetworking);
        ModItems.register(modEventBus);
        ModVariables.ATTACHMENT_TYPES.register(modEventBus);
        ModMenus.REGISTRY.register(modEventBus);
        ModDataComponents.DATA_COMPONENT_TYPES.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        modEventBus.addListener(Config::onLoad);
    }

    public static <T extends CustomPacketPayload> void addNetworkMessage(CustomPacketPayload.Type<T> id, StreamCodec<RegistryFriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
        if (networkingRegistered) {
            throw new IllegalStateException("Cannot register new network messages after networking has been registered");
        }
        MESSAGES.put(id, new NetworkMessage<T>(reader, handler));
    }

    private void registerNetworking(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MOD_ID);
        MESSAGES.forEach((id, networkMessage) -> SimpleModpackMoney.registerMessage(registrar, id, networkMessage));
        networkingRegistered = true;
    }

    private static <T extends CustomPacketPayload> void registerMessage(PayloadRegistrar registrar, CustomPacketPayload.Type<?> rawId, NetworkMessage<?> rawMessage) {
        CustomPacketPayload.Type<?> id = rawId;
        NetworkMessage<?> message = rawMessage;
        registrar.playBidirectional(id, message.reader(), message.handler());
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }

    public static ResourceLocation getRL(String regName) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)regName);
    }

    private record NetworkMessage<T extends CustomPacketPayload>(StreamCodec<RegistryFriendlyByteBuf, T> reader, IPayloadHandler<T> handler) {
    }
}

