/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.simple_modpack_money.datagen;

import com.lithiumcraft.simple_modpack_money.SimpleModpackMoney;
import com.lithiumcraft.simple_modpack_money.datagen.conditions.AllowCoinBaseCraftingCondition;
import com.lithiumcraft.simple_modpack_money.datagen.conditions.AllowCoinDowngradeCondition;
import com.lithiumcraft.simple_modpack_money.datagen.conditions.AllowCoinUpgradeCondition;
import com.lithiumcraft.simple_modpack_money.item.ModItems;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    public ModRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        this.coinUpgrade((Item)ModItems.COPPER_COIN.get(), (Item)ModItems.IRON_COIN.get(), recipeOutput);
        this.coinUpgrade((Item)ModItems.IRON_COIN.get(), (Item)ModItems.GOLD_COIN.get(), recipeOutput);
        this.coinUpgrade((Item)ModItems.GOLD_COIN.get(), (Item)ModItems.DIAMOND_COIN.get(), recipeOutput);
        this.coinUpgrade((Item)ModItems.DIAMOND_COIN.get(), (Item)ModItems.NETHERITE_COIN.get(), recipeOutput);
        this.coinUpgrade((Item)ModItems.NETHERITE_COIN.get(), (Item)ModItems.NETHER_STAR_COIN.get(), recipeOutput);
        this.coinDowngrade((Item)ModItems.NETHER_STAR_COIN.get(), (Item)ModItems.NETHERITE_COIN.get(), recipeOutput);
        this.coinDowngrade((Item)ModItems.NETHERITE_COIN.get(), (Item)ModItems.DIAMOND_COIN.get(), recipeOutput);
        this.coinDowngrade((Item)ModItems.DIAMOND_COIN.get(), (Item)ModItems.GOLD_COIN.get(), recipeOutput);
        this.coinDowngrade((Item)ModItems.GOLD_COIN.get(), (Item)ModItems.IRON_COIN.get(), recipeOutput);
        this.coinDowngrade((Item)ModItems.IRON_COIN.get(), (Item)ModItems.COPPER_COIN.get(), recipeOutput);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModItems.COIN_BASE, (int)1).define(Character.valueOf('B'), (ItemLike)Items.IRON_BLOCK).define(Character.valueOf('I'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('N'), (ItemLike)Items.IRON_NUGGET).pattern("NIN").pattern("IBI").pattern("NIN").unlockedBy("has_iron_block", ModRecipeProvider.has((ItemLike)Items.IRON_BLOCK)).save(ModRecipeProvider.withConditions(recipeOutput, new AllowCoinBaseCraftingCondition()), SimpleModpackMoney.getRL("coins/coin_base"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModItems.BRIEFCASE, (int)1).define(Character.valueOf('B'), (ItemLike)Items.IRON_BLOCK).define(Character.valueOf('T'), (ItemLike)Items.TRIPWIRE_HOOK).define(Character.valueOf('X'), ModItems.IRON_COIN).pattern(" T ").pattern("BXB").pattern("BBB").unlockedBy("has_iron_coin", ModRecipeProvider.has(ModItems.IRON_COIN)).save(recipeOutput, SimpleModpackMoney.getRL("coins/briefcase"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, ModItems.COPPER_COIN, (int)1).define(Character.valueOf('E'), (ItemLike)Items.DRAGON_EGG).define(Character.valueOf('S'), (ItemLike)Items.NETHER_STAR).define(Character.valueOf('H'), (ItemLike)Items.DRAGON_HEAD).define(Character.valueOf('B'), (ItemLike)Items.DRAGON_BREATH).define(Character.valueOf('C'), ModItems.COIN_BASE).pattern("ESB").pattern("HCH").pattern("BSE").unlockedBy("has_dragon_egg", ModRecipeProvider.has((ItemLike)Items.DRAGON_EGG)).save(ModRecipeProvider.withConditions(recipeOutput, new AllowCoinBaseCraftingCondition()), SimpleModpackMoney.getRL("coins/copper_coin_lol"));
    }

    protected void coinUpgrade(Item input, Item output, RecipeOutput recipeOutput) {
        ResourceLocation inputId = BuiltInRegistries.ITEM.getKey((Object)input);
        ResourceLocation outputId = BuiltInRegistries.ITEM.getKey((Object)output);
        String inputName = inputId.getPath();
        String outputName = outputId.getPath();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)1).define(Character.valueOf('X'), (ItemLike)input).pattern("XXX").pattern("XX ").pattern("   ").unlockedBy("has_" + inputName, ModRecipeProvider.has((ItemLike)input)).save(ModRecipeProvider.withConditions(recipeOutput, new AllowCoinUpgradeCondition()), SimpleModpackMoney.getRL("coins/" + outputName + "_from_5x_" + inputName + "s"));
    }

    protected void coinDowngrade(Item input, Item output, RecipeOutput recipeOutput) {
        ResourceLocation inputId = BuiltInRegistries.ITEM.getKey((Object)input);
        ResourceLocation outputId = BuiltInRegistries.ITEM.getKey((Object)output);
        String inputName = inputId.getPath();
        String outputName = outputId.getPath();
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (int)5).requires((ItemLike)input).unlockedBy("has_" + inputName, ModRecipeProvider.has((ItemLike)input)).save(ModRecipeProvider.withConditions(recipeOutput, new AllowCoinDowngradeCondition()), SimpleModpackMoney.getRL("coins/5x_" + outputName + "_from_" + inputName));
    }

    private static RecipeOutput withConditions(final RecipeOutput parent, final ICondition ... conditions) {
        return new RecipeOutput(){

            public void accept(ResourceLocation id, Recipe<?> recipe, @Nullable AdvancementHolder advancement, ICondition ... ignored) {
                parent.accept(id, recipe, advancement, conditions);
            }

            public Advancement.Builder advancement() {
                return parent.advancement();
            }
        };
    }
}

