/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.simple_modpack_money.event;

import com.lithiumcraft.simple_modpack_money.item.BriefcaseItem;
import com.lithiumcraft.simple_modpack_money.registry.ModDataComponents;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.item.ItemExpireEvent;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;

@EventBusSubscriber
public class BriefcaseItemHandler {
    @SubscribeEvent
    public static void onItemExpire(ItemExpireEvent event) {
        ItemEntity entity = event.getEntity();
        ItemStack stack = entity.getItem();
        if (stack.getItem() instanceof BriefcaseItem) {
            entity.setUnlimitedLifetime();
            event.setExtraLife(6000);
        }
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        ItemEntity entity = event.getEntity();
        ItemStack stack = entity.getItem();
        if (stack.getItem() instanceof BriefcaseItem) {
            entity.setInvulnerable(true);
            entity.setUnlimitedLifetime();
        }
    }

    public static void checkVoidRescue(ItemEntity entity) {
        Level level;
        ItemStack stack = entity.getItem();
        if (!(stack.getItem() instanceof BriefcaseItem)) {
            return;
        }
        if (entity.getY() < (double)entity.level().getMinBuildHeight() && (level = entity.level()) instanceof ServerLevel) {
            ServerPlayer owner;
            ServerLevel serverLevel = (ServerLevel)level;
            UUID ownerId = (UUID)stack.get((DataComponentType)ModDataComponents.BRIEFCASE_OWNER.get());
            if (ownerId != null && (owner = serverLevel.getServer().getPlayerList().getPlayer(ownerId)) != null && owner.isAlive()) {
                owner.drop(stack.copy(), false);
                entity.discard();
                return;
            }
            BlockPos spawn = serverLevel.getSharedSpawnPos();
            ItemEntity safeDrop = new ItemEntity((Level)serverLevel, (double)spawn.getX() + 0.5, (double)spawn.getY() + 1.5, (double)spawn.getZ() + 0.5, stack.copy());
            safeDrop.setInvulnerable(true);
            safeDrop.setUnlimitedLifetime();
            serverLevel.addFreshEntity((Entity)safeDrop);
            entity.discard();
        }
    }
}

