/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.simple_modpack_money.item;

import com.lithiumcraft.simple_modpack_money.item.coins.CoinItem;
import com.lithiumcraft.simple_modpack_money.registry.ModDataComponents;
import com.lithiumcraft.simple_modpack_money.world.inventory.BriefcaseGUIMenu;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class BriefcaseItem
extends Item {
    public BriefcaseItem(Item.Properties properties) {
        super(properties.rarity(Rarity.UNCOMMON).stacksTo(1).fireResistant());
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, final InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide && player instanceof ServerPlayer) {
            ServerPlayer sp;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            UUID owner = (UUID)stack.get((DataComponentType)ModDataComponents.BRIEFCASE_OWNER.get());
            if (owner == null) {
                stack.set((DataComponentType)ModDataComponents.BRIEFCASE_OWNER.get(), (Object)player.getUUID());
                stack.set((DataComponentType)ModDataComponents.BRIEFCASE_OWNER_NAME.get(), (Object)player.getName().getString());
                owner = player.getUUID();
                player.displayClientMessage((Component)Component.translatable((String)"message.simple_modpack_money.briefcase.owner_set").withStyle(ChatFormatting.GREEN), true);
            }
            if (!(player.getUUID().equals(owner) || player instanceof ServerPlayer && (sp = (ServerPlayer)player).hasPermissions(2) || player.isCreative())) {
                player.displayClientMessage((Component)Component.translatable((String)"message.simple_modpack_money.briefcase.not_owner").withStyle(ChatFormatting.RED), true);
                return InteractionResultHolder.fail((Object)stack);
            }
            serverPlayer.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.translatable((String)"gui.simple_modpack_money.briefcase.title");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                    buf.writeVarInt(hand == InteractionHand.MAIN_HAND ? 0 : 1);
                    return new BriefcaseGUIMenu(id, inventory, buf);
                }
            });
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide());
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        return stack.copy();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        String ownerName;
        IItemHandler handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (handler != null) {
            long totalValue = 0L;
            for (int i = 0; i < handler.getSlots(); ++i) {
                Item item;
                ItemStack coin = handler.getStackInSlot(i);
                if (coin.isEmpty() || !((item = coin.getItem()) instanceof CoinItem)) continue;
                CoinItem coinItem = (CoinItem)item;
                totalValue += (long)coin.getCount() * (long)coinItem.getCoinValue();
            }
            tooltip.add((Component)Component.translatable((String)"tooltip.simple_modpack_money.briefcase.value", (Object[])new Object[]{totalValue}).withStyle(ChatFormatting.ITALIC).withStyle(ChatFormatting.GOLD));
        }
        if ((ownerName = (String)stack.get((DataComponentType)ModDataComponents.BRIEFCASE_OWNER_NAME.get())) != null && !ownerName.isEmpty()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.simple_modpack_money.briefcase.owner", (Object[])new Object[]{ownerName}).withStyle(ChatFormatting.GRAY));
        }
    }
}

