/*
 * Decompiled with CFR 0.152.
 */
package com.lithiumcraft.simple_modpack_money.world.inventory;

import com.lithiumcraft.simple_modpack_money.client.ModMenus;
import com.lithiumcraft.simple_modpack_money.util.CoinSlot;
import com.lithiumcraft.simple_modpack_money.util.ModTags;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class BriefcaseGUIMenu
extends AbstractContainerMenu {
    private final IItemHandler internal;

    public BriefcaseGUIMenu(int id, Inventory inv, FriendlyByteBuf buf) {
        super((MenuType)ModMenus.BRIEFCASE_GUI.get(), id);
        int col;
        int row;
        Player player = inv.player;
        int handIndex = buf != null && buf.readableBytes() >= 1 ? buf.readVarInt() : 0;
        ItemStack stack = handIndex == 0 ? player.getMainHandItem() : player.getOffhandItem();
        IItemHandler cap = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (cap == null) {
            throw new IllegalStateException("Briefcase item missing ItemHandler capability!");
        }
        this.internal = cap;
        for (row = 0; row < 2; ++row) {
            for (col = 0; col < 9; ++col) {
                int index = row * 9 + col;
                this.addSlot((Slot)new CoinSlot(this.internal, index, 7 + col * 18, 22 + row * 18));
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.addSlot(new Slot((Container)inv, col + row * 9 + 9, 8 + col * 18, 84 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.addSlot(new Slot((Container)inv, col2, 8 + col2 * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack stackInSlot = slot.getItem();
        ItemStack original = stackInSlot.copy();
        int containerSlots = this.internal.getSlots();
        if (index < containerSlots) {
            ItemStack extracted = this.internal.extractItem(index, stackInSlot.getCount(), false);
            if (!this.moveItemStackTo(extracted, containerSlots, this.slots.size(), true)) {
                return ItemStack.EMPTY;
            }
        } else if (stackInSlot.is(ModTags.Items.COINS)) {
            ItemStack copy = stackInSlot.copy();
            ItemStack remainder = ItemHandlerHelper.insertItemStacked((IItemHandler)this.internal, (ItemStack)copy, (boolean)false);
            if (remainder.getCount() == stackInSlot.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.set(remainder);
        } else {
            return ItemStack.EMPTY;
        }
        if (stackInSlot.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        slot.onTake(player, stackInSlot);
        return original;
    }
}

