/*
 * Decompiled with CFR 0.152.
 */
package wtf.blexyel.simplehud;

import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.Mth;
import wtf.blexyel.simplehud.Config;
import wtf.blexyel.simplehud.GuiHelper;
import wtf.blexyel.simplehud.Utils;

public class Renderstuff {
    public void getEntry(GuiGraphics context, Minecraft client) {
        int y;
        HashSet unique;
        boolean rfps = Config.fps;
        boolean rcoords = Config.coords;
        boolean rchunk = Config.chunk;
        boolean rping = Config.ping;
        boolean rconn = Config.conn;
        boolean rbiome = Config.biome;
        int fps = client.getFps();
        String fpsColor = Config.fpscolor ? (fps <= 30 ? "\u00a7c" : (fps < 60 ? "\u00a7e" : "\u00a7a")) : "";
        String fpsString = "FPS: " + fpsColor + fps;
        String coordsx = String.valueOf((int)client.player.getX());
        String coordsy = String.valueOf((int)client.player.getY());
        String coordsz = String.valueOf((int)client.player.getZ());
        String coords = String.format(Config.coordscolor ? "XYZ: \u00a7c%s \u00a7a%s \u00a79%s" : "XYZ: %s %s %s", coordsx, coordsy, coordsz);
        String chunkcoordsx = String.valueOf(client.player.chunkPosition().x);
        String chunkcoordsz = String.valueOf(client.player.chunkPosition().z);
        String chunkcoords = String.format(Config.chunkcolor ? "Chunk: \u00a7c%s \u00a79%s" : "Chunk: %s %s", chunkcoordsx, chunkcoordsz);
        int ping = Utils.getPing(client);
        String pingColor = Config.pingcolor ? (ping > 300 ? "\u00a74" : (ping > 150 ? "\u00a7c" : (ping > 80 ? "\u00a7e" : "\u00a7a"))) : "";
        String pingString = "Ping: " + pingColor + ping;
        String conn = Utils.getConnectionInfo(client);
        String biome = Utils.getBiome(client);
        int baseY = 5;
        int spacing = 10;
        if (!(rfps || rcoords || rping || rconn || rbiome)) {
            return;
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (rfps) {
            indices.add(Config.fpsindex);
        }
        if (rcoords) {
            indices.add(Config.coordsindex);
        }
        if (rchunk) {
            indices.add(Config.chunkindex);
        }
        if (rping) {
            indices.add(Config.pingindex);
        }
        if (rconn) {
            indices.add(Config.connindex);
        }
        if (rbiome) {
            indices.add(Config.biomeindex);
        }
        if ((unique = new HashSet(indices)).size() < indices.size()) {
            this.render(context, client, "ERROR: ONE OR MULTIPLE AT SAME POSITION", baseY, -65536);
            return;
        }
        if (rfps) {
            y = baseY + spacing * Config.fpsindex;
            this.render(context, client, fpsString, y, -1);
        }
        if (rcoords) {
            y = baseY + spacing * Config.coordsindex;
            this.render(context, client, coords, y, -1);
        }
        if (rcoords) {
            y = baseY + spacing * Config.coordsindex;
            this.render(context, client, coords, y, -1);
        }
        if (rchunk) {
            y = baseY + spacing * Config.chunkindex;
            this.render(context, client, chunkcoords, y, -1);
        }
        if (rping) {
            y = baseY + spacing * Config.pingindex;
            this.render(context, client, pingString, y, -1);
        }
        if (rconn) {
            y = baseY + spacing * Config.connindex;
            this.render(context, client, "IP: " + conn, y, -1);
        }
        if (rbiome) {
            y = baseY + spacing * Config.biomeindex;
            this.render(context, client, "Biome: " + biome, y, -1);
        }
    }

    public void render(GuiGraphics context, Minecraft client, String text, int y, int color) {
        int sliderValue = Config.horizontalpos;
        sliderValue = Mth.clamp((int)sliderValue, (int)0, (int)100);
        int scaledWidth = client.getWindow().getGuiScaledWidth();
        int textWidth = client.font.width(text);
        int leftBound = 5;
        int rightBound = scaledWidth - textWidth - 5;
        int pos = leftBound + (rightBound - leftBound) * sliderValue / 100;
        GuiHelper.drawString(context, client.font, text, pos, y, color, true);
    }
}

