/*
 * Decompiled with CFR 0.152.
 */
package wtf.blexyel.simplehud;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;

public class Utils {
    private static long lastPing = System.currentTimeMillis();
    private static int PING = 0;

    public static int getPing(Minecraft client) {
        if (System.currentTimeMillis() - lastPing > 2000L) {
            lastPing = System.currentTimeMillis();
            PING = Utils.ping(client);
        }
        return PING;
    }

    public static String getConnectionInfo(Minecraft client) {
        if (client != null && client.player != null) {
            String conn;
            String string = conn = client.getCurrentServer() != null ? client.getCurrentServer().ip : "idk???";
            if (client.isLocalServer()) {
                return "Singleplayer";
            }
            return conn;
        }
        return "Unknown";
    }

    public static String getBiome(Minecraft client) {
        if (client.level != null) {
            assert (client.getCameraEntity() != null);
            BlockPos blockPos = client.getCameraEntity().getOnPos();
            return String.format(client.level.getBiome(blockPos).getRegisteredName(), new Object[0]);
        }
        return "Unknown";
    }

    public static float getTPS(Minecraft client) {
        if (client != null && client.level != null) {
            float time = System.currentTimeMillis();
            return Mth.clamp((float)0.0f, (float)0.0f, (float)1000.0f);
        }
        return 0.0f;
    }

    public static String getFacingDirection(Minecraft client) {
        if (client != null && client.player != null) {
            return client.player.getDirection().toString();
        }
        return "Unknown";
    }

    private static int ping(Minecraft client) {
        PlayerInfo e;
        int ping = 0;
        if (client != null && client.player != null && (e = client.player.connection.getPlayerInfo(client.player.getUUID())) != null) {
            ping = e.getLatency();
        }
        return ping;
    }
}

