/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Weapon;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.rk.overpoweredmastery.ClientConfig;
import net.rk.overpoweredmastery.Config;
import net.rk.overpoweredmastery.block.OMBlocks;
import net.rk.overpoweredmastery.datagen.OMEnchantments;
import net.rk.overpoweredmastery.entity.OMEntityTypes;
import net.rk.overpoweredmastery.entity.blockentity.OMBlockEntities;
import net.rk.overpoweredmastery.item.OMItems;
import net.rk.overpoweredmastery.resource.OMSoundEvents;
import org.slf4j.Logger;

@Mod(value="overpoweredmastery")
public class OverpoweredMastery {
    public static final String MODID = "overpoweredmastery";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"overpoweredmastery");
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"overpoweredmastery");
    private static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"overpoweredmastery");
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<Integer>> TICKS_ALLOWED_TILL_USELESS = DATA_COMPONENT_TYPES.register("ticks_allowed_till_useless", () -> DataComponentType.builder().persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT).build());
    public static final Supplier<AttachmentType<Boolean>> USING_WUB_ITEM = ATTACHMENT_TYPES.register("using_wub_item", () -> AttachmentType.builder(() -> false).serialize(Codec.BOOL.fieldOf("using_wub_item")).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> ALL_TAB = CREATIVE_MODE_TABS.register("overpoweredmastery_creative_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.overpoweredmastery")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).icon(() -> OMItems.ENDARKENED_CROSSBOW.toStack()).build());

    public OverpoweredMastery(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::onGatherData);
        ATTACHMENT_TYPES.register(modEventBus);
        DATA_COMPONENT_TYPES.register(modEventBus);
        OMSoundEvents.SOUND_EVENTS.register(modEventBus);
        OMBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        OMBlocks.BLOCKS.register(modEventBus);
        OMItems.ITEMS.register(modEventBus);
        OMEntityTypes.ENTITY_TYPES.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SPEC);
        modContainer.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.SPEC);
    }

    protected void customItems(BuildCreativeModeTabContentsEvent event) {
        ItemStack swordN = new ItemStack((ItemLike)Items.NETHERITE_SWORD);
        ItemStack bowOP = new ItemStack((ItemLike)Items.BOW);
        ItemStack signLol = new ItemStack((ItemLike)Items.OAK_SIGN);
        CreativeModeTab.ItemDisplayParameters params = event.getParameters();
        params.holders().lookup(Registries.ENCHANTMENT).ifPresent(en -> {
            DataComponentPatch opSword = DataComponentPatch.builder().set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"OP Test Sword")).set(DataComponents.TOOLTIP_STYLE, (Object)ResourceLocation.parse((String)"overpoweredmastery:om_epic")).build();
            if (en.get(Enchantments.KNOCKBACK).isPresent() && en.get(Enchantments.FIRE_ASPECT).isPresent() && en.get(Enchantments.EFFICIENCY).isPresent()) {
                swordN.enchant((Holder)en.get(Enchantments.KNOCKBACK).get(), 10);
                swordN.enchant((Holder)en.get(Enchantments.FIRE_ASPECT).get(), 10);
                swordN.enchant((Holder)en.get(Enchantments.EFFICIENCY).get(), 10);
                swordN.applyComponents(opSword);
                event.accept(swordN);
            }
        });
        params.holders().lookup(Registries.ENCHANTMENT).ifPresent(en -> {
            DataComponentPatch opBow = DataComponentPatch.builder().set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"OP Test Bow")).set(DataComponents.TOOLTIP_STYLE, (Object)ResourceLocation.parse((String)"overpoweredmastery:om_epic")).build();
            if (en.get(Enchantments.MULTISHOT).isPresent() && en.get(Enchantments.FLAME).isPresent() && en.get(Enchantments.QUICK_CHARGE).isPresent()) {
                bowOP.enchant((Holder)en.get(Enchantments.MULTISHOT).get(), 5);
                bowOP.enchant((Holder)en.get(Enchantments.FLAME).get(), 10);
                bowOP.enchant((Holder)en.get(Enchantments.QUICK_CHARGE).get(), 20);
                bowOP.applyComponents(opBow);
                event.accept(bowOP);
            }
        });
        params.holders().lookup(Registries.ENCHANTMENT).ifPresent(en -> {
            DataComponentPatch signLolC = DataComponentPatch.builder().set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"Battle Sign")).set(DataComponents.TOOLTIP_STYLE, (Object)ResourceLocation.parse((String)"overpoweredmastery:om_epic")).set(DataComponents.WEAPON, (Object)new Weapon(15, 5.0f)).build();
            if (en.get(Enchantments.SHARPNESS).isPresent() && en.get(Enchantments.FIRE_ASPECT).isPresent()) {
                signLol.enchant((Holder)en.get(Enchantments.SHARPNESS).get(), 10);
                signLol.enchant((Holder)en.get(Enchantments.FIRE_ASPECT).get(), 20);
                signLol.applyComponents(signLolC);
                event.accept(signLol);
            }
        });
        ItemStack testSpear = new ItemStack((ItemLike)OMItems.TEST_SPEAR.asItem());
        params.holders().lookup(Registries.ENCHANTMENT).ifPresent(en -> {
            DataComponentPatch testSpearLol = DataComponentPatch.builder().set(DataComponents.ITEM_NAME, (Object)Component.literal((String)"OP Testing Spear")).set(DataComponents.TOOLTIP_STYLE, (Object)ResourceLocation.parse((String)"overpoweredmastery:om_epic")).build();
            if (en.get(Enchantments.WIND_BURST).isPresent() && en.get(Enchantments.RIPTIDE).isPresent() && en.get(Enchantments.UNBREAKING).isPresent()) {
                testSpear.enchant((Holder)en.get(Enchantments.WIND_BURST).get(), 255);
                testSpear.enchant((Holder)en.get(Enchantments.RIPTIDE).get(), 255);
                testSpear.enchant((Holder)en.get(Enchantments.UNBREAKING).get(), 10);
                testSpear.applyComponents(testSpearLol);
                event.accept(testSpear);
            }
        });
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == ALL_TAB.getKey()) {
            this.customItems(event);
            event.accept(OMItems.INERT_BLUE_ESSENCE_ORE);
            event.accept(OMItems.INERT_GREEN_ESSENCE_ORE);
            event.accept(OMItems.INERT_YELLOW_ESSENCE_ORE);
            event.accept(OMItems.INERT_ORANGE_ESSENCE_ORE);
            event.accept(OMItems.INERT_RED_ESSENCE_ORE);
            event.accept(OMItems.INERT_LIGHT_ESSENCE_ORE);
            event.accept(OMItems.INERT_AURORAN_ESSENCE_ORE);
            event.accept(OMItems.INERT_DARK_ESSENCE_ORE);
            event.accept(OMItems.INERT_BLUE_ESSENCE);
            event.accept(OMItems.INERT_GREEN_ESSENCE);
            event.accept(OMItems.INERT_YELLOW_ESSENCE);
            event.accept(OMItems.INERT_ORANGE_ESSENCE);
            event.accept(OMItems.INERT_RED_ESSENCE);
            event.accept(OMItems.INERT_LIGHT_ESSENCE);
            event.accept(OMItems.INERT_AURORAN_ESSENCE);
            event.accept(OMItems.INERT_DARK_ESSENCE);
            event.accept(OMItems.STRANGE_STONE);
            event.accept(OMItems.WOODEN_TOOL_BINDING);
            event.accept(OMItems.METAL_TOOL_BINDING);
            event.accept(OMItems.DIAMOND_TOOL_BINDING);
            event.accept(OMItems.NETHERITE_TOOL_BINDING);
            event.accept(OMItems.REDSTONE_BASE_COMPONENT);
            event.accept(OMItems.AURORAN_PROCESSOR);
            event.accept(OMItems.ESSENCE_ELECTRONIC_CORE);
            event.accept(OMItems.ULTIMATE_INGOT);
            event.accept(OMItems.ULTRA_INGOT);
            event.accept(OMItems.WOODEN_SPEAR);
            event.accept(OMItems.STONE_SPEAR);
            event.accept(OMItems.GOLD_SPEAR);
            event.accept(OMItems.IRON_SPEAR);
            event.accept(OMItems.DIAMOND_SPEAR);
            event.accept(OMItems.NETHERITE_SPEAR);
            event.accept(OMItems.BONE_SWORD);
            event.accept(OMItems.ENDARKENED_CROSSBOW);
            event.accept(OMItems.PENULTIMATE_SWORD_DARK);
            event.accept(OMItems.PENULTIMATE_SWORD_LIGHT);
            event.accept(OMItems.ULTRA_SWORD);
            event.accept(OMItems.ULTIMATE_STAFF);
            event.accept(OMItems.RED_WUBS);
            event.accept(OMItems.NETHER_WUBS);
            event.accept(OMItems.CHICKEN_WUBS);
            event.accept(OMItems.GREEN_WUBS);
            event.accept(OMItems.PURPLE_WUBS);
            event.accept(OMItems.TRIAL_WUBS);
            event.accept(OMItems.OXIDIZED_TRIAl_WUBS);
            event.accept(OMItems.MOVING_PROBABLE_BLOCK_ITEM);
        }
    }

    private void onGatherData(GatherDataEvent.Client event) {
        event.createDatapackRegistryObjects(OMEnchantments.enchantmentBuilder.add(Registries.ENCHANTMENT, OMEnchantments::bootstrap));
    }
}

