/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.core.Holder;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.common.asm.enumextension.EnumProxy;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.rk.overpoweredmastery.datagen.OMTags;
import net.rk.overpoweredmastery.entity.OMEntityTypes;
import net.rk.overpoweredmastery.entity.renderer.ChickenWubEnergyBallRenderer;
import net.rk.overpoweredmastery.entity.renderer.GreenWubEnergyBallRenderer;
import net.rk.overpoweredmastery.entity.renderer.NetherWubEnergyBallRenderer;
import net.rk.overpoweredmastery.entity.renderer.PurpleWubEnergyBallRenderer;
import net.rk.overpoweredmastery.entity.renderer.RedWubEnergyBallRenderer;
import net.rk.overpoweredmastery.entity.renderer.TrialWubEnergyBallRenderer;
import net.rk.overpoweredmastery.item.OMItems;
import net.rk.overpoweredmastery.item.custom.AbstractSpear;
import net.rk.overpoweredmastery.item.custom.AbstractStaff;
import net.rk.overpoweredmastery.item.custom.AbstractWubs;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

@Mod(value="overpoweredmastery", dist={Dist.CLIENT})
@EventBusSubscriber(modid="overpoweredmastery", value={Dist.CLIENT})
public class OverpoweredMasteryClient {
    public OverpoweredMasteryClient(IEventBus eventBus, ModContainer container) {
        container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
        eventBus.addListener(this::setupClientExtensions);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
    }

    public void setupClientExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(this){

            @Nullable
            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                return (HumanoidModel.ArmPose)WubExtension.WUB.getValue();
            }

            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                if (player.getMainHandItem().is(OMTags.MUSIC_DISC_WUBS) || player.getOffhandItem().is(OMTags.MUSIC_DISC_WUBS) || player.getMainHandItem().getItem() instanceof AbstractWubs | player.getOffhandItem().getItem() instanceof AbstractWubs) {
                    if (arm == HumanoidArm.RIGHT) {
                        if (player.isUsingItem()) {
                            float f6 = (float)itemInHand.getUseDuration((LivingEntity)player) - ((float)player.getUseItemRemainingTicks() - partialTick + 2.0f);
                            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(-1.2f + Mth.sin((float)f6) * 0.5f));
                            poseStack.translate(0.5, -0.5, -1.0);
                        } else {
                            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(2.74f));
                            poseStack.translate(0.5, -0.5, -1.0);
                        }
                    } else if (arm == HumanoidArm.LEFT) {
                        if (player.isUsingItem()) {
                            float f6 = (float)itemInHand.getUseDuration((LivingEntity)player) - ((float)player.getUseItemRemainingTicks() - partialTick + 2.0f);
                            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(-1.2f + Mth.sin((float)f6) * 0.5f));
                            poseStack.translate(-0.5, -0.5, -1.0);
                        } else {
                            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(2.74f));
                            poseStack.translate(-0.5, -0.5, -1.0);
                        }
                    }
                    return true;
                }
                return super.applyForgeHandTransform(poseStack, player, arm, itemInHand, partialTick, equipProcess, swingProcess);
            }
        }, new Holder[]{OMItems.CHICKEN_WUBS, OMItems.GREEN_WUBS, OMItems.RED_WUBS, OMItems.PURPLE_WUBS, OMItems.NETHER_WUBS, OMItems.TRIAL_WUBS, OMItems.OXIDIZED_TRIAl_WUBS});
        event.registerItem(new IClientItemExtensions(this){

            @Nullable
            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                return (HumanoidModel.ArmPose)SpearExtension.SPEAR.getValue();
            }

            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                if (player.getMainHandItem().getItem() instanceof AbstractSpear | player.getOffhandItem().getItem() instanceof AbstractSpear) {
                    if (arm == HumanoidArm.RIGHT) {
                        if (player.swinging || player.swingTime > 0) {
                            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(-1.35f));
                            poseStack.translate(0.5, -0.5, -1.0);
                            return true;
                        }
                        if (player.isUsingItem()) {
                            float f6 = (float)itemInHand.getUseDuration((LivingEntity)player) - ((float)player.getUseItemRemainingTicks() - partialTick + 2.0f);
                            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(-1.2f / (float)(1 + itemInHand.getUseDuration((LivingEntity)player) - player.getUseItemRemainingTicks()) + Mth.sin((float)f6) * 0.5f));
                            poseStack.translate(0.5, -0.5, -1.0);
                        } else {
                            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(2.74f));
                            poseStack.translate(0.5, -0.5, -1.0);
                        }
                    } else if (arm == HumanoidArm.LEFT) {
                        if (player.swinging || player.swingTime > 0) {
                            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(-1.35f));
                            poseStack.translate(0.5, -0.5, -1.0);
                            return true;
                        }
                        if (player.isUsingItem()) {
                            float f6 = (float)itemInHand.getUseDuration((LivingEntity)player) - ((float)player.getUseItemRemainingTicks() - partialTick + 2.0f);
                            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(-1.2f / (float)(1 + itemInHand.getUseDuration((LivingEntity)player) - player.getUseItemRemainingTicks()) + Mth.sin((float)f6) * 0.5f));
                            poseStack.translate(-0.5, -0.5, -1.0);
                        } else {
                            poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(2.74f));
                            poseStack.translate(-0.5, -0.5, -1.0);
                        }
                    }
                    return true;
                }
                return super.applyForgeHandTransform(poseStack, player, arm, itemInHand, partialTick, equipProcess, swingProcess);
            }
        }, new Holder[]{OMItems.WOODEN_SPEAR, OMItems.STONE_SPEAR, OMItems.GOLD_SPEAR, OMItems.IRON_SPEAR, OMItems.DIAMOND_SPEAR, OMItems.NETHERITE_SPEAR});
        event.registerItem(new IClientItemExtensions(this){

            @Nullable
            public HumanoidModel.ArmPose getArmPose(LivingEntity entityLiving, InteractionHand hand, ItemStack itemStack) {
                return (HumanoidModel.ArmPose)StaffExtension.STAFF.getValue();
            }

            public boolean applyForgeHandTransform(PoseStack poseStack, LocalPlayer player, HumanoidArm arm, ItemStack itemInHand, float partialTick, float equipProcess, float swingProcess) {
                if (player.getMainHandItem().getItem() instanceof AbstractStaff | player.getOffhandItem().getItem() instanceof AbstractStaff) {
                    float f6 = (float)itemInHand.getUseDuration((LivingEntity)player) - ((float)player.getUseItemRemainingTicks() - partialTick + 2.0f);
                    if (arm == HumanoidArm.RIGHT && !player.isUsingItem()) {
                        poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(2.74f));
                        poseStack.translate(0.9, -0.5, -1.0);
                    } else if (arm == HumanoidArm.RIGHT && player.isUsingItem()) {
                        poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(55.74f));
                        poseStack.translate(0.85, 0.6, -0.9);
                        poseStack.mulPose((Quaternionfc)Axis.ZN.rotationDegrees(-1.75f / (float)(1 + itemInHand.getUseDuration((LivingEntity)player) - player.getUseItemRemainingTicks()) + Mth.sin((float)f6) * 3.95f));
                    }
                    if (arm == HumanoidArm.LEFT && !player.isUsingItem()) {
                        poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(2.74f));
                        poseStack.translate(-0.9, -0.5, -1.0);
                    } else if (arm == HumanoidArm.LEFT && player.isUsingItem()) {
                        poseStack.mulPose((Quaternionfc)Axis.XN.rotationDegrees(55.74f));
                        poseStack.translate(-0.85, 0.6, -0.9);
                        poseStack.mulPose((Quaternionfc)Axis.ZN.rotationDegrees(-1.75f / (float)(1 + itemInHand.getUseDuration((LivingEntity)player) - player.getUseItemRemainingTicks()) + Mth.sin((float)f6) * 3.95f));
                    }
                    return true;
                }
                return super.applyForgeHandTransform(poseStack, player, arm, itemInHand, partialTick, equipProcess, swingProcess);
            }
        }, new Holder[]{OMItems.ULTIMATE_STAFF});
    }

    @SubscribeEvent
    public static void setupModelLayer(EntityRenderersEvent.RegisterLayerDefinitions event) {
    }

    @SubscribeEvent
    public static void setupEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)OMEntityTypes.RED_WUB_ENERGY_BALL.get(), RedWubEnergyBallRenderer::new);
        event.registerEntityRenderer((EntityType)OMEntityTypes.GREEN_WUB_ENERGY_BALL.get(), GreenWubEnergyBallRenderer::new);
        event.registerEntityRenderer((EntityType)OMEntityTypes.PURPLE_WUB_ENERGY_BALL.get(), PurpleWubEnergyBallRenderer::new);
        event.registerEntityRenderer((EntityType)OMEntityTypes.CHICKEN_WUB_ENERGY_BALL.get(), ChickenWubEnergyBallRenderer::new);
        event.registerEntityRenderer((EntityType)OMEntityTypes.NETHER_WUB_ENERGY_BALL.get(), NetherWubEnergyBallRenderer::new);
        event.registerEntityRenderer((EntityType)OMEntityTypes.TRIAL_WUB_ENERGY_BALL.get(), TrialWubEnergyBallRenderer::new);
    }

    public final class StaffExtension {
        public static final EnumProxy<HumanoidModel.ArmPose> STAFF = new EnumProxy(HumanoidModel.ArmPose.class, new Object[]{true, StaffExtension::transformer});

        public StaffExtension(OverpoweredMasteryClient this$0) {
        }

        public static void transformer(HumanoidModel<?> humanoidModel, HumanoidRenderState humanoidRenderState, HumanoidArm humanoidArm) {
            if (humanoidRenderState.isUsingItem && humanoidRenderState.useItemHand == InteractionHand.MAIN_HAND) {
                humanoidModel.rightArm.xRot = -2.0f;
                humanoidModel.rightArm.yRot = Mth.clamp((float)(0.1f + Mth.cos((float)1.0f) * (float)humanoidRenderState.ticksUsingItem), (float)0.0f, (float)0.25f);
                if (!humanoidRenderState.isCrouching && !humanoidRenderState.isVisuallySwimming) {
                    humanoidModel.rightLeg.yRot = Mth.clamp((float)(0.5f + Mth.cos((float)1.0f) * (float)humanoidRenderState.ticksUsingItem), (float)0.0f, (float)0.25f);
                    humanoidModel.leftLeg.yRot = Mth.clamp((float)(0.5f - Mth.cos((float)1.0f) * (float)humanoidRenderState.ticksUsingItem), (float)-0.25f, (float)0.0f);
                    humanoidModel.leftLeg.zRot = Mth.clamp((float)(0.5f - Mth.cos((float)1.0f) * (float)humanoidRenderState.ticksUsingItem), (float)-0.25f, (float)0.0f);
                }
            } else if (!humanoidRenderState.isUsingItem && humanoidRenderState.useItemHand == InteractionHand.MAIN_HAND) {
                humanoidModel.rightArm.xRot = humanoidModel.leftArm.xRot * -1.0f;
            }
            if (humanoidRenderState.isUsingItem && humanoidRenderState.useItemHand == InteractionHand.OFF_HAND) {
                humanoidModel.leftArm.xRot = -2.0f;
                humanoidModel.leftArm.yRot = Mth.clamp((float)(0.1f - Mth.cos((float)1.0f) * (float)humanoidRenderState.ticksUsingItem), (float)-0.25f, (float)0.0f);
                if (!humanoidRenderState.isCrouching && !humanoidRenderState.isVisuallySwimming) {
                    humanoidModel.leftLeg.yRot = Mth.clamp((float)(0.5f - Mth.cos((float)1.0f) * (float)humanoidRenderState.ticksUsingItem), (float)-0.25f, (float)0.0f);
                    humanoidModel.rightLeg.yRot = Mth.clamp((float)(0.5f + Mth.cos((float)1.0f) * (float)humanoidRenderState.ticksUsingItem), (float)0.0f, (float)0.25f);
                    humanoidModel.rightLeg.zRot = Mth.clamp((float)(0.5f + Mth.cos((float)1.0f) * (float)humanoidRenderState.ticksUsingItem), (float)0.0f, (float)0.25f);
                }
            } else if (!humanoidRenderState.isUsingItem && humanoidRenderState.useItemHand == InteractionHand.OFF_HAND) {
                humanoidModel.leftArm.xRot = humanoidModel.rightArm.xRot * -1.0f;
            }
        }
    }

    public final class SpearExtension {
        public static final EnumProxy<HumanoidModel.ArmPose> SPEAR = new EnumProxy(HumanoidModel.ArmPose.class, new Object[]{true, SpearExtension::transformer});

        public SpearExtension(OverpoweredMasteryClient this$0) {
        }

        public static void transformer(HumanoidModel<?> humanoidModel, HumanoidRenderState humanoidRenderState, HumanoidArm humanoidArm) {
            if (humanoidRenderState.isUsingItem && humanoidRenderState.useItemHand == InteractionHand.MAIN_HAND) {
                humanoidModel.rightArm.xRot = 82.0f;
                humanoidModel.rightArm.zRot = 0.5f + Mth.sin((float)humanoidRenderState.ticksUsingItem) * 0.15f;
            } else if (humanoidRenderState.isUsingItem && humanoidRenderState.useItemHand == InteractionHand.OFF_HAND) {
                humanoidModel.leftArm.xRot = 82.0f;
                humanoidModel.leftArm.zRot = -0.5f + Mth.sin((float)humanoidRenderState.ticksUsingItem) * 0.15f;
            } else if (!humanoidRenderState.isUsingItem && humanoidRenderState.useItemHand == InteractionHand.MAIN_HAND) {
                humanoidModel.rightArm.xRot = 75.0f;
                humanoidModel.rightArm.zRot = 0.23f;
            } else if (!humanoidRenderState.isUsingItem && humanoidRenderState.useItemHand == InteractionHand.OFF_HAND) {
                humanoidModel.leftArm.xRot = 75.0f;
                humanoidModel.leftArm.zRot = -0.23f;
            }
        }
    }

    public final class WubExtension {
        public static final EnumProxy<HumanoidModel.ArmPose> WUB = new EnumProxy(HumanoidModel.ArmPose.class, new Object[]{true, WubExtension::transformer});

        public WubExtension(OverpoweredMasteryClient this$0) {
        }

        public static void transformer(HumanoidModel<?> humanoidModel, HumanoidRenderState humanoidRenderState, HumanoidArm humanoidArm) {
            if (humanoidRenderState.isUsingItem && humanoidRenderState.useItemHand == InteractionHand.MAIN_HAND) {
                humanoidModel.rightArm.xRot = 5.0f;
            } else if (humanoidRenderState.isUsingItem && humanoidRenderState.useItemHand == InteractionHand.OFF_HAND) {
                humanoidModel.leftArm.xRot = 5.0f;
            }
        }
    }
}

