/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.block;

import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Husk;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CoralBlock;
import net.minecraft.world.level.block.CoralFanBlock;
import net.minecraft.world.level.block.CoralPlantBlock;
import net.minecraft.world.level.block.CoralWallFanBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.KelpBlock;
import net.minecraft.world.level.block.KelpPlantBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RedStoneOreBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoulFireBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.TurtleEggBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.WaterlilyBlock;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.TickPriority;
import net.rk.overpoweredmastery.block.OMBlocks;
import net.rk.overpoweredmastery.datagen.OMTags;
import net.rk.overpoweredmastery.util.OPUtil;

public class MovingProbableBlock
extends Block {
    public static IntegerProperty MOVES = IntegerProperty.create((String)"moves", (int)0, (int)32);

    public MovingProbableBlock(BlockBehaviour.Properties properties) {
        super(properties.noCollission().noLootTable());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)MOVES, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{MOVES});
    }

    protected void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        level.scheduleTick(pos, (Block)this, 10, TickPriority.EXTREMELY_LOW);
    }

    protected void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState normBS = state;
        if (level.getRandom().nextInt(20) >= 18) {
            if (level.getBlockState(pos.north()).is(Blocks.AIR)) {
                level.setBlock(pos.north(), state, 3);
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                this.updateState((Level)level, normBS, pos.north());
            }
        } else if (level.getRandom().nextInt(20) == 17) {
            if (level.getBlockState(pos.east()).is(Blocks.AIR)) {
                level.setBlock(pos.east(), state, 3);
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                this.updateState((Level)level, normBS, pos.east());
            }
        } else if (level.getRandom().nextInt(20) == 16) {
            if (level.getBlockState(pos.west()).is(Blocks.AIR)) {
                level.setBlock(pos.west(), state, 3);
                level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                this.updateState((Level)level, normBS, pos.west());
            }
        } else if (level.getRandom().nextInt(20) <= 15 && level.getBlockState(pos.south()).is(Blocks.AIR)) {
            level.setBlock(pos.south(), state, 3);
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            this.updateState((Level)level, normBS, pos.south());
        }
        level.scheduleTick(pos, (Block)this, 3, TickPriority.EXTREMELY_LOW);
    }

    public void updateState(Level lvl, BlockState bs, BlockPos bp) {
        int magicNum = lvl.getRandom().nextInt(42);
        if (lvl.getRandom().nextInt(100) <= magicNum) {
            lvl.setBlock(bp, Blocks.AIR.defaultBlockState(), 3);
            lvl.playSound(null, bp, SoundEvents.CHICKEN_EGG, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.generateReward(lvl, bs, bp);
            return;
        }
        if ((Integer)lvl.getBlockState(bp).getValue((Property)MOVES) < 30) {
            lvl.setBlock(bp, (BlockState)bs.setValue((Property)MOVES, (Comparable)Integer.valueOf((Integer)bs.getValue((Property)MOVES) + 1)), 3);
            lvl.playSound(null, bp, SoundEvents.CRAFTER_CRAFT, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            lvl.setBlock(bp, Blocks.AIR.defaultBlockState(), 3);
            lvl.playSound(null, bp, SoundEvents.CHICKEN_EGG, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.generateReward(lvl, bs, bp);
        }
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)MOVES, (Comparable)Integer.valueOf(0));
    }

    public void generateReward(Level lvl, BlockState bs, BlockPos bp) {
        List<Item> itemsTier28 = List.of(Items.ENCHANTED_GOLDEN_APPLE, Items.EMERALD_BLOCK, Items.ECHO_SHARD, Items.DIAMOND_BLOCK, Items.TOTEM_OF_UNDYING);
        List<Item> itemsTier27 = List.of(Items.DIAMOND, Items.EMERALD, Items.GOLDEN_APPLE, Items.IRON_BLOCK);
        List<Item> itemsTier26 = List.of(Items.IRON_INGOT, Items.GOLD_INGOT, Items.APPLE, Items.COOKED_BEEF, Items.COOKIE, Items.GLOW_BERRIES, Items.HONEY_BOTTLE);
        List<Item> itemsTier25 = List.of(Items.BUCKET, Items.COD_BUCKET, Items.MILK_BUCKET, Items.SALMON_BUCKET, Items.LAVA_BUCKET, Items.POWDER_SNOW_BUCKET);
        List<Item> itemsTier0 = List.of(Items.DIRT, Items.STICK, Items.SAND, Items.DEAD_BUSH);
        List<Item> weaponsChoice = List.of(Items.GOLDEN_SWORD, Items.GOLDEN_AXE, Items.OAK_SIGN, Items.STICK);
        RandomSource rs = lvl.getRandom();
        ItemStack tier28 = new ItemStack((ItemLike)itemsTier28.get(rs.nextInt(itemsTier28.size())));
        ItemStack tier27 = new ItemStack((ItemLike)itemsTier27.get(rs.nextInt(itemsTier27.size())));
        ItemStack tier26 = new ItemStack((ItemLike)itemsTier26.get(rs.nextInt(itemsTier26.size())));
        ItemStack tier25 = new ItemStack((ItemLike)itemsTier25.get(rs.nextInt(itemsTier25.size())));
        ItemStack tier0 = new ItemStack((ItemLike)itemsTier0.get(rs.nextInt(itemsTier0.size())));
        ItemStack weapon = new ItemStack((ItemLike)weaponsChoice.get(rs.nextInt(weaponsChoice.size())));
        List<Holder<Enchantment>> eHolderList = List.of(OPUtil.getEnchantmentHolderFromKeyStatic(lvl, (ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT), OPUtil.getEnchantmentHolderFromKeyStatic(lvl, (ResourceKey<Enchantment>)Enchantments.SHARPNESS), OPUtil.getEnchantmentHolderFromKeyStatic(lvl, (ResourceKey<Enchantment>)Enchantments.KNOCKBACK), OPUtil.getEnchantmentHolderFromKeyStatic(lvl, (ResourceKey<Enchantment>)Enchantments.SMITE), OPUtil.getEnchantmentHolderFromKeyStatic(lvl, (ResourceKey<Enchantment>)Enchantments.SWEEPING_EDGE));
        Holder<Enchantment> holder = eHolderList.get(rs.nextInt(eHolderList.size()));
        int l = Mth.nextInt((RandomSource)lvl.random, (int)1, (int)3);
        weapon.enchant(holder, l);
        if ((Integer)bs.getValue((Property)MOVES) >= 28) {
            lvl.addFreshEntity((Entity)new ItemEntity(lvl, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), new ItemStack((ItemLike)tier28.getItem())));
        } else if ((Integer)bs.getValue((Property)MOVES) == 27) {
            lvl.addFreshEntity((Entity)new ItemEntity(lvl, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), new ItemStack((ItemLike)tier27.getItem())));
        } else if ((Integer)bs.getValue((Property)MOVES) == 26) {
            lvl.addFreshEntity((Entity)new ItemEntity(lvl, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), new ItemStack((ItemLike)tier26.getItem())));
        } else if ((Integer)bs.getValue((Property)MOVES) >= 20 && (Integer)bs.getValue((Property)MOVES) <= 25) {
            lvl.addFreshEntity((Entity)new ItemEntity(lvl, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), new ItemStack((ItemLike)tier25.getItem())));
        } else if ((Integer)bs.getValue((Property)MOVES) >= 15 && (Integer)bs.getValue((Property)MOVES) <= 19) {
            List<Block> blks1 = List.of(Blocks.OAK_LOG, Blocks.CAKE, Blocks.CALCITE, Blocks.TUFF, Blocks.DEEPSLATE, Blocks.MAGMA_BLOCK, Blocks.PACKED_ICE, Blocks.SPONGE, Blocks.WHITE_CONCRETE, Blocks.END_STONE, Blocks.INFESTED_STONE, Blocks.WATER, Blocks.CAMPFIRE, Blocks.AMETHYST_BLOCK);
            BlockState rBs1 = blks1.get(rs.nextInt(blks1.size())).defaultBlockState();
            if (rs.nextInt(100) <= 70) {
                if (!lvl.getBlockState(bp.below()).is(OMTags.PROBABLE_CANNOT_REPLACE)) {
                    lvl.setBlock(bp.below(), rBs1, 3);
                } else {
                    lvl.setBlock(bp, rBs1, 3);
                }
                float f1 = rs.nextFloat();
                if (f1 < 0.9f) {
                    f1 = 0.9f;
                }
                lvl.playSound((Entity)lvl.getNearestPlayer((double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), 5.0, true), bp, (SoundEvent)SoundEvents.AMBIENT_CAVE.value(), SoundSource.BLOCKS, 1.0f, f1);
            } else if (!lvl.getBlockState(bp.below()).is(OMTags.PROBABLE_CANNOT_REPLACE)) {
                lvl.destroyBlock(bp.below(), false, null);
                lvl.setBlock(bp.below(), Blocks.LAVA.defaultBlockState(), 3);
                Blaze blz1 = new Blaze(EntityType.BLAZE, lvl);
                blz1.setSilent(true);
                blz1.addEffect(new MobEffectInstance(MobEffects.HEALTH_BOOST, 1000, 20, true, false, false));
                blz1.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 1000, 2, true, false, false));
                blz1.setPos((double)bp.getX(), (double)bp.getY(), (double)bp.getZ());
                lvl.addFreshEntity((Entity)blz1);
            } else {
                lvl.setBlock(bp, Blocks.LAVA.defaultBlockState(), 3);
                this.failureMessage(lvl, bp);
            }
        } else if ((Integer)bs.getValue((Property)MOVES) >= 10 && (Integer)bs.getValue((Property)MOVES) <= 14) {
            if (rs.nextInt(0, 100) <= 2) {
                PrimedTnt tnt = new PrimedTnt(lvl, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), null);
                tnt.setBlockState(((Block)OMBlocks.MOVING_PROBABLE_BLOCK.get()).defaultBlockState());
                tnt.move(MoverType.PISTON, new Vec3(0.0, 10.0, 0.0));
                tnt.setFuse(7);
                lvl.addFreshEntity((Entity)tnt);
            } else if (rs.nextInt(0, 100) <= 15) {
                Stream bses = lvl.getBlockStates(new AABB(1.0, 1.0, 1.0, 1.0, 10.0, 1.0));
                if (bses.toList().stream().allMatch(BlockBehaviour.BlockStateBase::isAir)) {
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(7), (BlockState)Blocks.SNOW_BLOCK.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(5), (BlockState)Blocks.SNOW_BLOCK.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(9), (BlockState)Blocks.CARVED_PUMPKIN.defaultBlockState());
                } else {
                    lvl.addFreshEntity((Entity)new ItemEntity(lvl, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), new ItemStack((ItemLike)Items.SNOWBALL)));
                    lvl.setBlock(bp, Blocks.STONE_SLAB.defaultBlockState(), 3);
                    lvl.playSound((Entity)lvl.getNearestPlayer((double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), 5.0, true), bp, SoundEvents.VAULT_INSERT_ITEM_FAIL, SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.failureMessage(lvl, bp);
                }
            } else if (rs.nextInt(0, 100) <= 30) {
                if (lvl.getBlockState(bp.above()).is(Blocks.AIR) && lvl.getBlockState(bp.above().above()).is(Blocks.AIR) && lvl.getBlockState(bp.above().above().above()).is(Blocks.AIR)) {
                    lvl.setBlock(bp.above().above().above(), Blocks.BLACK_WOOL.defaultBlockState(), 3);
                    lvl.setBlock(bp.above().above(), (BlockState)Blocks.PISTON.defaultBlockState().setValue((Property)PistonBaseBlock.FACING, (Comparable)Direction.UP), 3);
                    lvl.setBlock(bp.above(), Blocks.REDSTONE_BLOCK.defaultBlockState(), 3);
                } else {
                    this.failureMessage(lvl, bp);
                }
            } else {
                Player player = lvl.getNearestPlayer((double)bp.getX() + 0.5, (double)bp.getY(), (double)bp.getZ() + 0.5, 15.0, false);
                Stream checkBlocksForCage = lvl.getBlockStates(new AABB(-1.0, 0.0, -1.0, 1.0, 21.0, 1.0));
                if (player != null && checkBlocksForCage.toList().stream().allMatch(BlockBehaviour.BlockStateBase::isAir)) {
                    player.playSound(SoundEvents.PILLAGER_CELEBRATE, 1.0f, 1.0f);
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX() - 1, player.getBlockY() + 1, player.getBlockZ() - 1), (BlockState)Blocks.IRON_BARS.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX(), player.getBlockY() + 1, player.getBlockZ() - 1), (BlockState)Blocks.IRON_BARS.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX() - 1, player.getBlockY() + 1, player.getBlockZ()), (BlockState)Blocks.IRON_BARS.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX() + 1, player.getBlockY() + 1, player.getBlockZ() + 1), (BlockState)Blocks.IRON_BARS.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX() + 1, player.getBlockY() + 1, player.getBlockZ()), (BlockState)Blocks.IRON_BARS.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX(), player.getBlockY() + 1, player.getBlockZ() + 1), (BlockState)Blocks.IRON_BARS.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX() - 1, player.getBlockY() + 1, player.getBlockZ() + 1), (BlockState)Blocks.IRON_BARS.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX() + 1, player.getBlockY() + 1, player.getBlockZ() - 1), (BlockState)Blocks.IRON_BARS.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX() - 1, player.getBlockY() + 2, player.getBlockZ() - 1), (BlockState)Blocks.IRON_BARS.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX(), player.getBlockY() + 2, player.getBlockZ() - 1), (BlockState)Blocks.IRON_BARS.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX() - 1, player.getBlockY() + 2, player.getBlockZ()), (BlockState)Blocks.IRON_BARS.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX() + 1, player.getBlockY() + 2, player.getBlockZ() + 1), (BlockState)Blocks.IRON_BARS.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX() + 1, player.getBlockY() + 2, player.getBlockZ()), (BlockState)Blocks.IRON_BARS.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX(), player.getBlockY() + 2, player.getBlockZ() + 1), (BlockState)Blocks.IRON_BARS.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX() - 1, player.getBlockY() + 2, player.getBlockZ() + 1), (BlockState)Blocks.IRON_BARS.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX() + 1, player.getBlockY() + 2, player.getBlockZ() - 1), (BlockState)Blocks.IRON_BARS.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX(), player.getBlockY() + 20, player.getBlockZ()), (BlockState)Blocks.DAMAGED_ANVIL.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)new BlockPos(player.getBlockX(), player.getBlockY(), player.getBlockZ()), (BlockState)Blocks.LAVA_CAULDRON.defaultBlockState());
                    player.addEffect(new MobEffectInstance(MobEffects.SLOWNESS, 10, 10, true, false));
                    player.setTicksFrozen(100);
                } else {
                    this.failureMessage(lvl, bp);
                }
            }
        } else if ((Integer)bs.getValue((Property)MOVES) >= 5 && (Integer)bs.getValue((Property)MOVES) <= 9) {
            if (rs.nextInt(100) <= 3) {
                Stream bses2 = lvl.getBlockStates(new AABB(1.0, 1.0, 1.0, 1.0, 16.0, 1.0));
                if (bses2.toList().stream().allMatch(BlockBehaviour.BlockStateBase::isAir)) {
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(2), (BlockState)Blocks.RED_WOOL.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(4), (BlockState)Blocks.ORANGE_WOOL.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(6), (BlockState)Blocks.YELLOW_WOOL.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(8), (BlockState)Blocks.LIME_WOOL.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(10), (BlockState)Blocks.BLUE_WOOL.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(12), (BlockState)Blocks.PURPLE_WOOL.defaultBlockState());
                    FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(14), (BlockState)Blocks.GOLD_ORE.defaultBlockState());
                } else {
                    this.failureMessage(lvl, bp);
                }
            } else if (rs.nextInt(100) <= 10) {
                if (lvl.getNearestPlayer((double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), 10.0, true) != null) {
                    List<Holder> effects = List.of(MobEffects.WITHER, MobEffects.WEAKNESS, MobEffects.NAUSEA, MobEffects.UNLUCK, MobEffects.POISON, MobEffects.SLOWNESS, MobEffects.MINING_FATIGUE);
                    lvl.getNearestPlayer((double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), 10.0, true).addEffect(new MobEffectInstance(effects.get(rs.nextInt(effects.size())), rs.nextInt(90, 120), rs.nextInt(1, 2), true, false, false));
                }
            } else {
                List<Item> itemsTier1 = List.of(Items.OAK_LOG, Items.BIRCH_LOG, Items.ANDESITE, Items.DIORITE, Items.GRANITE);
                ItemStack tier1 = new ItemStack((ItemLike)itemsTier1.get(rs.nextInt(itemsTier1.size())));
                lvl.addFreshEntity((Entity)new ItemEntity(lvl, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), tier1));
            }
        } else if (rs.nextInt(72) <= 5) {
            lvl.explode(null, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), 5.0f, Level.ExplosionInteraction.NONE);
        } else if (rs.nextInt(42) <= 10) {
            int r1 = rs.nextInt(0, 100);
            if (r1 >= 0 && r1 <= 5) {
                PrimedTnt tnt = new PrimedTnt(lvl, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), null);
                tnt.setFuse(20);
                tnt.displayFireAnimation();
                lvl.addFreshEntity((Entity)tnt);
            } else if (r1 > 5 && r1 <= 15) {
                Stream bses2 = lvl.getBlockStates(new AABB(1.0, 1.0, 1.0, 1.0, 16.0, 1.0));
                if (bses2.toList().stream().allMatch(BlockBehaviour.BlockStateBase::isAir)) {
                    Holder.Reference blockRef = (Holder.Reference)BuiltInRegistries.BLOCK.getRandom(lvl.getRandom()).get();
                    if (blockRef.is(OMTags.BANNED_PROBABLE_REWARD_BLOCKS) || blockRef.value() instanceof LeavesBlock || blockRef.value() instanceof WaterlilyBlock || blockRef.value() instanceof WallBlock || blockRef.value() instanceof LanternBlock || blockRef.value() instanceof CakeBlock || blockRef.value() instanceof CandleCakeBlock || blockRef.value() instanceof IronBarsBlock || blockRef.value() instanceof StainedGlassPaneBlock || blockRef.value() instanceof CocoaBlock || blockRef.value() instanceof SlabBlock || blockRef.value() instanceof StairBlock || blockRef.value() instanceof SaplingBlock || blockRef.value() instanceof TurtleEggBlock || blockRef.value() instanceof FenceBlock || blockRef.value() instanceof FenceGateBlock || blockRef.value() instanceof CropBlock || blockRef.value() instanceof SoulFireBlock || blockRef.value() instanceof FireBlock || blockRef.value() instanceof SkullBlock || blockRef.value() instanceof WallSkullBlock || blockRef.value() instanceof TorchBlock || blockRef.value() instanceof WallTorchBlock || blockRef.value() instanceof SignBlock || blockRef.value() instanceof WallSignBlock || blockRef.value() instanceof FarmBlock || blockRef.value() instanceof KelpBlock || blockRef.value() instanceof KelpPlantBlock || blockRef.value() instanceof CoralBlock || blockRef.value() instanceof CoralFanBlock || blockRef.value() instanceof CoralPlantBlock || blockRef.value() instanceof CoralWallFanBlock || blockRef.value() instanceof DoorBlock || blockRef.value() instanceof DoublePlantBlock || blockRef.value() instanceof GameMasterBlock || blockRef.value() instanceof EntityBlock || blockRef.value() instanceof LiquidBlock || blockRef.value() instanceof AirBlock || blockRef.value() instanceof MovingPistonBlock) {
                        if (lvl.getRandom().nextIntBetweenInclusive(0, 10) <= 2) {
                            FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(2), (BlockState)Blocks.COBBLESTONE.defaultBlockState());
                            lvl.playSound(null, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), SoundEvents.HORSE_ANGRY, SoundSource.BLOCKS, 0.7f, 1.0f);
                        }
                    } else if (blockRef.value() instanceof RedStoneOreBlock) {
                        int b1 = lvl.getRandom().nextIntBetweenInclusive(0, 10);
                        if (b1 <= 3) {
                            FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(7), (BlockState)Blocks.REDSTONE_BLOCK.defaultBlockState());
                            FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(9), (BlockState)Blocks.TNT.defaultBlockState());
                        } else if (b1 >= 8) {
                            FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(11), (BlockState)Blocks.RED_WOOL.defaultBlockState());
                        } else {
                            FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(6), (BlockState)Blocks.RED_CONCRETE.defaultBlockState());
                        }
                    } else if (((Block)blockRef.value()).getStateDefinition().getProperties().contains(BlockStateProperties.WATERLOGGED)) {
                        FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(12), (BlockState)Blocks.BLUE_CONCRETE.defaultBlockState());
                    } else {
                        FallingBlockEntity.fall((Level)lvl, (BlockPos)bp.above(8), (BlockState)((Block)blockRef.value()).defaultBlockState());
                    }
                } else {
                    this.failureMessage(lvl, bp);
                }
            } else {
                this.failureMessage(lvl, bp);
            }
        } else if (rs.nextInt(32) <= 7) {
            MagmaCube magmacube = new MagmaCube(EntityType.MAGMA_CUBE, lvl);
            magmacube.setPos((double)bp.getX(), (double)bp.getY(), (double)bp.getZ());
            magmacube.setSize(1, true);
            if (magmacube.getAttributes().hasAttribute(Attributes.SCALE) && magmacube.getAttributes().hasAttribute(Attributes.ATTACK_KNOCKBACK)) {
                magmacube.getAttribute(Attributes.SCALE).setBaseValue(3.0);
                magmacube.getAttribute(Attributes.ATTACK_KNOCKBACK).setBaseValue(10.0);
            }
            lvl.addFreshEntity((Entity)magmacube);
        } else if (rs.nextInt(32) <= 5) {
            ItemStack bowOP = new ItemStack((ItemLike)Items.BOW);
            ItemStack swordOP = new ItemStack((ItemLike)Items.STONE_SWORD);
            List<Holder<Enchantment>> eHolderListBow = List.of(OPUtil.getEnchantmentHolderFromKeyStatic(lvl, (ResourceKey<Enchantment>)Enchantments.FLAME), OPUtil.getEnchantmentHolderFromKeyStatic(lvl, (ResourceKey<Enchantment>)Enchantments.MULTISHOT), OPUtil.getEnchantmentHolderFromKeyStatic(lvl, (ResourceKey<Enchantment>)Enchantments.PUNCH), OPUtil.getEnchantmentHolderFromKeyStatic(lvl, (ResourceKey<Enchantment>)Enchantments.QUICK_CHARGE));
            List<Holder<Enchantment>> eHolderListSword = List.of(OPUtil.getEnchantmentHolderFromKeyStatic(lvl, (ResourceKey<Enchantment>)Enchantments.SHARPNESS), OPUtil.getEnchantmentHolderFromKeyStatic(lvl, (ResourceKey<Enchantment>)Enchantments.FIRE_ASPECT), OPUtil.getEnchantmentHolderFromKeyStatic(lvl, (ResourceKey<Enchantment>)Enchantments.SWEEPING_EDGE));
            Holder<Enchantment> holderBow = eHolderListBow.get(rs.nextInt(eHolderListBow.size()));
            Holder<Enchantment> holderSword = eHolderListSword.get(rs.nextInt(eHolderListSword.size()));
            int l2 = Mth.nextInt((RandomSource)lvl.random, (int)2, (int)5);
            bowOP.enchant(holderBow, l2);
            swordOP.enchant(holderSword, l2);
            Stray stray = new Stray(EntityType.STRAY, lvl);
            int randomIntForEntitySelection = lvl.getRandom().nextIntBetweenInclusive(1, 4);
            switch (randomIntForEntitySelection) {
                case 1: {
                    stray = new Stray(EntityType.STRAY, lvl);
                    break;
                }
                case 2: {
                    stray = new Drowned(EntityType.DROWNED, lvl);
                    break;
                }
                case 3: {
                    stray = new ZombifiedPiglin(EntityType.ZOMBIFIED_PIGLIN, lvl);
                    break;
                }
                case 4: {
                    stray = new Husk(EntityType.HUSK, lvl);
                }
            }
            if (stray == null) {
                return;
            }
            stray.setPos((double)bp.getX(), (double)bp.getY(), (double)bp.getZ());
            stray.setItemSlot(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.END_ROD));
            stray.setItemSlot(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.LEATHER_BOOTS));
            if (stray instanceof AbstractSkeleton) {
                stray.setItemSlot(EquipmentSlot.MAINHAND, bowOP);
            } else {
                stray.setItemSlot(EquipmentSlot.MAINHAND, swordOP);
            }
            stray.setItemSlot(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.SHIELD));
            stray.setDropChance(EquipmentSlot.HEAD, 0.0f);
            stray.setDropChance(EquipmentSlot.FEET, 0.01f);
            stray.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
            stray.setDropChance(EquipmentSlot.OFFHAND, 0.0f);
            if (stray.getAttributes().hasAttribute(Attributes.SCALE) && stray.getAttributes().hasAttribute(Attributes.MAX_HEALTH)) {
                stray.getAttribute(Attributes.SCALE).setBaseValue(1.5);
                stray.getAttribute(Attributes.MAX_HEALTH).setBaseValue(40.0);
                stray.heal(40.0f);
            }
            lvl.addFreshEntity((Entity)stray);
        } else if (rs.nextInt(100) <= 1) {
            if (rs.nextInt(75) <= 35) {
                lvl.setBlock(bp, ((Block)OMBlocks.MOVING_PROBABLE_BLOCK.get()).defaultBlockState(), 3);
            } else {
                lvl.setBlock(bp, Blocks.STONE.defaultBlockState(), 3);
            }
        } else if (rs.nextInt(50) <= 2) {
            for (int lcount = 1; lcount < 5; ++lcount) {
                LightningBolt lb = new LightningBolt(EntityType.LIGHTNING_BOLT, lvl);
                lb.setSilent(true);
                if (rs.nextInt(100) <= 50) {
                    lb.setPos((double)(bp.getX() + rs.nextInt(lcount)), (double)bp.getY(), (double)(bp.getZ() + rs.nextInt(lcount)));
                } else {
                    lb.setPos((double)(bp.getX() - rs.nextInt(lcount)), (double)bp.getY(), (double)(bp.getZ() - rs.nextInt(lcount)));
                }
                lvl.addFreshEntity((Entity)lb);
            }
        } else if (rs.nextInt(100) <= 3) {
            if (!lvl.isClientSide) {
                if (rs.nextInt(100) <= 30) {
                    Skeleton s1 = new Skeleton(EntityType.SKELETON, lvl);
                    s1.setItemSlot(EquipmentSlot.MAINHAND, weapon);
                    s1.setItemSlot(EquipmentSlot.HEAD, Items.DARK_OAK_FENCE_GATE.getDefaultInstance());
                    s1.setPos((double)bp.getX(), (double)bp.getY(), (double)bp.getZ());
                    s1.setDropChance(EquipmentSlot.HEAD, 0.0f);
                    s1.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
                    List<Holder> effects = List.of(MobEffects.INFESTED, MobEffects.OOZING, MobEffects.WEAVING, MobEffects.WIND_CHARGED);
                    s1.addEffect(new MobEffectInstance(effects.get(rs.nextInt(effects.size())), 1000, 1, true, false, false));
                    lvl.gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, bp);
                    lvl.addFreshEntity((Entity)s1);
                } else {
                    Zombie z1 = new Zombie(lvl);
                    z1.setItemSlot(EquipmentSlot.MAINHAND, weapon);
                    z1.setItemSlot(EquipmentSlot.HEAD, Items.CREEPER_HEAD.getDefaultInstance());
                    z1.setPos((double)bp.getX(), (double)bp.getY(), (double)bp.getZ());
                    z1.setDropChance(EquipmentSlot.HEAD, 0.0f);
                    z1.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
                    lvl.gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, bp);
                    lvl.addFreshEntity((Entity)z1);
                }
            }
        } else {
            lvl.addFreshEntity((Entity)new ItemEntity(lvl, (double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), tier0));
        }
    }

    private void failureMessage(Level lvl, BlockPos bp) {
        if (lvl.getNearestPlayer((double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), 5.0, true) != null) {
            lvl.getNearestPlayer((double)bp.getX(), (double)bp.getY(), (double)bp.getZ(), 5.0, true).displayClientMessage((Component)Component.translatable((String)"message.thingamajigsgoodies.moving_probable_block.no_fun"), true);
        }
    }
}

