/*
 * Decompiled with CFR 0.152.
 */
package net.rk.overpoweredmastery.datagen;

import java.util.List;
import java.util.Set;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.rk.overpoweredmastery.datagen.OMBlockTag;
import net.rk.overpoweredmastery.datagen.OMEnchantmentTags;
import net.rk.overpoweredmastery.datagen.OMEntityTag;
import net.rk.overpoweredmastery.datagen.OMItemTag;
import net.rk.overpoweredmastery.datagen.OMLang;
import net.rk.overpoweredmastery.datagen.OMLoot;
import net.rk.overpoweredmastery.datagen.OMModels;
import net.rk.overpoweredmastery.datagen.OMRecipe;
import net.rk.overpoweredmastery.datagen.OMSound;

@EventBusSubscriber(modid="overpoweredmastery")
public class DataGen {
    @SubscribeEvent
    public static void gatherDataClient(GatherDataEvent.Client event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        gen.addProvider(true, (DataProvider)new OMEnchantmentTags(packOutput, event.getLookupProvider()));
        gen.addProvider(true, (DataProvider)new OMSound(packOutput));
        gen.addProvider(true, (DataProvider)new OMLang(packOutput));
        gen.addProvider(true, (DataProvider)new OMModels(packOutput));
        gen.addProvider(true, (DataProvider)new LootTableProvider(packOutput, Set.of(), List.of(new LootTableProvider.SubProviderEntry(OMLoot::new, LootContextParamSets.BLOCK)), event.getLookupProvider()));
        gen.addProvider(true, (DataProvider)new OMEntityTag(packOutput, event.getLookupProvider()));
        gen.addProvider(true, (DataProvider)new OMItemTag(packOutput, event.getLookupProvider()));
        gen.addProvider(true, (DataProvider)new OMBlockTag(packOutput, event.getLookupProvider()));
        gen.addProvider(true, (DataProvider)new OMRecipe.RecipeRunner(packOutput, event.getLookupProvider()));
    }
}

